/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.RequestExecutor;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.ServerObjectType;
import com.impossibl.postgres.protocol.TypeRef;
import com.impossibl.postgres.protocol.v30.ProtocolChannel;
import com.impossibl.postgres.protocol.v30.ProtocolHandler;
import com.impossibl.postgres.protocol.v30.ServerRequest;
import com.impossibl.postgres.system.Empty;
import com.impossibl.postgres.system.NoticeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PrepareRequest
implements ServerRequest {
    private String query;
    private String statementName;
    private TypeRef[] suggestedParameterTypes;
    private RequestExecutor.PrepareHandler handler;
    private TypeRef[] describedParameterTypes;
    private List<Notice> notices;

    PrepareRequest(String statementName, String query, TypeRef[] suggestedParameterTypes, RequestExecutor.PrepareHandler handler) {
        this.statementName = statementName;
        this.query = query;
        this.suggestedParameterTypes = suggestedParameterTypes;
        this.handler = handler;
        this.notices = new ArrayList<Notice>();
    }

    @Override
    public ProtocolHandler createHandler() {
        return new Handler();
    }

    @Override
    public void execute(ProtocolChannel channel) throws IOException {
        channel.writeParse(this.statementName, this.query, this.suggestedParameterTypes).writeDescribe(ServerObjectType.Statement, this.statementName).writeSync().flush();
    }

    static /* synthetic */ TypeRef[] access$002(PrepareRequest x0, TypeRef[] x1) {
        x0.describedParameterTypes = x1;
        return x1;
    }

    private class Handler
    implements ProtocolHandler.ParameterDescriptions,
    ProtocolHandler.RowDescription,
    ProtocolHandler.NoData,
    ProtocolHandler.ReportNotice,
    ProtocolHandler.ParseComplete,
    ProtocolHandler.CommandError {
        private Handler() {
        }

        public String toString() {
            return "Prepare";
        }

        @Override
        public ProtocolHandler.Action parseComplete() {
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action parameterDescriptions(TypeRef[] types) {
            PrepareRequest.access$002(PrepareRequest.this, types);
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action rowDescription(ResultField[] fields) throws IOException {
            PrepareRequest.this.handler.handleComplete(PrepareRequest.this.describedParameterTypes, fields, PrepareRequest.this.notices);
            return ProtocolHandler.Action.Sync;
        }

        @Override
        public ProtocolHandler.Action noData() throws IOException {
            PrepareRequest.this.handler.handleComplete(PrepareRequest.this.describedParameterTypes, Empty.EMPTY_FIELDS, PrepareRequest.this.notices);
            return ProtocolHandler.Action.Sync;
        }

        @Override
        public ProtocolHandler.Action notice(Notice notice) {
            PrepareRequest.this.notices.add(notice);
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action error(Notice error) throws IOException {
            PrepareRequest.this.handler.handleError(new NoticeException(error), PrepareRequest.this.notices);
            return ProtocolHandler.Action.Sync;
        }

        @Override
        public void exception(Throwable cause) throws IOException {
            PrepareRequest.this.handler.handleError(cause, PrepareRequest.this.notices);
        }
    }
}

