/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.ErrorUtils;
import com.impossibl.postgres.jdbc.PGDirectConnection;
import com.impossibl.postgres.jdbc.PGSQLSimpleException;
import com.impossibl.postgres.jdbc.Query;
import com.impossibl.postgres.protocol.FieldFormatRef;
import com.impossibl.postgres.protocol.RequestExecutorHandlers;
import com.impossibl.postgres.protocol.ResultBatch;
import com.impossibl.postgres.protocol.ResultBatches;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.utils.Nulls;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class PreparedQuery
implements Query {
    private String statementName;
    private FieldFormatRef[] parameterFormats;
    private ByteBuf[] parameterBuffers;
    private ResultField[] resultFields;
    private String portalName;
    private Query.Status status;
    private Long timeout;
    private int maxRows;
    private ResultBatch resultBatch;

    PreparedQuery(String statementName, FieldFormatRef[] parameterFormats, ByteBuf[] parameterBuffers, ResultField[] resultFields) {
        this.statementName = statementName;
        this.parameterFormats = parameterFormats;
        this.parameterBuffers = parameterBuffers;
        this.resultFields = resultFields;
        this.status = Query.Status.Initialized;
    }

    @Override
    public Query.Status getStatus() {
        return this.status;
    }

    @Override
    public Long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public List<ResultBatch> getResultBatches() {
        return new ArrayList<ResultBatch>(Collections.singletonList(this.resultBatch));
    }

    private boolean requiresPortal() {
        return this.maxRows > 0;
    }

    private SQLWarning executeStatement(PGDirectConnection connection) throws SQLException {
        this.portalName = this.requiresPortal() ? connection.getNextPortalName() : null;
        RequestExecutorHandlers.ExecuteResult result = connection.executeTimed(this.timeout, timeout -> {
            RequestExecutorHandlers.ExecuteResult handler = new RequestExecutorHandlers.ExecuteResult(!this.requiresPortal(), this.resultFields);
            connection.getRequestExecutor().execute(this.portalName, this.statementName, this.parameterFormats, this.parameterBuffers, this.resultFields, this.maxRows, handler);
            handler.await(timeout, TimeUnit.MILLISECONDS);
            return handler;
        });
        return this.applyResult(connection, result);
    }

    private SQLWarning resumeStatement(PGDirectConnection connection) throws SQLException {
        RequestExecutorHandlers.ExecuteResult result = connection.executeTimed(this.timeout, timeout -> {
            RequestExecutorHandlers.ExecuteResult handler = new RequestExecutorHandlers.ExecuteResult(false, this.resultFields);
            connection.getRequestExecutor().resume(this.portalName, Nulls.firstNonNull(this.maxRows, 0), handler);
            handler.await(timeout, TimeUnit.MILLISECONDS);
            return handler;
        });
        return this.applyResult(connection, result);
    }

    private SQLWarning applyResult(PGDirectConnection connection, RequestExecutorHandlers.ExecuteResult result) throws SQLException {
        this.resultBatch = result.getBatch();
        try {
            ResultBatches.transformFieldTypes(this.resultBatch, connection.getRegistry()::resolve);
        }
        catch (IOException e) {
            throw ErrorUtils.makeSQLException(e);
        }
        if (result.isSuspended()) {
            this.status = Query.Status.Suspended;
        } else if (this.portalName != null) {
            connection.execute((long timeout) -> {
                RequestExecutorHandlers.SynchronizedResult handler = new RequestExecutorHandlers.SynchronizedResult();
                connection.getRequestExecutor().finish(this.portalName, handler);
                handler.await(timeout, TimeUnit.MILLISECONDS);
            });
            this.portalName = null;
        }
        return ErrorUtils.chainWarnings(null, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning execute(PGDirectConnection connection) throws SQLException {
        boolean wasSuspended = this.status == Query.Status.Suspended;
        this.status = Query.Status.InProgress;
        try {
            if (wasSuspended) {
                if (this.portalName == null) {
                    throw new PGSQLSimpleException("Illegal query state - suspended with no portal");
                }
                SQLWarning sQLWarning = this.resumeStatement(connection);
                return sQLWarning;
            }
            SQLWarning sQLWarning = this.executeStatement(connection);
            return sQLWarning;
        }
        finally {
            if (this.status == Query.Status.InProgress) {
                this.status = Query.Status.Completed;
            }
        }
    }

    @Override
    public void dispose(PGDirectConnection connection) throws SQLException {
        if (this.portalName != null) {
            connection.execute((long timeout) -> {
                RequestExecutorHandlers.SynchronizedResult handler = new RequestExecutorHandlers.SynchronizedResult();
                connection.getRequestExecutor().finish(this.portalName, handler);
                handler.await(timeout, TimeUnit.MILLISECONDS);
            });
        }
    }

    public String toString() {
        return "PreparedQuery{statementName='" + this.statementName + '\'' + ", portalName='" + this.portalName + '\'' + ", status=" + (Object)((Object)this.status) + '}';
    }
}

