/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.JavaTypeMapping;
import com.impossibl.postgres.system.SystemSettings;
import com.impossibl.postgres.system.procs.AutoConvertingBinaryDecoder;
import com.impossibl.postgres.system.procs.AutoConvertingTextDecoder;
import com.impossibl.postgres.system.procs.BaseBinaryEncoder;
import com.impossibl.postgres.system.procs.BaseTextEncoder;
import com.impossibl.postgres.system.procs.Bools;
import com.impossibl.postgres.system.procs.Bytes;
import com.impossibl.postgres.system.procs.Float4s;
import com.impossibl.postgres.system.procs.Float8s;
import com.impossibl.postgres.system.procs.Int2s;
import com.impossibl.postgres.system.procs.Int4s;
import com.impossibl.postgres.system.procs.Int8s;
import com.impossibl.postgres.system.procs.Numerics;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Modifiers;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public class Strings
extends SimpleProcProvider {
    static final BinDecoder BINARY_DECODER = new BinDecoder();
    static final BinEncoder BINARY_ENCODER = new BinEncoder();
    static final TxtDecoder TEXT_DECODER = new TxtDecoder();
    static final TxtEncoder TEXT_ENCODER = new TxtEncoder();
    private static Bools.TxtDecoder boolDecoder = new Bools.TxtDecoder();
    private static Bools.TxtEncoder boolEncoder = new Bools.TxtEncoder();
    private static Int2s.TxtDecoder shortDecoder = new Int2s.TxtDecoder();
    private static Int2s.TxtEncoder shortEncoder = new Int2s.TxtEncoder();
    private static Int4s.TxtDecoder intDecoder = new Int4s.TxtDecoder();
    private static Int4s.TxtEncoder intEncoder = new Int4s.TxtEncoder();
    private static Int8s.TxtDecoder longDecoder = new Int8s.TxtDecoder();
    private static Int8s.TxtEncoder longEncoder = new Int8s.TxtEncoder();
    private static Float4s.TxtDecoder floatDecoder = new Float4s.TxtDecoder();
    private static Float4s.TxtEncoder floatEncoder = new Float4s.TxtEncoder();
    private static Float8s.TxtDecoder doubleDecoder = new Float8s.TxtDecoder();
    private static Float8s.TxtEncoder doubleEncoder = new Float8s.TxtEncoder();
    private static Numerics.TxtDecoder decimalDecoder = new Numerics.TxtDecoder();
    private static Numerics.TxtEncoder decimalEncoder = new Numerics.TxtEncoder();
    private static Bytes.TxtEncoder bytesEncoder = new Bytes.TxtEncoder();

    public Strings() {
        super((Type.Codec.Encoder<StringBuilder>)TEXT_ENCODER, (Type.Codec.Decoder<CharSequence>)TEXT_DECODER, (Type.Codec.Encoder<ByteBuf>)BINARY_ENCODER, (Type.Codec.Decoder<ByteBuf>)BINARY_DECODER, new ModParser(), "text", "varchar", "bpchar", "char", "enum_", "json_", "cstring_", "citext", "unknown", "regproc", "regtype", "regclass", "regoper");
    }

    private static String convertInput(Context context, Object value, Object sourceContext) throws IOException {
        if (value instanceof CharSequence) {
            return value.toString();
        }
        StringBuilder out = new StringBuilder();
        if (value instanceof Character) {
            out.append(value);
        } else if (value instanceof Boolean) {
            boolEncoder.encodeNativeValue(context, (Type)null, (Boolean)value, sourceContext, out);
        } else if (value instanceof Short) {
            shortEncoder.encodeNativeValue(context, (Type)null, (Short)value, sourceContext, out);
        } else if (value instanceof Integer) {
            intEncoder.encodeNativeValue(context, (Type)null, (Integer)value, sourceContext, out);
        } else if (value instanceof Long) {
            longEncoder.encodeNativeValue(context, (Type)null, (Long)value, sourceContext, out);
        } else if (value instanceof Float) {
            floatEncoder.encodeNativeValue(context, (Type)null, (Float)value, sourceContext, out);
        } else if (value instanceof Double) {
            doubleEncoder.encodeNativeValue(context, (Type)null, (Double)value, sourceContext, out);
        } else if (value instanceof BigDecimal) {
            decimalEncoder.encodeNativeValue(context, (Type)null, (BigDecimal)value, sourceContext, out);
        } else if (value instanceof byte[]) {
            bytesEncoder.encodeValue(context, null, value, sourceContext, out);
        } else {
            out.append(value);
        }
        return out.toString();
    }

    private static Object convertOutput(Context context, String decoded, Class<?> targetClass, Object targetContext) throws IOException {
        try {
            if (targetClass == String.class) {
                return decoded;
            }
            Type type = JavaTypeMapping.getType(targetClass, context.getRegistry());
            if (type != null && type.getTextCodec() != null) {
                return type.getTextCodec().getDecoder().decode(context, type, null, null, decoded, targetClass, targetContext);
            }
            if (targetClass == Boolean.class || targetClass == Boolean.TYPE) {
                return boolDecoder.decodeNativeValue(context, (Type)null, (Short)null, (Integer)null, (CharSequence)decoded, (Class)Boolean.class, targetContext);
            }
            if (targetClass == Byte.class || targetClass == Byte.TYPE) {
                return Byte.valueOf(decoded);
            }
            if (targetClass == Short.class || targetClass == Short.TYPE) {
                return shortDecoder.decodeNativeValue(context, (Type)null, (Short)null, (Integer)null, (CharSequence)decoded, (Class)Short.class, targetContext);
            }
            if (targetClass == Integer.class || targetClass == Integer.TYPE) {
                return intDecoder.decodeNativeValue(context, (Type)null, (Short)null, (Integer)null, (CharSequence)decoded, (Class)Integer.class, targetContext);
            }
            if (targetClass == Long.class || targetClass == Long.TYPE) {
                return longDecoder.decodeNativeValue(context, (Type)null, (Short)null, (Integer)null, (CharSequence)decoded, (Class)Long.class, targetContext);
            }
            if (targetClass == BigInteger.class) {
                return new BigInteger(decoded);
            }
            if (targetClass == Float.class || targetClass == Float.TYPE) {
                return floatDecoder.decodeNativeValue(context, (Type)null, (Short)null, (Integer)null, (CharSequence)decoded, (Class)Float.class, targetContext);
            }
            if (targetClass == Double.class || targetClass == Double.TYPE) {
                return doubleDecoder.decodeNativeValue(context, (Type)null, (Short)null, (Integer)null, (CharSequence)decoded, (Class)Double.class, targetContext);
            }
            if (targetClass == BigDecimal.class) {
                return decimalDecoder.decodeNativeValue(context, (Type)null, (Short)null, (Integer)null, (CharSequence)decoded, (Class)BigDecimal.class, targetContext);
            }
            if (targetClass == URL.class) {
                return new URL(decoded);
            }
            return null;
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    private static class ModParser
    implements Modifiers.Parser {
        private ModParser() {
        }

        @Override
        public Map<String, Object> parse(long mod) {
            HashMap<String, Object> mods = new HashMap<String, Object>();
            if (mod > 4L) {
                mods.put("length", (int)(mod - 4L));
            }
            return mods;
        }
    }

    public static class TxtEncoder
    extends BaseTextEncoder {
        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, StringBuilder buffer) throws IOException {
            buffer.append(Strings.convertInput(context, value, sourceContext));
        }
    }

    public static class TxtDecoder
    extends AutoConvertingTextDecoder<String> {
        TxtDecoder() {
            super((Context x$0, N x$1, Class<?> x$2, Object x$3) -> Strings.convertOutput(x$0, x$1, x$2, x$3));
            this.enableRespectMaxLength();
        }

        @Override
        public Class<String> getDefaultClass() {
            return String.class;
        }

        @Override
        protected String decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            CharSequence value = buffer;
            Integer maxLength = context.getSetting(SystemSettings.FIELD_LENGTH_MAX);
            if (maxLength != null) {
                value = value.subSequence(0, maxLength);
            }
            return value.toString();
        }
    }

    public static class BinEncoder
    extends BaseBinaryEncoder {
        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, ByteBuf buffer) throws IOException {
            buffer.writeCharSequence((CharSequence)Strings.convertInput(context, value, sourceContext), context.getCharset());
        }
    }

    public static class BinDecoder
    extends AutoConvertingBinaryDecoder<String> {
        public BinDecoder() {
            super(null, (Context x$0, N x$1, Class<?> x$2, Object x$3) -> Strings.convertOutput(x$0, x$1, x$2, x$3));
            this.enableRespectMaxLength();
        }

        @Override
        public Class<String> getDefaultClass() {
            return String.class;
        }

        @Override
        protected String decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            int length = buffer.readableBytes();
            byte[] bytes = new byte[length];
            buffer.readBytes(bytes);
            buffer.skipBytes(length - bytes.length);
            CharSequence value = new String(bytes, context.getCharset());
            Integer maxLength = context.getSetting(SystemSettings.FIELD_LENGTH_MAX);
            if (maxLength != null) {
                value = value.subSequence(0, maxLength);
            }
            return value.toString();
        }
    }
}

