/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.api.jdbc.PGType;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.procs.BaseBinaryDecoder;
import com.impossibl.postgres.system.procs.BaseBinaryEncoder;
import com.impossibl.postgres.system.procs.BaseTextDecoder;
import com.impossibl.postgres.system.procs.BaseTextEncoder;
import com.impossibl.postgres.system.procs.Bytes;
import com.impossibl.postgres.system.procs.MacAddrs;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class MacAddr8s
extends SimpleProcProvider {
    public MacAddr8s() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "macaddr8_");
    }

    private static byte[] convertInput(Type type, Object value) throws ConversionException {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return MacAddr8s.parse((String)value);
        }
        throw new ConversionException(value.getClass(), type);
    }

    private static Object convertOutput(Type type, byte[] value, Class<?> targetClass) throws ConversionException {
        if (targetClass == byte[].class) {
            return value;
        }
        if (targetClass == String.class) {
            StringBuilder bldr = new StringBuilder();
            MacAddrs.format(value, bldr);
            return bldr.toString();
        }
        throw new ConversionException(type, targetClass);
    }

    static byte[] parse(String value) throws ConversionException {
        byte[] bytes = Bytes.decodeHex(value, true);
        if (bytes.length != 8) {
            throw new ConversionException("Invalid Mac address: " + value);
        }
        return bytes;
    }

    static class TxtEncoder
    extends BaseTextEncoder {
        TxtEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, StringBuilder buffer) throws IOException {
            byte[] addr = MacAddr8s.convertInput(type, value);
            MacAddrs.format(addr, buffer);
        }
    }

    static class TxtDecoder
    extends BaseTextDecoder {
        TxtDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return PGType.MACADDR8.getJavaType();
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException {
            byte[] value = MacAddr8s.parse(buffer.toString());
            return MacAddr8s.convertOutput(type, value, targetClass);
        }
    }

    static class BinEncoder
    extends BaseBinaryEncoder {
        BinEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, ByteBuf buffer) throws IOException {
            byte[] bytes = MacAddr8s.convertInput(type, value);
            buffer.writeBytes(bytes);
        }
    }

    static class BinDecoder
    extends BaseBinaryDecoder {
        BinDecoder() {
            super(8);
        }

        @Override
        public Class<?> getDefaultClass() {
            return PGType.MACADDR8.getJavaType();
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            byte[] bytes = new byte[8];
            buffer.readBytes(bytes);
            return MacAddr8s.convertOutput(type, bytes, targetClass);
        }
    }
}

