/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.procs.NumericBinaryDecoder;
import com.impossibl.postgres.system.procs.NumericBinaryEncoder;
import com.impossibl.postgres.system.procs.NumericTextDecoder;
import com.impossibl.postgres.system.procs.NumericTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.text.ParseException;

public class Float4s
extends SimpleProcProvider {
    public Float4s() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "float4");
    }

    private static Float convertStringInput(Context context, String value) throws ConversionException {
        try {
            return Float.valueOf(context.getClientDecimalFormatter().parse(value).floatValue());
        }
        catch (ParseException e) {
            throw new ConversionException("Invalid Long", e);
        }
    }

    private static String convertStringOutput(Context context, Number number) {
        return context.getClientDecimalFormatter().format(number);
    }

    static class TxtEncoder
    extends NumericTextEncoder<Float> {
        TxtEncoder() {
            super((x$0, x$1) -> Float4s.convertStringInput(x$0, x$1), val -> Float.valueOf(val != false ? 1.0f : 0.0f), Number::floatValue);
        }

        @Override
        public Class<Float> getDefaultClass() {
            return Float.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Float value, Object sourceContext, StringBuilder buffer) throws IOException {
            buffer.append(value);
        }
    }

    static class TxtDecoder
    extends NumericTextDecoder<Float> {
        protected TxtDecoder() {
            super((Context x$0, N x$1) -> Float4s.convertStringOutput(x$0, x$1));
        }

        @Override
        public Class<Float> getDefaultClass() {
            return Float.class;
        }

        @Override
        protected Float decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            return Float.valueOf(buffer.toString());
        }
    }

    static class BinEncoder
    extends NumericBinaryEncoder<Float> {
        BinEncoder() {
            super(4, (x$0, x$1) -> Float4s.convertStringInput(x$0, x$1), val -> Float.valueOf(val != false ? 1.0f : 0.0f), Number::floatValue);
        }

        @Override
        public Class<Float> getDefaultClass() {
            return Float.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Float value, Object sourceContext, ByteBuf buffer) throws IOException {
            buffer.writeFloat(value.floatValue());
        }
    }

    static class BinDecoder
    extends NumericBinaryDecoder<Float> {
        BinDecoder() {
            super((Integer)4, (Context x$0, N x$1) -> Float4s.convertStringOutput(x$0, x$1));
        }

        @Override
        public Class<Float> getDefaultClass() {
            return Float.class;
        }

        @Override
        protected Float decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            return Float.valueOf(buffer.readFloat());
        }
    }
}

