/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.JDBCTypeMapping;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.Empty;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.guava.ByteStreams;
import com.impossibl.postgres.utils.guava.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class PGSQLOutput
implements SQLOutput {
    private Context context;
    private List<Type> attributeTypes;
    private List<Object> attributeValues;

    public PGSQLOutput(Context context) {
        this.context = context;
        this.attributeTypes = new ArrayList<Type>();
        this.attributeValues = new ArrayList<Object>();
    }

    public Type[] getAttributeTypes() {
        return this.attributeTypes.toArray(Empty.EMPTY_TYPES);
    }

    public Object[] getAttributeValues() {
        return this.attributeValues.toArray(new Object[0]);
    }

    private void writeNextAttributeValue(SQLType sqlType, Object val) throws SQLException {
        Type attributeType = JDBCTypeMapping.getType(sqlType, val, this.context.getRegistry());
        if (attributeType == null) {
            attributeType = JDBCTypeMapping.getType((SQLType)JDBCType.NULL, val, this.context.getRegistry());
        }
        this.writeNextAttributeValue(attributeType, val);
    }

    private void writeNextAttributeValue(Type type, Object val) {
        this.attributeTypes.add(type);
        this.attributeValues.add(val);
    }

    @Override
    public void writeString(String x) throws SQLException {
        this.writeNextAttributeValue(JDBCType.VARCHAR, (Object)x);
    }

    @Override
    public void writeBoolean(boolean x) throws SQLException {
        this.writeNextAttributeValue(JDBCType.BOOLEAN, (Object)x);
    }

    @Override
    public void writeByte(byte x) throws SQLException {
        this.writeNextAttributeValue(JDBCType.TINYINT, (Object)x);
    }

    @Override
    public void writeShort(short x) throws SQLException {
        this.writeNextAttributeValue(JDBCType.SMALLINT, (Object)x);
    }

    @Override
    public void writeInt(int x) throws SQLException {
        this.writeNextAttributeValue(JDBCType.INTEGER, (Object)x);
    }

    @Override
    public void writeLong(long x) throws SQLException {
        this.writeNextAttributeValue(JDBCType.BIGINT, (Object)x);
    }

    @Override
    public void writeFloat(float x) throws SQLException {
        this.writeNextAttributeValue(JDBCType.REAL, (Object)Float.valueOf(x));
    }

    @Override
    public void writeDouble(double x) throws SQLException {
        this.writeNextAttributeValue(JDBCType.DOUBLE, (Object)x);
    }

    @Override
    public void writeBigDecimal(BigDecimal x) throws SQLException {
        this.writeNextAttributeValue(JDBCType.DECIMAL, (Object)x);
    }

    @Override
    public void writeBytes(byte[] x) throws SQLException {
        this.writeNextAttributeValue(JDBCType.VARBINARY, (Object)x);
    }

    @Override
    public void writeDate(Date x) throws SQLException {
        this.writeNextAttributeValue(JDBCType.DATE, (Object)x);
    }

    @Override
    public void writeTime(Time x) throws SQLException {
        this.writeNextAttributeValue(JDBCType.TIME, (Object)x);
    }

    @Override
    public void writeTimestamp(Timestamp x) throws SQLException {
        this.writeNextAttributeValue(JDBCType.TIMESTAMP, (Object)x);
    }

    @Override
    public void writeCharacterStream(Reader x) throws SQLException {
        try {
            this.writeNextAttributeValue(JDBCType.VARCHAR, (Object)CharStreams.toString(x));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void writeAsciiStream(InputStream x) throws SQLException {
        try {
            this.writeNextAttributeValue(JDBCType.VARCHAR, (Object)new String(ByteStreams.toByteArray(x), StandardCharsets.US_ASCII));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void writeBinaryStream(InputStream x) throws SQLException {
        try {
            this.writeNextAttributeValue(JDBCType.VARBINARY, (Object)ByteStreams.toByteArray(x));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void writeArray(Array x) throws SQLException {
        this.writeNextAttributeValue(JDBCType.ARRAY, (Object)x);
    }

    @Override
    public void writeURL(URL x) throws SQLException {
        this.writeNextAttributeValue(JDBCType.VARCHAR, (Object)x);
    }

    @Override
    public void writeObject(SQLData x) throws SQLException {
        this.writeNextAttributeValue(JDBCType.OTHER, (Object)x);
    }

    @Override
    public void writeObject(Object x, SQLType targetSqlType) throws SQLException {
        this.writeNextAttributeValue(targetSqlType, x);
    }

    @Override
    public void writeBlob(Blob x) throws SQLException {
        this.writeNextAttributeValue(JDBCType.BLOB, (Object)x);
    }

    @Override
    public void writeClob(Clob x) throws SQLException {
        this.writeNextAttributeValue(JDBCType.CLOB, (Object)x);
    }

    @Override
    public void writeStruct(Struct x) throws SQLException {
        this.writeNextAttributeValue(JDBCType.STRUCT, (Object)x);
    }

    @Override
    public void writeSQLXML(SQLXML x) throws SQLException {
        this.writeNextAttributeValue(JDBCType.SQLXML, (Object)x);
    }

    @Override
    public void writeRowId(RowId x) throws SQLException {
        this.writeNextAttributeValue(JDBCType.ROWID, (Object)x);
    }

    @Override
    public void writeRef(Ref x) throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public void writeNString(String x) throws SQLException {
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void writeNClob(NClob x) throws SQLException {
        throw Exceptions.NOT_SUPPORTED;
    }
}

