/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.ErrorUtils;
import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.PGDirectConnection;
import com.impossibl.postgres.jdbc.PGPreparedStatement;
import com.impossibl.postgres.jdbc.PGResultSet;
import com.impossibl.postgres.jdbc.PGSQLSimpleException;
import com.impossibl.postgres.jdbc.PGStatement;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.RowDataSet;
import com.impossibl.postgres.protocol.v30.BufferRowData;
import com.impossibl.postgres.types.Registry;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.Nulls;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

abstract class PGMetaData {
    PGDirectConnection connection;

    PGMetaData(PGDirectConnection connection) {
        this.connection = connection;
    }

    public PGDirectConnection getConnection() throws SQLException {
        return this.connection;
    }

    int execForInteger(String query) throws SQLException {
        String res = this.getConnection().executeForString(query);
        if (res == null) {
            throw Exceptions.SERVER_VERSION_NOT_SUPPORTED;
        }
        try {
            return Integer.parseInt(res);
        }
        catch (NumberFormatException e) {
            throw Exceptions.SERVER_VERSION_NOT_SUPPORTED;
        }
    }

    PGResultSet execForResultSet(String sql, Object ... params) throws SQLException {
        return this.execForResultSet(sql, Arrays.asList(params));
    }

    PGResultSet execForResultSet(String sql, List<Object> params) throws SQLException {
        PGPreparedStatement ps = this.getConnection().prepareStatement(sql);
        ps.closeOnCompletion();
        for (int c = 0; c < params.size(); ++c) {
            ps.setObject(c + 1, params.get(c));
        }
        return ps.executeQuery();
    }

    PGResultSet createResultSet(ResultField[] resultFields, List<Object[]> results) throws SQLException {
        RowDataSet rows = new RowDataSet(results.size());
        for (Object[] resultValues : results) {
            try {
                rows.add(BufferRowData.encode(this.getConnection(), resultFields, resultValues));
            }
            catch (IOException e) {
                throw new PGSQLSimpleException("Error encoding row value", e);
            }
        }
        PGStatement stmt = this.getConnection().createStatement();
        stmt.closeOnCompletion();
        return stmt.createResultSet(resultFields, rows, true, this.getConnection().getTypeMap());
    }

    List<ColumnData> getColumnData(String sql, List<Object> params) throws SQLException {
        Registry registry = this.connection.getRegistry();
        ArrayList<ColumnData> columnsData = new ArrayList<ColumnData>();
        try (PGResultSet rs = this.execForResultSet(sql, params);){
            while (rs.next()) {
                ColumnData columnData = new ColumnData();
                columnData.tableSchemaName = rs.getString("nspname");
                columnData.tableName = rs.getString("relname");
                columnData.relationId = rs.getInt("attrelid");
                columnData.relationAttributeNumber = rs.getInt("attnum");
                columnData.columnNumber = rs.getInt("attcolnum");
                columnData.columnName = rs.getString("attname");
                columnData.type = registry.loadType(rs.getInt("atttypid"));
                columnData.typeModifier = rs.getInt("atttypmod");
                columnData.typeLength = rs.getInt("attlen");
                columnData.nullable = !rs.getBoolean("attnotnull");
                columnData.nullable = rs.wasNull() ? null : columnData.nullable;
                columnData.defaultValue = rs.getString("adsrc");
                columnData.description = rs.getString("description");
                columnData.baseType = registry.loadType(rs.getInt("typbasetype"));
                columnsData.add(columnData);
            }
        }
        catch (IOException e) {
            throw ErrorUtils.makeSQLException(e);
        }
        return columnsData;
    }

    StringBuilder getColumnSQL(CharSequence extraWhereConditions) {
        return new StringBuilder("   SELECT n.nspname,c.relname,a.attname,a.atttypid,a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) AS attnotnull,a.atttypmod,a.attlen,a.attrelid,a.attnum,     row_number() OVER (PARTITION BY a.attrelid ORDER BY a.attnum) AS attcolnum, pg_catalog.pg_get_expr(def.adbin, def.adrelid) AS adsrc,dsc.description,t.typbasetype,t.typtype    FROM pg_catalog.pg_namespace n    JOIN pg_catalog.pg_class c ON (c.relnamespace = n.oid)    JOIN pg_catalog.pg_attribute a ON (a.attrelid=c.oid)    JOIN pg_catalog.pg_type t ON (a.atttypid = t.oid)    LEFT JOIN pg_catalog.pg_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum)    LEFT JOIN pg_catalog.pg_description dsc ON (c.oid=dsc.objoid AND a.attnum = dsc.objsubid)    LEFT JOIN pg_catalog.pg_class dc ON (dc.oid=dsc.classoid AND dc.relname='pg_class')    LEFT JOIN pg_catalog.pg_namespace dn ON (dc.relnamespace=dn.oid AND dn.nspname='pg_catalog')    WHERE NOT a.attisdropped ").append(extraWhereConditions);
    }

    static class AttributeData {
        String typeSchemaName;
        String typeName;
        int relationId;
        int relationAttrNum;
        String attributeName;
        Type type;
        int typeModifier;
        int typeLength;
        Boolean nullable;
        String defaultValue;
        String description;

        AttributeData() {
        }

        public String toString() {
            return Nulls.firstNonNull(this.typeSchemaName, "<no schema>") + ": " + Nulls.firstNonNull(this.typeName, "<no type>") + " (" + this.relationId + "): " + Nulls.firstNonNull(this.attributeName, "<no name>") + " (" + this.relationAttrNum + ") " + this.type + " - " + Nulls.firstNonNull(this.description, "<no description>");
        }
    }

    static class ColumnData {
        String tableSchemaName;
        String tableName;
        int relationId;
        int relationAttributeNumber;
        int columnNumber;
        String columnName;
        Type type;
        int typeModifier;
        int typeLength;
        Boolean nullable;
        String defaultValue;
        String description;
        Type baseType;

        ColumnData() {
        }

        public String toString() {
            return Nulls.firstNonNull(this.tableSchemaName, "<no schema>") + ": " + Nulls.firstNonNull(this.tableName, "<no table>") + " (" + this.relationId + "): " + Nulls.firstNonNull(this.columnName, "<no name>") + " (" + this.relationAttributeNumber + "/" + this.columnNumber + ") " + this.type + " - " + Nulls.firstNonNull(this.description, "<no description>");
        }
    }
}

