/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.ArrayUtils;
import com.impossibl.postgres.jdbc.PGArray;
import com.impossibl.postgres.jdbc.PGDirectConnection;
import com.impossibl.postgres.jdbc.PGStatement;
import com.impossibl.postgres.protocol.FieldBuffersRowData;
import com.impossibl.postgres.protocol.FieldFormat;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.RowDataSet;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.CustomTypes;
import com.impossibl.postgres.system.Empty;
import com.impossibl.postgres.system.procs.Arrays;
import com.impossibl.postgres.types.ArrayType;
import com.impossibl.postgres.types.NestedArrayType;
import com.impossibl.postgres.types.Registry;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.Types;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PGBuffersArray
extends PGArray {
    private FieldFormat elementFormat;
    private ByteBuf[] elementBuffers;
    private int[] dimensions;
    private Class<?> sourceArrayType;

    public PGBuffersArray(Context context, ArrayType type, FieldFormat elementFormat, ByteBuf[] elementBuffers, int[] dimensions) {
        this(context, type, elementFormat, elementBuffers, dimensions, null);
    }

    private PGBuffersArray(Context context, ArrayType type, FieldFormat elementFormat, ByteBuf[] elementBuffers, int[] dimensions, Class<?> sourceArrayType) {
        super(context, type);
        this.elementFormat = elementFormat;
        this.elementBuffers = elementBuffers;
        this.dimensions = dimensions;
        this.sourceArrayType = sourceArrayType;
    }

    public static PGBuffersArray encode(Context context, ArrayType type, Object array) throws IOException {
        int[] dimensions = ArrayUtils.getDimensions(array);
        int totalElements = Arrays.strideOfDimensions(dimensions);
        Type componentType = type.getElementType();
        FieldFormat format = type.getElementType().getResultFormat();
        ArrayList<ByteBuf> elementBuffers = new ArrayList<ByteBuf>(totalElements);
        PGBuffersArray.encode(context, componentType, format, array, elementBuffers);
        return new PGBuffersArray(context, type, format, elementBuffers.toArray(Empty.EMPTY_BUFFERS), dimensions, array.getClass());
    }

    public static void encode(Context context, Type componentType, FieldFormat format, Object value, List<ByteBuf> elementBuffers) throws IOException {
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            for (int elementIdx = 0; elementIdx < length; ++elementIdx) {
                Object element = Array.get(value, elementIdx);
                if (element == null) {
                    elementBuffers.add(null);
                    continue;
                }
                PGBuffersArray.encode(context, componentType, format, element, elementBuffers);
            }
        } else {
            ByteBufAllocator byteBufAllocator = context.getAllocator();
            ByteBuf valueBuffer = null;
            switch (format) {
                case Text: {
                    StringBuilder elementBuffer = new StringBuilder();
                    componentType.getTextCodec().getEncoder().encode(context, componentType, value, null, elementBuffer);
                    valueBuffer = ByteBufUtil.writeUtf8((ByteBufAllocator)byteBufAllocator, (CharSequence)elementBuffer);
                    break;
                }
                case Binary: {
                    valueBuffer = byteBufAllocator.buffer();
                    componentType.getBinaryCodec().getEncoder().encode(context, componentType, value, null, valueBuffer);
                }
            }
            elementBuffers.add(valueBuffer);
        }
    }

    @Override
    public int getLength() {
        if (this.dimensions.length == 0) {
            return 0;
        }
        return this.dimensions[0];
    }

    @Override
    protected Object getArray(Context context, Class<?> targetComponentType, long index, int count) throws SQLException {
        int offset = (int)index - 1;
        if (offset < 0 || offset + count > this.getLength()) {
            throw new SQLException("Invalid array slice");
        }
        if (targetComponentType == null) {
            Type elementType = this.type.getElementType();
            Class<?> elementClass = this.sourceArrayType != null ? ArrayUtils.getElementType(this.sourceArrayType) : elementType.getCodec(this.elementFormat).getDecoder().getDefaultClass();
            targetComponentType = CustomTypes.lookupCustomType(elementType, context.getCustomTypeMap(), elementClass);
        }
        try {
            return this.getArray(context, targetComponentType, this.dimensions, offset, count);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    private Object getArray(Context context, Class<?> targetComponentType, int[] dimensions, int offset, int count) throws IOException {
        Object result;
        if (dimensions.length > 1) {
            dimensions = (int[])dimensions.clone();
            dimensions[0] = count;
            result = Array.newInstance(targetComponentType, dimensions);
            int[] subDimensions = java.util.Arrays.copyOfRange(dimensions, 1, dimensions.length);
            int stride = Arrays.strideOfDimensions(subDimensions);
            for (int c = 0; c < count; ++c) {
                Object subArray = this.getArray(context, targetComponentType, subDimensions, offset + c * stride, subDimensions[0]);
                Array.set(result, c, subArray);
            }
        } else {
            Type componentType = this.type.getElementType();
            result = Array.newInstance(targetComponentType, count);
            targetComponentType = Types.boxType(targetComponentType);
            for (int c = 0; c < count; ++c) {
                Object element = null;
                ByteBuf elementBuffer = this.elementBuffers[offset + c];
                if (elementBuffer != null) {
                    switch (this.elementFormat) {
                        case Text: {
                            String elementStr = elementBuffer.toString(StandardCharsets.UTF_8);
                            element = componentType.getTextCodec().getDecoder().decode(context, componentType, componentType.getLength(), null, elementStr, targetComponentType, null);
                            break;
                        }
                        case Binary: {
                            element = componentType.getBinaryCodec().getDecoder().decode(context, componentType, componentType.getLength(), null, elementBuffer, targetComponentType, null);
                        }
                    }
                    elementBuffer.resetReaderIndex();
                }
                Array.set(result, c, element);
            }
        }
        return result;
    }

    @Override
    protected ResultSet getResultSet(Context context, long index, int count) throws SQLException {
        FieldFormat elementFormat;
        Type elementType;
        int offset = (int)index - 1;
        if (offset < 0 || offset + count > this.getLength()) {
            throw new SQLException("Invalid array slice");
        }
        ByteBufAllocator byteBufAllocator = context.getAllocator();
        Registry reg = context.getRegistry();
        int stride = Arrays.strideOfDimensions(this.dimensions, 1);
        if (stride > 1) {
            elementType = new NestedArrayType(this.type, this.type.getElementType(), this.elementFormat, java.util.Arrays.copyOfRange(this.dimensions, 1, this.dimensions.length));
            elementFormat = FieldFormat.Binary;
        } else {
            elementType = this.type.getElementType();
            elementFormat = this.elementFormat;
        }
        ResultField[] fields = new ResultField[]{new ResultField("INDEX", 0, 0, reg.loadBaseType("int4"), 0, 0, FieldFormat.Binary), new ResultField("VALUE", 0, 0, elementType, 0, 0, elementFormat)};
        RowDataSet results = new RowDataSet(count);
        for (int c = 0; c < count; ++c) {
            ByteBuf elementBuffer;
            ByteBuf indexBuffer = byteBufAllocator.buffer(4).writeInt(offset + c + 1);
            if (stride > 1) {
                CompositeByteBuf compElementBuffer = byteBufAllocator.compositeBuffer(stride);
                for (int s = 0; s < stride; ++s) {
                    compElementBuffer.addComponent(this.elementBuffers[(offset + c) * stride + s].retainedDuplicate());
                }
                elementBuffer = compElementBuffer;
            } else {
                elementBuffer = this.elementBuffers[offset + c].retainedDuplicate();
            }
            results.add(new FieldBuffersRowData(new ByteBuf[]{indexBuffer, elementBuffer}, context.getAllocator()));
        }
        PGDirectConnection connection = (PGDirectConnection)context.unwrap();
        PGStatement stmt = connection.createStatement();
        stmt.closeOnCompletion();
        return stmt.createResultSet(fields, results, true, context.getCustomTypeMap());
    }

    @Override
    public void free() {
        for (ByteBuf elementBuf : this.elementBuffers) {
            ReferenceCountUtil.release((Object)elementBuf);
        }
        this.context = null;
        this.type = null;
        this.elementFormat = null;
        this.dimensions = null;
        this.sourceArrayType = null;
        this.elementBuffers = null;
    }
}

