/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.ConnectionUtil;
import com.impossibl.postgres.jdbc.DataSourceSettings;
import com.impossibl.postgres.jdbc.JDBCSettings;
import com.impossibl.postgres.jdbc.PGDataSource;
import com.impossibl.postgres.jdbc.PGDirectConnection;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ServerConnectionInfo;
import com.impossibl.postgres.system.Setting;
import com.impossibl.postgres.system.Settings;
import com.impossibl.postgres.system.SystemSettings;
import com.impossibl.postgres.types.SharedRegistry;
import com.impossibl.postgres.utils.StringTransforms;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.CommonDataSource;

public abstract class AbstractDataSource
implements CommonDataSource {
    protected Settings settings = new Settings(DataSourceSettings.DS, JDBCSettings.JDBC, SystemSettings.SYS, SystemSettings.PROTO);
    private Map<ServerConnectionInfo, SharedRegistry> sharedRegistries = new ConcurrentHashMap<ServerConnectionInfo, SharedRegistry>();

    protected AbstractDataSource() {
    }

    protected PGDirectConnection createConnection(String username, String password) throws SQLException {
        this.settings.set(SystemSettings.CREDENTIALS_USERNAME, username);
        this.settings.set(SystemSettings.CREDENTIALS_PASSWORD, password);
        SharedRegistry.Factory sharedRegistryFactory = !this.settings.enabled(JDBCSettings.REGISTRY_SHARING) ? connInfo -> new SharedRegistry(connInfo.getServerInfo(), PGDataSource.class.getClassLoader()) : connInfo -> this.sharedRegistries.computeIfAbsent(connInfo, key -> new SharedRegistry(key.getServerInfo(), PGDataSource.class.getClassLoader()));
        String url = this.settings.get(SystemSettings.DATABASE_URL);
        if (url != null) {
            this.settings.unset(DataSourceSettings.SERVER_NAME);
            this.settings.unset(DataSourceSettings.PORT_NUMBER);
            this.settings.unset(DataSourceSettings.DATABASE_NAME);
            PGDirectConnection connection = ConnectionUtil.createConnection(url, this.settings.asProperties(), sharedRegistryFactory);
            if (connection == null) {
                throw new SQLException("Unsupported database URL");
            }
            return connection;
        }
        url = "jdbc:pgsql://" + this.settings.get(DataSourceSettings.SERVER_NAME) + ":" + this.settings.get(DataSourceSettings.PORT_NUMBER) + "/" + this.settings.get(DataSourceSettings.DATABASE_NAME);
        this.settings.set(SystemSettings.DATABASE_URL, url);
        InetSocketAddress address = new InetSocketAddress(this.settings.get(DataSourceSettings.SERVER_NAME), (int)this.settings.get(DataSourceSettings.PORT_NUMBER));
        return ConnectionUtil.createConnection(Collections.singletonList(address), this.settings, sharedRegistryFactory);
    }

    protected abstract Reference createReference();

    private void addRefAddrIfSet(Reference ref, Setting<?> setting) {
        if (!this.settings.hasStoredValue(setting)) {
            return;
        }
        ref.add(new StringRefAddr(StringTransforms.toLowerCamelCase(setting.getName()), this.settings.getText(setting)));
    }

    private void addRefAddrIfMissing(Reference ref, Setting<?> setting) {
        if (this.settings.hasStoredValue(setting)) {
            return;
        }
        ref.add(new StringRefAddr(StringTransforms.toLowerCamelCase(setting.getName()), this.settings.getText(setting)));
    }

    public Reference getReference() {
        Reference ref = this.createReference();
        for (Setting<?> setting : this.settings.knownSet()) {
            this.addRefAddrIfSet(ref, setting);
        }
        this.addRefAddrIfMissing(ref, DataSourceSettings.DATASOURCE_NAME);
        this.addRefAddrIfMissing(ref, DataSourceSettings.SERVER_NAME);
        this.addRefAddrIfMissing(ref, DataSourceSettings.PORT_NUMBER);
        this.addRefAddrIfMissing(ref, DataSourceSettings.DATABASE_NAME);
        return ref;
    }

    public void init(Reference reference) {
        for (Setting<?> setting : this.settings.knownSet()) {
            String value = AbstractDataSource.getReferenceValue(reference, StringTransforms.toLowerCamelCase(setting.getName()));
            if (value == null) continue;
            this.settings.setText(setting, value);
        }
    }

    private static String getReferenceValue(Reference reference, String key) {
        RefAddr refAddr = reference.get(key);
        if (refAddr == null) {
            return null;
        }
        return (String)refAddr.getContent();
    }

    public abstract String getDescription();

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.settings.get(DataSourceSettings.LOGIN_TIMEOUT);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.settings.set(DataSourceSettings.LOGIN_TIMEOUT, seconds);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger(Context.class.getPackage().getName());
    }

    public String getHost() {
        return this.settings.get(DataSourceSettings.SERVER_NAME);
    }

    public void setHost(String v) {
        this.settings.set(DataSourceSettings.SERVER_NAME, v);
    }

    public int getPort() {
        return this.settings.get(DataSourceSettings.PORT_NUMBER);
    }

    public void setPort(int v) {
        this.settings.set(DataSourceSettings.PORT_NUMBER, v);
    }

    public String getClientEncoding() {
        return this.settings.getText(SystemSettings.PROTOCOL_ENCODING);
    }

    public void setClientEncoding(String v) {
        this.settings.setText(SystemSettings.PROTOCOL_ENCODING, v);
    }
}

