/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.types;

import com.impossibl.postgres.jdbc.PGDriver;
import com.impossibl.postgres.protocol.FieldFormat;
import com.impossibl.postgres.system.ServerConnectionInfo;
import com.impossibl.postgres.system.ServerInfo;
import com.impossibl.postgres.system.Version;
import com.impossibl.postgres.system.procs.Procs;
import com.impossibl.postgres.types.ArrayType;
import com.impossibl.postgres.types.BaseType;
import com.impossibl.postgres.types.CompositeType;
import com.impossibl.postgres.types.Modifiers;
import com.impossibl.postgres.types.QualifiedName;
import com.impossibl.postgres.types.Registry;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SharedRegistry {
    private static final Logger logger = Logger.getLogger(SharedRegistry.class.getName());
    private static final Map<ServerConnectionInfo, SharedRegistry> sharedRegistries = new HashMap<ServerConnectionInfo, SharedRegistry>();
    private static final Map<ProcSharingKey, Procs> sharedProcs = new HashMap<ProcSharingKey, Procs>();
    private final Version serverVersion;
    private final TreeMap<Integer, Type> oidMap;
    private final Map<QualifiedName, Type> nameMap;
    private final TreeMap<Integer, Type> relIdMap;
    private final Procs procs;
    private boolean seeded = false;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public static Factory getFactory(boolean shared) {
        if (shared) {
            return connInfo -> {
                Map<ServerConnectionInfo, SharedRegistry> map = sharedRegistries;
                synchronized (map) {
                    return sharedRegistries.computeIfAbsent(connInfo, key -> new SharedRegistry(key.getServerInfo(), PGDriver.class.getClassLoader(), true));
                }
            };
        }
        return connInfo -> new SharedRegistry(connInfo.getServerInfo(), Thread.currentThread().getContextClassLoader(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SharedRegistry(ServerInfo serverInfo, ClassLoader classLoader, boolean shareProcs) {
        this.serverVersion = serverInfo.getVersion();
        if (shareProcs) {
            Map<ProcSharingKey, Procs> map = sharedProcs;
            synchronized (map) {
                ProcSharingKey procSharingKey = new ProcSharingKey(serverInfo, classLoader);
                this.procs = sharedProcs.computeIfAbsent(procSharingKey, key -> new Procs(((ProcSharingKey)key).serverInfo, ((ProcSharingKey)key).classLoader));
            }
        } else {
            this.procs = new Procs(serverInfo, classLoader);
        }
        this.oidMap = new TreeMap();
        this.oidMap.put(16, new BaseType(16, "bool", (short)1, (byte)1, Type.Category.Boolean, ',', 1000, this.procs, FieldFormat.Binary, FieldFormat.Binary));
        this.oidMap.put(17, new BaseType(17, "bytea", (short)1, (byte)4, Type.Category.User, ',', 1001, this.procs, FieldFormat.Binary, FieldFormat.Binary));
        this.oidMap.put(18, new BaseType(18, "char", (short)1, (byte)1, Type.Category.String, ',', 1002, this.procs, FieldFormat.Binary, FieldFormat.Binary));
        this.oidMap.put(19, new BaseType(19, "name", (short)64, (byte)1, Type.Category.String, ',', 1003, this.procs, FieldFormat.Binary, FieldFormat.Binary));
        this.oidMap.put(20, new BaseType(20, "int8", (short)8, (byte)8, Type.Category.Numeric, ',', 1016, this.procs, FieldFormat.Binary, FieldFormat.Binary));
        this.oidMap.put(21, new BaseType(21, "int2", (short)2, (byte)2, Type.Category.Numeric, ',', 1005, this.procs, FieldFormat.Binary, FieldFormat.Binary));
        this.oidMap.put(22, new ArrayType(22, "int2vector", (short)-1, (byte)4, Type.Category.Array, ',', 1006, this.procs, FieldFormat.Binary, FieldFormat.Binary, this.oidMap.get(21)));
        this.oidMap.put(23, new BaseType(23, "int4", (short)4, (byte)4, Type.Category.Numeric, ',', 1007, this.procs, FieldFormat.Binary, FieldFormat.Binary));
        this.oidMap.put(24, new BaseType(24, "regproc", (short)4, (byte)4, Type.Category.Numeric, ',', 1008, this.procs, FieldFormat.Binary, FieldFormat.Binary));
        this.oidMap.put(25, new BaseType(25, "text", (short)-1, (byte)4, Type.Category.String, ',', 1009, this.procs, FieldFormat.Binary, FieldFormat.Binary));
        this.oidMap.put(26, new BaseType(26, "oid", (short)4, (byte)4, Type.Category.Numeric, ',', 1028, this.procs, FieldFormat.Binary, FieldFormat.Binary));
        this.oidMap.put(27, new BaseType(27, "tid", (short)6, (byte)2, Type.Category.User, ',', 1010, this.procs, FieldFormat.Binary, FieldFormat.Binary));
        this.oidMap.put(28, new BaseType(28, "xid", (short)4, (byte)4, Type.Category.User, ',', 1011, this.procs, FieldFormat.Binary, FieldFormat.Binary));
        this.oidMap.put(29, new BaseType(29, "cid", (short)4, (byte)4, Type.Category.User, ',', 1012, this.procs, FieldFormat.Binary, FieldFormat.Binary));
        this.oidMap.put(30, new ArrayType(30, "oidvector", (short)-1, (byte)4, Type.Category.Array, ',', 1013, this.procs, FieldFormat.Binary, FieldFormat.Binary, this.oidMap.get(26)));
        this.oidMap.put(1790, new BaseType(1790, "refcursor", "pg_catalog", (short)-1, (byte)4, Type.Category.User, ',', 2201, "refcursor", this.procs, FieldFormat.Binary, FieldFormat.Binary));
        this.oidMap.put(2205, new BaseType(2205, "regclass", (short)4, (byte)4, Type.Category.Numeric, ',', 2210, this.procs, FieldFormat.Binary, FieldFormat.Binary));
        this.oidMap.put(2206, new BaseType(2206, "regtype", (short)4, (byte)4, Type.Category.Numeric, ',', 2211, this.procs, FieldFormat.Binary, FieldFormat.Binary));
        this.oidMap.put(2210, new ArrayType(2210, "_regclass", (short)-1, (byte)4, Type.Category.Array, ',', 0, this.procs, FieldFormat.Binary, FieldFormat.Binary, this.oidMap.get(2205)));
        this.oidMap.put(2211, new ArrayType(2211, "_regtype", (short)-1, (byte)4, Type.Category.Array, ',', 0, this.procs, FieldFormat.Binary, FieldFormat.Binary, this.oidMap.get(2206)));
        this.oidMap.put(2249, new BaseType(2249, "pg_catalog", "record", (short)-1, (byte)1, Type.Category.Psuedo, ',', 2287, "record_", this.procs, FieldFormat.Binary, FieldFormat.Binary));
        this.oidMap.put(2287, new ArrayType(2287, "_record", (short)-1, (byte)4, Type.Category.Array, ',', 0, this.procs, FieldFormat.Binary, FieldFormat.Binary, this.oidMap.get(2249)));
        this.nameMap = new HashMap<QualifiedName, Type>();
        this.oidMap.values().forEach(type -> this.nameMap.put(type.getQualifiedName(), (Type)type));
        this.relIdMap = new TreeMap();
    }

    public Version getServerVersion() {
        return this.serverVersion;
    }

    public boolean hasTypeDefined(Integer typeId) {
        return this.oidMap.containsKey(typeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type findOrLoadType(int typeId, Registry.TypeLoader loader) throws IOException {
        if (typeId == 0) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            Type type = this.oidMap.get(typeId);
            if (type == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    type = loader.load(typeId);
                    this.updateType(type);
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            Type type2 = type;
            return type2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type findOrLoadType(QualifiedName name, Registry.TypeLoader loader) throws IOException {
        if (name == null) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            Type type = this.nameMap.get(name);
            if (type == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    type = loader.load(name);
                    this.updateType(type);
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            Type type2 = type;
            return type2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeType findOrLoadRelationType(int relationId, Registry.TypeLoader loader) throws IOException {
        if (relationId == 0) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            CompositeType type = (CompositeType)this.relIdMap.get(relationId);
            if (type == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    type = loader.loadRelation(relationId);
                    this.updateType(type);
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            CompositeType compositeType = type;
            return compositeType;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean seed(Seeder seeder) throws IOException {
        this.lock.writeLock().lock();
        try {
            if (this.seeded) {
                boolean bl = false;
                return bl;
            }
            logger.log(Level.FINE, "Seeding shared registry");
            this.seeded = true;
            seeder.seed(this);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypes(Collection<Type> types) {
        this.lock.writeLock().lock();
        try {
            for (Type type : types) {
                this.updateType(type);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void updateType(Type type) {
        if (type == null) {
            return;
        }
        if (type.getOid() == 1790) {
            return;
        }
        this.oidMap.put(type.getId(), type);
        this.nameMap.put(type.getQualifiedName(), type);
        if (type.getRelationId() != 0) {
            this.relIdMap.put(type.getRelationId(), type);
        }
    }

    Type.TextCodec loadTextCodec(String encoderName, String decoderName) {
        return new Type.TextCodec(this.loadDecoderProc(decoderName, Procs.DEFAULT_TEXT_DECODER, CharSequence.class), this.loadEncoderProc(encoderName, Procs.DEFAULT_TEXT_ENCODER, StringBuilder.class));
    }

    Type.BinaryCodec loadBinaryCodec(String encoderName, String decoderName) {
        return new Type.BinaryCodec(this.loadDecoderProc(decoderName, Procs.DEFAULT_BINARY_DECODER, ByteBuf.class), this.loadEncoderProc(encoderName, Procs.DEFAULT_BINARY_ENCODER, ByteBuf.class));
    }

    private <Buffer> Type.Codec.Encoder<Buffer> loadEncoderProc(String procName, Type.Codec.Encoder<Buffer> defaultEncoder, Class<? extends Buffer> bufferType) {
        return this.procs.loadEncoderProc(procName, defaultEncoder, bufferType);
    }

    private <Buffer> Type.Codec.Decoder<Buffer> loadDecoderProc(String procName, Type.Codec.Decoder<Buffer> defaultDecoder, Class<? extends Buffer> bufferType) {
        return this.procs.loadDecoderProc(procName, defaultDecoder, bufferType);
    }

    Modifiers.Parser loadModifierParser(String modInName) {
        return this.procs.loadModifierParserProc(modInName);
    }

    public static interface Seeder {
        public void seed(SharedRegistry var1) throws IOException;
    }

    private static class ProcSharingKey {
        private final ServerInfo serverInfo;
        private final ClassLoader classLoader;

        ProcSharingKey(ServerInfo serverInfo, ClassLoader classLoader) {
            this.serverInfo = serverInfo;
            this.classLoader = classLoader;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcSharingKey that = (ProcSharingKey)o;
            return this.serverInfo.equals(that.serverInfo) && this.classLoader.equals(that.classLoader);
        }

        public int hashCode() {
            return Objects.hash(this.serverInfo, this.classLoader);
        }
    }

    public static interface Factory {
        public SharedRegistry get(ServerConnectionInfo var1);
    }
}

