/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.jdbc.PGBuffersStruct;
import com.impossibl.postgres.jdbc.PGSQLInput;
import com.impossibl.postgres.jdbc.PGSQLOutput;
import com.impossibl.postgres.jdbc.PGStruct;
import com.impossibl.postgres.jdbc.PGValuesStruct;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.CustomTypes;
import com.impossibl.postgres.system.procs.BaseBinaryDecoder;
import com.impossibl.postgres.system.procs.BaseBinaryEncoder;
import com.impossibl.postgres.system.procs.BaseTextDecoder;
import com.impossibl.postgres.system.procs.BaseTextEncoder;
import com.impossibl.postgres.system.procs.InputFactory;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.StructFactory;
import com.impossibl.postgres.types.Registry;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.ByteBufs;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Records
extends SimpleProcProvider {
    public Records() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "record_");
    }

    static PGStruct convertInput(Context context, Type type, Object value) throws IOException {
        PGStruct struct;
        if (value instanceof PGStruct) {
            struct = (PGStruct)value;
        } else if (value instanceof SQLData) {
            PGSQLOutput out = new PGSQLOutput(context);
            SQLData data = (SQLData)value;
            try {
                data.writeSQL(out);
                struct = new PGValuesStruct(context, data.getSQLTypeName(), out.getAttributeTypes(), out.getAttributeValues());
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        } else {
            throw new ConversionException(value.getClass(), type);
        }
        return struct;
    }

    static <Buffer> Object convertOutput(Context context, Type type, Type[] attributeTypes, Buffer[] attributeBuffers, Class<?> targetClass, InputFactory<Buffer> inputFactory, StructFactory<Buffer> structFactory) throws IOException {
        Object result;
        if (Struct.class.isAssignableFrom(targetClass)) {
            targetClass = CustomTypes.lookupCustomType(type, context.getCustomTypeMap(), targetClass);
        }
        if (SQLData.class.isAssignableFrom(targetClass)) {
            SQLData data;
            try {
                data = (SQLData)targetClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IOException("Unable to instantiate custom type; an accessible no-arg constructor is required", e);
            }
            try {
                PGSQLInput<Buffer> input = inputFactory.create(context, attributeTypes, attributeBuffers);
                data.readSQL(input, type.getQualifiedName().toString());
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
            result = data;
        } else if (Struct.class.isAssignableFrom(targetClass)) {
            result = structFactory.create(context, type.getQualifiedName().toString(), attributeTypes, attributeBuffers);
        } else {
            throw new ConversionException(type, targetClass);
        }
        return result;
    }

    static class TxtEncoder
    extends BaseTextEncoder {
        TxtEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, StringBuilder buffer) throws IOException {
            char delim = type.getDelimeter();
            PGStruct struct = Records.convertInput(context, type, value);
            Type[] attributeTypes = struct.getAttributeTypes();
            Object[] attributeValues = struct.getAttributes(context);
            buffer.append('(');
            for (int c = 0; c < attributeValues.length; ++c) {
                Type attributeType = attributeTypes[c];
                Object attributeValue = attributeValues[c];
                StringBuilder attributeOut = new StringBuilder();
                attributeType.getTextCodec().getEncoder().encode(context, attributeType, attributeValue, null, attributeOut);
                String attributeStr = attributeOut.toString();
                if (TxtEncoder.needsQuotes(attributeStr, delim)) {
                    attributeStr = attributeStr.replace("\\", "\\\\");
                    attributeStr = attributeStr.replace("\"", "\\\"");
                    buffer.append('\"').append(attributeStr).append('\"');
                } else {
                    buffer.append(attributeStr);
                }
                if (c >= attributeValues.length - 1) continue;
                buffer.append(delim);
            }
            buffer.append(')');
        }

        private static boolean needsQuotes(String elemStr, char delim) {
            if (elemStr.isEmpty()) {
                return true;
            }
            if (elemStr.equalsIgnoreCase("NULL")) {
                return true;
            }
            for (int c = 0; c < elemStr.length(); ++c) {
                char ch = elemStr.charAt(c);
                if (ch != delim && ch != '\"' && ch != '\\' && ch != '{' && ch != '}' && ch != ' ' && ch != '\t' && ch != '\n' && ch != '\r' && ch != '\f') continue;
                return true;
            }
            return false;
        }
    }

    static class TxtDecoder
    extends BaseTextDecoder {
        TxtDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return Struct.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            ArrayList<CharSequence> attributeBuffers = new ArrayList<CharSequence>();
            this.parseAttributeBuffers(type.getDelimeter(), buffer, attributeBuffers);
            Object[] attributeTypes = new Type[attributeBuffers.size()];
            Arrays.fill(attributeTypes, context.getRegistry().loadBaseType("text"));
            return Records.convertOutput(context, type, (Type[])attributeTypes, attributeBuffers.toArray(new CharSequence[0]), targetClass, PGSQLInput.Text::new, PGBuffersStruct.Text::new);
        }

        void parseAttributeBuffers(char delim, CharSequence buffer, List<CharSequence> attributes) {
            int len = buffer.length();
            StringBuilder attributeText = null;
            int lastDelimIdx = -1;
            block5: for (int charIdx = 0; charIdx < len; ++charIdx) {
                char ch = buffer.charAt(charIdx);
                switch (ch) {
                    case '(': {
                        lastDelimIdx = charIdx;
                        continue block5;
                    }
                    case ')': {
                        this.addTextElement(attributeText, lastDelimIdx == charIdx - 1, attributes);
                        break block5;
                    }
                    case '\"': {
                        attributeText = new StringBuilder();
                        charIdx = this.readString(buffer, charIdx, attributeText);
                        continue block5;
                    }
                    default: {
                        if (Character.isWhitespace(ch)) {
                            charIdx = this.skipWhitespace(buffer, charIdx);
                            continue block5;
                        }
                        if (ch == delim) {
                            attributeText = this.addTextElement(attributeText, lastDelimIdx == charIdx - 1, attributes);
                            lastDelimIdx = charIdx;
                            continue block5;
                        }
                        if (attributeText == null) {
                            attributeText = new StringBuilder();
                        }
                        attributeText.append(ch);
                    }
                }
            }
        }

        StringBuilder addTextElement(StringBuilder text, boolean empty, List<CharSequence> attributes) {
            if (empty) {
                attributes.add(null);
            } else {
                attributes.add(text.toString());
            }
            return null;
        }

        int skipWhitespace(CharSequence data, int start) {
            int c;
            int len = data.length();
            for (c = start; c < len && Character.isWhitespace(data.charAt(c)); ++c) {
            }
            return c;
        }

        int readString(CharSequence data, int start, StringBuilder string) {
            int c;
            int len = data.length();
            block4: for (c = start + 1; c < len; ++c) {
                char ch = data.charAt(c);
                switch (ch) {
                    case '\"': {
                        if (c >= data.length() - 1 || data.charAt(c + 1) != '\"') break block4;
                        ++c;
                        string.append('\"');
                        continue block4;
                    }
                    case '\\': {
                        if (++c < data.length()) {
                            ch = data.charAt(c);
                        }
                    }
                    default: {
                        string.append(ch);
                    }
                }
            }
            return c;
        }
    }

    static class BinEncoder
    extends BaseBinaryEncoder {
        BinEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, ByteBuf buffer) throws IOException {
            PGStruct struct = Records.convertInput(context, type, value);
            Type[] attributeTypes = struct.getAttributeTypes();
            Object[] attributeValues = struct.getAttributes(context);
            buffer.writeInt(attributeValues.length);
            for (int c = 0; c < attributeValues.length; ++c) {
                Type attributeType = attributeTypes[c];
                Object attributeValue = attributeValues[c];
                buffer.writeInt(attributeType.getId());
                ByteBufs.lengthEncodeBinary(attributeType.getBinaryCodec().getEncoder(), context, attributeType, attributeValue, null, buffer);
            }
        }
    }

    static class BinDecoder
    extends BaseBinaryDecoder {
        BinDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return Struct.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            Registry registry = context.getRegistry();
            int length = buffer.readableBytes();
            long readStart = buffer.readerIndex();
            int itemCount = buffer.readInt();
            Type[] attributeTypes = new Type[itemCount];
            ByteBuf[] attributeBuffers = new ByteBuf[itemCount];
            for (int c = 0; c < itemCount; ++c) {
                Type attributeType;
                attributeTypes[c] = attributeType = registry.loadType(buffer.readInt());
                int attributeLen = buffer.readInt();
                if (attributeLen == -1) continue;
                ByteBuf attributeBuffer = PGBuffersStruct.Binary.ALLOC.buffer(attributeLen);
                buffer.readBytes(attributeBuffer, attributeLen);
                attributeBuffers[c] = attributeBuffer;
            }
            if ((long)length != (long)buffer.readerIndex() - readStart) {
                throw new IllegalStateException();
            }
            return Records.convertOutput(context, type, attributeTypes, attributeBuffers, targetClass, PGSQLInput.Binary::new, PGBuffersStruct.Binary::new);
        }
    }
}

