/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.procs.BaseBinaryDecoder;
import com.impossibl.postgres.system.procs.BaseBinaryEncoder;
import com.impossibl.postgres.system.procs.BaseTextDecoder;
import com.impossibl.postgres.system.procs.BaseTextEncoder;
import com.impossibl.postgres.system.procs.DatesTimes;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;

public class Dates
extends SimpleProcProvider {
    public Dates() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "date_");
    }

    private static LocalDate convertInput(Context context, Type type, Object value, Calendar sourceCalendar) throws ConversionException {
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            if (ts.getTime() == 9223372036825200000L) {
                return LocalDate.MAX;
            }
            if (ts.getTime() == -9223372036832400000L) {
                return LocalDate.MIN;
            }
            return ts.toInstant().atZone(sourceCalendar.getTimeZone().toZoneId()).toLocalDate();
        }
        if (value instanceof Date) {
            Date d = (Date)value;
            if (d.getTime() == 9223372036825200000L) {
                return LocalDate.MAX;
            }
            if (d.getTime() == -9223372036832400000L) {
                return LocalDate.MIN;
            }
            Calendar calendar = Calendar.getInstance(sourceCalendar.getTimeZone());
            calendar.clear();
            calendar.setTimeInMillis(d.getTime());
            int year = calendar.get(0) == 0 ? -(calendar.get(1) - 1) : calendar.get(1);
            return LocalDate.of(year, calendar.get(2) + 1, calendar.get(5));
        }
        if (value instanceof CharSequence) {
            CharSequence s = (CharSequence)value;
            if (s.equals("infinity")) {
                return LocalDate.MAX;
            }
            if (s.equals("-infinity")) {
                return LocalDate.MIN;
            }
            TemporalAccessor parsed = context.getClientDateFormat().getParser().parse(s);
            return LocalDate.from(parsed);
        }
        throw new ConversionException(value.getClass(), type);
    }

    private static Object convertInfinityOutput(boolean positive, Type type, Class<?> targetClass) throws ConversionException {
        if (targetClass == LocalDate.class) {
            return positive ? LocalDate.MAX : LocalDate.MIN;
        }
        if (targetClass == String.class) {
            return positive ? "infinity" : "-infinity";
        }
        if (targetClass == Date.class) {
            return new Date(positive ? 9223372036825200000L : -9223372036832400000L);
        }
        if (targetClass == Timestamp.class) {
            return new Timestamp(positive ? 9223372036825200000L : -9223372036832400000L);
        }
        throw new ConversionException(type, targetClass);
    }

    private static Object convertOutput(Context context, Type type, LocalDate date, Class<?> targetClass, Calendar targetCalendar) throws ConversionException {
        if (targetClass == LocalDate.class) {
            return date;
        }
        if (targetClass == String.class) {
            return context.getClientDateFormat().getPrinter().format(date);
        }
        if (targetClass == Timestamp.class) {
            targetCalendar.clear();
            targetCalendar.set(date.getYear(), date.getMonthValue() - 1, date.getDayOfMonth());
            return new Timestamp(targetCalendar.getTimeInMillis());
        }
        if (targetClass == Date.class) {
            targetCalendar.clear();
            targetCalendar.set(date.getYear(), date.getMonthValue() - 1, date.getDayOfMonth());
            return new Date(targetCalendar.getTimeInMillis());
        }
        throw new ConversionException(type, targetClass);
    }

    static class TxtEncoder
    extends BaseTextEncoder {
        TxtEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, StringBuilder buffer) throws IOException {
            Calendar calendar = sourceContext != null ? (Calendar)sourceContext : Calendar.getInstance();
            LocalDate date = Dates.convertInput(context, type, value, calendar);
            if (date == LocalDate.MAX) {
                buffer.append("infinity");
            } else if (date == LocalDate.MIN) {
                buffer.append("-infinity");
            } else {
                String strVal = context.getServerDateFormat().getPrinter().format(date);
                buffer.append(strVal);
            }
        }
    }

    static class TxtDecoder
    extends BaseTextDecoder {
        TxtDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return Date.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException {
            Calendar calendar;
            Calendar calendar2 = calendar = targetContext != null ? (Calendar)targetContext : Calendar.getInstance();
            if (buffer.equals("infinity") || buffer.equals("-infinity")) {
                return Dates.convertInfinityOutput(buffer.equals("infinity"), type, targetClass);
            }
            TemporalAccessor parsed = context.getServerDateFormat().getParser().parse(buffer);
            LocalDate date = LocalDate.from(parsed);
            return Dates.convertOutput(context, type, date, targetClass, calendar);
        }
    }

    static class BinEncoder
    extends BaseBinaryEncoder {
        BinEncoder() {
            super(4);
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, ByteBuf buffer) throws IOException {
            Calendar calendar = sourceContext != null ? (Calendar)sourceContext : Calendar.getInstance();
            LocalDate date = Dates.convertInput(context, type, value, calendar);
            if (date == LocalDate.MAX) {
                buffer.writeInt(Integer.MAX_VALUE);
            } else if (date == LocalDate.MIN) {
                buffer.writeInt(Integer.MIN_VALUE);
            } else {
                int daysPg = (int)DatesTimes.javaEpochToPg(date.toEpochDay(), TimeUnit.DAYS);
                buffer.writeInt(daysPg);
            }
        }
    }

    static class BinDecoder
    extends BaseBinaryDecoder {
        BinDecoder() {
            super(4);
        }

        @Override
        public Class<?> getDefaultClass() {
            return Date.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            Calendar calendar = targetContext != null ? (Calendar)targetContext : Calendar.getInstance();
            int daysPg = buffer.readInt();
            if (daysPg == Integer.MAX_VALUE || daysPg == Integer.MIN_VALUE) {
                return Dates.convertInfinityOutput(daysPg == Integer.MAX_VALUE, type, targetClass);
            }
            LocalDate date = LocalDate.ofEpochDay(DatesTimes.pgEpochToJava(daysPg, TimeUnit.DAYS));
            return Dates.convertOutput(context, type, date, targetClass, calendar);
        }
    }
}

