/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.api.jdbc.PGAnyType;
import com.impossibl.postgres.api.jdbc.PGConnection;
import com.impossibl.postgres.api.jdbc.PGNotificationListener;
import com.impossibl.postgres.jdbc.CancelRequestTask;
import com.impossibl.postgres.jdbc.ErrorUtils;
import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.Housekeeper;
import com.impossibl.postgres.jdbc.JDBCSettings;
import com.impossibl.postgres.jdbc.LargeObject;
import com.impossibl.postgres.jdbc.NotificationKey;
import com.impossibl.postgres.jdbc.PGBlob;
import com.impossibl.postgres.jdbc.PGBuffersArray;
import com.impossibl.postgres.jdbc.PGBuffersStruct;
import com.impossibl.postgres.jdbc.PGCallableStatement;
import com.impossibl.postgres.jdbc.PGClob;
import com.impossibl.postgres.jdbc.PGDatabaseMetaData;
import com.impossibl.postgres.jdbc.PGPreparedStatement;
import com.impossibl.postgres.jdbc.PGResolvedType;
import com.impossibl.postgres.jdbc.PGSQLSimpleException;
import com.impossibl.postgres.jdbc.PGSQLXML;
import com.impossibl.postgres.jdbc.PGSavepoint;
import com.impossibl.postgres.jdbc.PGSimpleStatement;
import com.impossibl.postgres.jdbc.PGStatement;
import com.impossibl.postgres.jdbc.PreparedStatementDescription;
import com.impossibl.postgres.jdbc.SQLText;
import com.impossibl.postgres.jdbc.SQLTextEscapes;
import com.impossibl.postgres.jdbc.SQLTextTree;
import com.impossibl.postgres.jdbc.SQLTextUtils;
import com.impossibl.postgres.jdbc.StatementCacheKey;
import com.impossibl.postgres.jdbc.StatementDescription;
import com.impossibl.postgres.protocol.FieldFormatRef;
import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.RequestExecutor;
import com.impossibl.postgres.protocol.RequestExecutorHandlers;
import com.impossibl.postgres.protocol.ResultBatch;
import com.impossibl.postgres.protocol.RowData;
import com.impossibl.postgres.protocol.ServerConnection;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.system.BasicContext;
import com.impossibl.postgres.system.Empty;
import com.impossibl.postgres.system.Setting;
import com.impossibl.postgres.system.Settings;
import com.impossibl.postgres.system.SystemSettings;
import com.impossibl.postgres.types.ArrayType;
import com.impossibl.postgres.types.CompositeType;
import com.impossibl.postgres.types.SharedRegistry;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.Await;
import com.impossibl.postgres.utils.BlockingReadTimeoutException;
import com.impossibl.postgres.utils.CacheMap;
import com.impossibl.postgres.utils.Nulls;
import com.impossibl.postgres.utils.guava.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class PGDirectConnection
extends BasicContext
implements PGConnection {
    private static final Logger logger = Logger.getLogger(PGDirectConnection.class.getName());
    boolean strict = this.getSetting(JDBCSettings.STRICT_MODE);
    private long statementId = 0L;
    private long portalId = 0L;
    private int savepointId;
    private int holdability;
    boolean autoCommit = true;
    private int networkTimeout = this.getSetting(JDBCSettings.DEFAULT_NETWORK_TIMEOUT);
    private SQLWarning warningChain;
    private Collection<WeakReference<PGStatement>> activeStatements = new ConcurrentLinkedQueue<WeakReference<PGStatement>>();
    private Map<StatementCacheKey, StatementDescription> descriptionCache;
    private Map<StatementCacheKey, PreparedStatementDescription> preparedStatementCache;
    private int preparedStatementCacheThreshold;
    private Map<StatementCacheKey, Integer> preparedStatementHeat;
    private Integer defaultFetchSize;
    private Map<NotificationKey, PGNotificationListener> notificationListeners = new ConcurrentHashMap<NotificationKey, PGNotificationListener>();
    final Housekeeper.Ref housekeeper;
    private final Object cleanupKey;
    private static Map<String, SQLText> parsedSqlCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    PGDirectConnection(SocketAddress address, Settings settings, Housekeeper.Ref housekeeper) throws IOException {
        super(address, settings.duplicateKnowing(JDBCSettings.JDBC, SystemSettings.SYS, SystemSettings.PROTO, SystemSettings.SERVER));
        int sqlCacheSize;
        int statementCacheThreshold;
        int statementCacheSize;
        int descriptionCacheSize = this.getSetting(JDBCSettings.DESCRIPTION_CACHE_SIZE);
        if (descriptionCacheSize > 0) {
            this.descriptionCache = Collections.synchronizedMap(new CacheMap(descriptionCacheSize, 1.1f, true));
        }
        if ((statementCacheSize = this.getSetting(JDBCSettings.PREPARED_STATEMENT_CACHE_SIZE).intValue()) > 0) {
            WeakReference<PGDirectConnection> weakThis = new WeakReference<PGDirectConnection>(this);
            this.preparedStatementCache = Collections.synchronizedMap(new CacheMap(statementCacheSize, 1.1f, true, eldest -> {
                try {
                    PGStatement.dispose((PGDirectConnection)weakThis.get(), ((PreparedStatementDescription)eldest.getValue()).name);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }));
        }
        if ((statementCacheThreshold = this.getSetting(JDBCSettings.PREPARED_STATEMENT_CACHE_THRESHOLD).intValue()) > 0) {
            this.preparedStatementCacheThreshold = statementCacheThreshold;
            this.preparedStatementHeat = new ConcurrentHashMap<StatementCacheKey, Integer>();
        }
        if ((sqlCacheSize = this.getSetting(JDBCSettings.PARSED_SQL_CACHE_SIZE).intValue()) > 0) {
            Class<PGDirectConnection> clazz = PGDirectConnection.class;
            // MONITORENTER : com.impossibl.postgres.jdbc.PGDirectConnection.class
            if (parsedSqlCache == null) {
                parsedSqlCache = Collections.synchronizedMap(new CacheMap(sqlCacheSize, 1.1f, true));
            }
            // MONITOREXIT : clazz
        }
        this.defaultFetchSize = this.getSetting(JDBCSettings.DEFAULT_FETCH_SIZE);
        this.prepareUtilQuery("TB", SQLTextUtils.getBeginText(), new String[0]);
        this.prepareUtilQuery("TC", SQLTextUtils.getCommitText(), new String[0]);
        this.prepareUtilQuery("TR", SQLTextUtils.getRollbackText(), new String[0]);
        this.housekeeper = housekeeper;
        if (this.housekeeper != null) {
            this.cleanupKey = this.housekeeper.add(this, new Cleanup(this.getServerConnection(), this.activeStatements, this.getSetting(SystemSettings.DATABASE_URL)));
            return;
        }
        this.cleanupKey = null;
    }

    @Override
    public void init(SharedRegistry.Factory sharedRegistryFactory) throws IOException {
        super.init(sharedRegistryFactory);
        this.applySettings(this.settings);
    }

    private void applySettings(Settings settings) throws IOException {
        if (settings.enabled(JDBCSettings.READ_ONLY)) {
            try {
                this.setReadOnly(true);
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
    }

    public TransactionStatus getTransactionStatus() throws SQLException {
        try {
            return this.getServerConnection().getTransactionStatus();
        }
        catch (ClosedChannelException e) {
            this.internalClose();
            throw Exceptions.CLOSED_CONNECTION;
        }
        catch (IOException e) {
            this.internalClose();
            throw new PGSQLSimpleException(e);
        }
    }

    void addWarning(SQLWarning warning) {
        this.warningChain = ErrorUtils.chainWarnings(this.warningChain, warning);
    }

    void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("connection closed", "08006");
        }
    }

    private void checkManualCommit() throws SQLException {
        if (this.autoCommit) {
            throw new SQLException("must not be in auto-commit mode");
        }
    }

    String getNextStatementName() {
        return Long.toHexString(++this.statementId);
    }

    String getNextPortalName() {
        return Long.toHexString(++this.portalId);
    }

    void handleStatementClosure(PGStatement statement) {
        Iterator<WeakReference<PGStatement>> statementRefIter = this.activeStatements.iterator();
        while (statementRefIter.hasNext()) {
            WeakReference<PGStatement> statementRef = statementRefIter.next();
            PGStatement s = (PGStatement)statementRef.get();
            if (s == null) {
                statementRefIter.remove();
                continue;
            }
            if (s != statement) continue;
            statementRefIter.remove();
            break;
        }
    }

    private static void closeStatements(Collection<WeakReference<PGStatement>> statements) {
        for (WeakReference<PGStatement> statementRef : statements) {
            PGStatement statement = (PGStatement)statementRef.get();
            if (statement == null) continue;
            try {
                statement.internalClose();
            }
            catch (SQLException sQLException) {}
        }
    }

    private void closeStatements() {
        PGDirectConnection.closeStatements(this.activeStatements);
        this.activeStatements.clear();
    }

    SQLText parseSQL(String sqlText) throws SQLException {
        try {
            boolean standardConformingStrings = this.getSetting(SystemSettings.STANDARD_CONFORMING_STRINGS, false);
            if (parsedSqlCache == null) {
                return new SQLText(sqlText, standardConformingStrings);
            }
            SQLText parsedSql = parsedSqlCache.get(sqlText);
            if (parsedSql == null) {
                parsedSql = new SQLText(sqlText, standardConformingStrings);
                parsedSqlCache.put(sqlText, parsedSql);
            }
            return parsedSql.copy();
        }
        catch (ParseException e) {
            throw new SQLException("Error parsing SQL at position " + e.getErrorOffset() + " (" + sqlText + "): " + e.getMessage());
        }
    }

    void execute(QueryFunction function) throws SQLException {
        this.execute((long timeout) -> {
            function.query(timeout);
            return null;
        });
    }

    <T> T execute(QueryResultFunction<T> function) throws SQLException {
        try {
            if (!this.autoCommit && this.getTransactionStatus() == TransactionStatus.Idle) {
                this.getRequestExecutor().lazyExecute("TB");
            }
            return function.query(this.networkTimeout);
        }
        catch (BlockingReadTimeoutException e) {
            this.internalClose();
            throw new SQLTimeoutException(e);
        }
        catch (InterruptedIOException | ClosedChannelException e) {
            this.internalClose();
            throw Exceptions.CLOSED_CONNECTION;
        }
        catch (IOException e) {
            if (!this.getServerConnection().isConnected()) {
                this.internalClose();
            }
            throw ErrorUtils.makeSQLException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> T executeTimed(Long executionTimeout, QueryResultFunction<T> function) throws SQLException {
        if (executionTimeout == null || executionTimeout < 1L || this.networkTimeout > 0 && (long)this.networkTimeout < executionTimeout) {
            return this.execute(function);
        }
        RequestExecutor requestExecutor = this.getRequestExecutor();
        synchronized (requestExecutor) {
            CancelRequestTask task = new CancelRequestTask(this.getServerConnection().getRemoteAddress(), this.getKeyData());
            ScheduledFuture<?> taskHandle = this.getServerConnection().getIOExecutor().schedule(task, (long)executionTimeout, TimeUnit.MILLISECONDS);
            T t = this.execute(function);
            return t;
            finally {
                taskHandle.cancel(true);
                task.cancel();
            }
        }
    }

    void execute(String sql) throws SQLException {
        this.execute((long timeout) -> this.query(sql, timeout));
    }

    String executeForString(String sql) throws SQLException {
        return this.execute((long timeout) -> this.queryString(sql, timeout));
    }

    private ResultBatch executeForResultBatch(String sql) throws SQLException {
        return this.execute((long timeout) -> this.queryBatch(sql, timeout));
    }

    private ResultBatch executeForResultBatch(String sql, Object[] params) throws SQLException {
        return this.execute((long timeout) -> this.queryBatchPrepared(sql, params, timeout));
    }

    private ResultBatch executeForResultBatch(String sql, FieldFormatRef[] parameterFormats, ByteBuf[] parameterBuffers) throws SQLException {
        return this.execute((long timeout) -> this.queryBatchPrepared(sql, parameterFormats, parameterBuffers, timeout));
    }

    RowData executeForResult(String sql) throws SQLException {
        try (ResultBatch resultBatch = this.executeForResultBatch(sql);){
            if (resultBatch.isEmpty()) {
                RowData rowData = null;
                return rowData;
            }
            RowData rowData = resultBatch.borrowRows().take(0);
            return rowData;
        }
    }

    <T> T executeForValue(String sql, Class<T> returnType, Object ... params) throws SQLException {
        ResultBatch resultBatch = this.executeForResultBatch(sql, params);
        try {
            Object value = resultBatch.borrowRows().borrow(0).getField(0, resultBatch.getFields()[0], this, returnType, null);
            T t = returnType.cast(value);
            return t;
        }
        catch (IOException e) {
            throw new SQLException("Error decoding column", e);
        }
        finally {
            if (resultBatch != null) {
                try {
                    resultBatch.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    long executeForRowsAffected(String sql) throws SQLException {
        try (ResultBatch resultBatch = this.executeForResultBatch(sql);){
            long l = Nulls.firstNonNull(resultBatch.getRowsAffected(), 0L);
            return l;
        }
    }

    long executeForRowsAffected(String sql, FieldFormatRef[] paramFormats, ByteBuf[] paramBuffers) throws SQLException {
        try (ResultBatch resultBatch = this.executeForResultBatch(sql, paramFormats, paramBuffers);){
            long l = Nulls.firstNonNull(resultBatch.getRowsAffected(), 0L);
            return l;
        }
    }

    @Override
    public void setStrictMode(boolean v) {
        this.strict = v;
    }

    @Override
    public boolean isStrictMode() {
        return this.strict;
    }

    @Override
    public void setDefaultFetchSize(Integer v) {
        this.defaultFetchSize = v;
    }

    @Override
    public Integer getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    @Override
    public PGAnyType resolveType(String name) throws SQLException {
        try {
            Type type = this.registry.loadTransientType(name);
            return new PGResolvedType(type);
        }
        catch (IOException e) {
            throw ErrorUtils.makeSQLException(e);
        }
    }

    private void internalClose() {
        this.cleanupClosed();
        this.shutdown().awaitUninterruptibly(this.networkTimeout > 0 ? (long)this.networkTimeout : Integer.MAX_VALUE);
    }

    private void cleanupClosed() {
        this.closeStatements();
        if (this.housekeeper != null) {
            this.housekeeper.remove(this.cleanupKey);
            this.housekeeper.release();
        }
    }

    @Override
    protected void connectionClosed() {
        this.cleanupClosed();
        this.reportClosed();
        this.notificationListeners.clear();
    }

    @Override
    public boolean isServerMinimumVersion(int major, int minor) {
        return this.getServerConnection().getServerInfo().getVersion().isMinimum(major, minor);
    }

    @Override
    public synchronized boolean isValid(int timeout) throws SQLException {
        boolean result;
        if (this.isClosed()) {
            return false;
        }
        if (timeout < 0) {
            throw new SQLException("Timeout is less than 0");
        }
        try {
            RequestExecutorHandlers.SynchronizedResult syncResult = new RequestExecutorHandlers.SynchronizedResult();
            this.getServerConnection().getRequestExecutor().sync(syncResult);
            syncResult.await(timeout, TimeUnit.SECONDS);
            result = true;
        }
        catch (Exception se) {
            result = false;
        }
        return result;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkClosed();
        return this.getCustomTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> typeMap) throws SQLException {
        this.checkClosed();
        this.typeMap = Collections.unmodifiableMap(typeMap);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return this.holdability;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        if (holdability != 2 && holdability != 1) {
            throw new SQLException("illegal argument");
        }
        this.holdability = holdability;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new PGDatabaseMetaData(this);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.autoCommit;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        if (this.autoCommit == autoCommit) {
            return;
        }
        if (!this.autoCommit && this.getTransactionStatus() != TransactionStatus.Idle) {
            this.execute(SQLTextUtils.getCommitText());
        }
        this.autoCommit = autoCommit;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        String readability = this.executeForString(SQLTextUtils.getGetSessionReadabilityText());
        return SQLTextUtils.isTrue(readability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        if (this.getTransactionStatus() != TransactionStatus.Idle) {
            throw new SQLException("cannot set read only during a transaction");
        }
        this.execute(SQLTextUtils.getSetSessionReadabilityText(readOnly));
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        String isolLevel = this.executeForString(SQLTextUtils.getGetSessionIsolationLevelText());
        return SQLTextUtils.getIsolationLevel(isolLevel);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        if (level != 0 && level != 1 && level != 2 && level != 4 && level != 8) {
            throw new SQLException("illegal argument");
        }
        this.execute(SQLTextUtils.getSetSessionIsolationLevelText(level));
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        this.checkManualCommit();
        if (this.getTransactionStatus() != TransactionStatus.Idle) {
            this.execute("@TC");
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        this.checkManualCommit();
        if (this.getTransactionStatus() != TransactionStatus.Idle) {
            this.execute("@TR");
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        this.checkManualCommit();
        PGSavepoint savepoint = new PGSavepoint(++this.savepointId);
        this.execute(SQLTextUtils.getSetSavepointText(savepoint));
        return savepoint;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        this.checkManualCommit();
        PGSavepoint savepoint = new PGSavepoint(name);
        this.execute(SQLTextUtils.getSetSavepointText(savepoint));
        return savepoint;
    }

    @Override
    public void rollback(Savepoint savepointParam) throws SQLException {
        this.checkClosed();
        this.checkManualCommit();
        PGSavepoint savepoint = (PGSavepoint)savepointParam;
        if (!savepoint.isValid()) {
            throw new SQLException("invalid savepoint");
        }
        try {
            if (this.getTransactionStatus() != TransactionStatus.Idle) {
                this.execute(SQLTextUtils.getRollbackToText(savepoint));
            }
        }
        finally {
            savepoint.setReleased(true);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepointParam) throws SQLException {
        this.checkClosed();
        this.checkManualCommit();
        PGSavepoint savepoint = (PGSavepoint)savepointParam;
        if (!savepoint.isValid()) {
            throw new SQLException("invalid savepoint");
        }
        try {
            if (!savepoint.getReleased() && this.getTransactionStatus() != TransactionStatus.Idle) {
                this.execute(SQLTextUtils.getReleaseSavepointText(savepoint));
            }
        }
        finally {
            savepoint.invalidate();
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return this.executeForString("SELECT current_schema()");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkClosed();
        if (schema == null) {
            this.execute("SET search_path TO DEFAULT");
        } else {
            schema = SQLTextUtils.escapeLiteral(schema, this.settings.enabled(SystemSettings.STANDARD_CONFORMING_STRINGS));
            ReferenceCountUtil.release((Object)this.executeForResultBatch(String.format("SET SCHEMA '%s'", schema)));
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        SQLText sqlText = this.parseSQL(sql);
        SQLTextEscapes.processEscapes(sqlText, this);
        return sqlText.toString();
    }

    @Override
    public PGStatement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 2);
    }

    @Override
    public PGStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public PGStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        PGSimpleStatement statement = new PGSimpleStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.activeStatements.add(new WeakReference<PGSimpleStatement>(statement));
        return statement;
    }

    @Override
    public PGPreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, 2);
    }

    @Override
    public PGPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public PGPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        SQLText sqlText = this.parseSQL(sql);
        return this.prepareStatement(sqlText, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PGPreparedStatement prepareStatement(SQLText sqlText, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        SQLTextEscapes.processEscapes(sqlText, this);
        String cursorName = null;
        if (!(resultSetType == 1003 && resultSetConcurrency != 1008 || SQLTextUtils.prependCursorDeclaration(sqlText, cursorName = "cursor" + this.getNextStatementName(), resultSetType, resultSetHoldability, this.autoCommit))) {
            cursorName = null;
        }
        int[] parameterCount = new int[1];
        sqlText.process(node -> {
            if (node instanceof SQLTextTree.ParameterPiece) {
                parameterCount[0] = parameterCount[0] + 1;
            }
            return node;
        }, true);
        if (parameterCount[0] > 65535) {
            throw new PGSQLSimpleException("Too many parameters specified: Max of 65535 allowed");
        }
        PGPreparedStatement statement = new PGPreparedStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability, sqlText.toString(), parameterCount[0], cursorName);
        this.activeStatements.add(new WeakReference<PGPreparedStatement>(statement));
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        SQLText sqlText = this.parseSQL(sql);
        if (autoGeneratedKeys != 1) {
            return this.prepareStatement(sql);
        }
        if (!SQLTextUtils.appendReturningClause(sqlText)) {
            throw Exceptions.INVALID_COMMAND_FOR_GENERATED_KEYS;
        }
        PGPreparedStatement statement = this.prepareStatement(sqlText, 1003, 1007, 2);
        statement.setWantsGeneratedKeys();
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        SQLText sqlText = this.parseSQL(sql);
        if (!SQLTextUtils.appendReturningClause(sqlText, Arrays.asList(columnNames))) {
            throw Exceptions.INVALID_COMMAND_FOR_GENERATED_KEYS;
        }
        PGPreparedStatement statement = this.prepareStatement(sqlText, 1003, 1007, 2);
        statement.setWantsGeneratedKeys();
        return statement;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, 1003, 1007, this.getHoldability());
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        SQLText sqlText = this.parseSQL(sql);
        return this.prepareCall(sqlText, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    private PGCallableStatement prepareCall(SQLText sqlText, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        int[] parameterCount = new int[1];
        SQLTextTree.Processor counter = node -> {
            if (node instanceof SQLTextTree.ParameterPiece) {
                parameterCount[0] = parameterCount[0] + 1;
            }
            return node;
        };
        sqlText.process(counter, true);
        int preParameterCount = parameterCount[0];
        SQLTextEscapes.processEscapes(sqlText, this);
        parameterCount[0] = 0;
        sqlText.process(counter, true);
        int finalParameterCount = parameterCount[0];
        String cursorName = null;
        if (!(resultSetType == 1003 && resultSetConcurrency != 1008 || SQLTextUtils.prependCursorDeclaration(sqlText, cursorName = "cursor" + this.getNextStatementName(), resultSetType, resultSetHoldability, this.autoCommit))) {
            cursorName = null;
        }
        boolean hasAssign = preParameterCount == finalParameterCount + 1;
        PGCallableStatement statement = new PGCallableStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability, sqlText.toString(), parameterCount[0], cursorName, hasAssign);
        this.activeStatements.add(new WeakReference<PGCallableStatement>(statement));
        return statement;
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        int loOid = LargeObject.creat(this, 0);
        return new PGBlob(this, loOid);
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        int loOid = LargeObject.creat(this, 0);
        return new PGClob(this, loOid);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        return new PGSQLXML(this);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        try {
            Type elementType = this.getRegistry().loadTransientType(typeName);
            if (elementType == null) {
                throw new PGSQLSimpleException("Unknown element type");
            }
            Type type = this.getRegistry().loadType(elementType.getArrayTypeId());
            if (!(type instanceof ArrayType)) {
                throw new SQLException("Array type not found");
            }
            return PGBuffersArray.encode(this, (ArrayType)type, elements);
        }
        catch (IOException e) {
            throw ErrorUtils.makeSQLException("Error encoding array values", e);
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkClosed();
        try {
            Type type = this.getRegistry().loadTransientType(typeName);
            if (!(type instanceof CompositeType)) {
                throw new SQLException("Invalid type for struct");
            }
            return PGBuffersStruct.Binary.encode(this, (CompositeType)type, attributes);
        }
        catch (IOException e) {
            throw ErrorUtils.makeSQLException("Error encoding struct", e);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        Setting<?> setting = JDBCSettings.CLIENT_INFO.getAllNamedSettings().get(name);
        if (setting == null) {
            return null;
        }
        setting = this.settings.mapUnknownSetting(setting);
        return this.settings.getText(setting);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        Properties clientInfo = new Properties();
        this.settings.addMappedUnknownSetting(JDBCSettings.CI_APPLICATION_NAME, clientInfo).addMappedUnknownSetting(JDBCSettings.CI_CLIENT_USER, clientInfo);
        return clientInfo;
    }

    private void setClientInfo(Setting<?> setting, String value) throws SQLException {
        if (setting == JDBCSettings.CI_APPLICATION_NAME) {
            String sqlValue = SQLTextUtils.escapeLiteral(value, this.settings.enabled(SystemSettings.STANDARD_CONFORMING_STRINGS));
            this.execute("SET application_name = '" + sqlValue + "'");
        } else if (setting == JDBCSettings.CI_CLIENT_USER) {
            String sqlValue = SQLTextUtils.escapeLiteral(value, this.settings.enabled(SystemSettings.STANDARD_CONFORMING_STRINGS));
            this.execute("SET session_authorization = '" + sqlValue + "'");
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        Setting<?> setting = JDBCSettings.CLIENT_INFO.getAllNamedSettings().get(name);
        if (setting == null) {
            logger.warning("Unknown client info: " + name);
            return;
        }
        try {
            this.checkClosed();
            this.setClientInfo(setting, value);
        }
        catch (SQLException e) {
            HashMap<String, ClientInfoStatus> results = new HashMap<String, ClientInfoStatus>();
            results.put(name, ClientInfoStatus.REASON_UNKNOWN);
            throw new SQLClientInfoException(e.getMessage(), results, (Throwable)e);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.isClosed()) {
            return;
        }
        HashMap<String, ClientInfoStatus> results = new HashMap<String, ClientInfoStatus>();
        for (String name : properties.stringPropertyNames()) {
            Setting<?> setting = JDBCSettings.CLIENT_INFO.getAllNamedSettings().get(name);
            if (setting == null) {
                results.put(name, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
                continue;
            }
            try {
                this.setClientInfo(setting, properties.getProperty(name));
            }
            catch (SQLException e) {
                results.put(name, ClientInfoStatus.REASON_UNKNOWN);
            }
        }
        throw new SQLClientInfoException(results);
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public boolean isClosed() {
        return !this.getServerConnection().isConnected();
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.internalClose();
    }

    @Override
    public void abort(Executor executor) {
        if (this.isClosed()) {
            return;
        }
        SocketAddress serverAddress = this.getServerConnection().getRemoteAddress();
        ChannelFuture shutdown = this.shutdown();
        executor.execute(new CancelRequestTask(serverAddress, this.getKeyData()));
        shutdown.syncUninterruptibly();
        if (this.housekeeper != null) {
            this.housekeeper.remove(this.cleanupKey);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warningChain;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warningChain = null;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkClosed();
        return this.networkTimeout;
    }

    @Override
    public void setNetworkTimeout(Executor executor, int networkTimeout) throws SQLException {
        this.checkClosed();
        if (networkTimeout < 0) {
            throw new SQLException("invalid network timeout");
        }
        this.networkTimeout = networkTimeout;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isAssignableFrom(this.getClass())) {
            throw Exceptions.UNWRAP_ERROR;
        }
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    protected void connectionNotificationReceived(int processId, String channelName, String payload) {
        this.reportNotification(processId, channelName, payload);
    }

    @Override
    public void addNotificationListener(PGNotificationListener listener) {
        this.addNotificationListener(null, null, listener);
    }

    @Override
    public void addNotificationListener(String channelNameFilter, PGNotificationListener listener) {
        this.addNotificationListener(null, channelNameFilter, listener);
    }

    @Override
    public void addNotificationListener(String name, String channelNameFilter, PGNotificationListener listener) {
        name = Strings.nullToEmpty(name);
        channelNameFilter = channelNameFilter != null ? channelNameFilter : ".*";
        Pattern channelNameFilterPattern = Pattern.compile(channelNameFilter);
        NotificationKey key = new NotificationKey(name, channelNameFilterPattern);
        this.notificationListeners.put(key, listener);
    }

    @Override
    public void removeNotificationListener(PGNotificationListener listener) {
        Iterator<Map.Entry<NotificationKey, PGNotificationListener>> iter = this.notificationListeners.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<NotificationKey, PGNotificationListener> entry = iter.next();
            PGNotificationListener iterListener = entry.getValue();
            if (iterListener != null && !iterListener.equals(listener)) continue;
            iter.remove();
        }
    }

    @Override
    public void removeNotificationListener(String listenerName) {
        Iterator<Map.Entry<NotificationKey, PGNotificationListener>> iter = this.notificationListeners.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<NotificationKey, PGNotificationListener> entry = iter.next();
            String iterListenerName = entry.getKey().name;
            PGNotificationListener iterListener = entry.getValue();
            if (!iterListenerName.equals(listenerName) && iterListener != null) continue;
            iter.remove();
        }
    }

    private void reportNotification(int processId, String channelName, String payload) {
        for (Map.Entry<NotificationKey, PGNotificationListener> entry : this.notificationListeners.entrySet()) {
            PGNotificationListener listener = entry.getValue();
            if (!entry.getKey().channelNameFilter.matcher(channelName).matches()) continue;
            try {
                listener.notification(processId, channelName, payload);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Exception in connection listener", t);
            }
        }
    }

    private void reportClosed() {
        for (Map.Entry<NotificationKey, PGNotificationListener> entry : this.notificationListeners.entrySet()) {
            PGNotificationListener listener = entry.getValue();
            try {
                listener.closed();
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Exception in connection listener", t);
            }
        }
    }

    boolean isCacheEnabled() {
        return this.preparedStatementCache != null;
    }

    StatementDescription getCachedStatementDescription(String sql, StatementDescriptionLoader loader) throws SQLException {
        StatementDescription cached;
        StatementCacheKey key = new StatementCacheKey(sql, Empty.EMPTY_TYPES);
        if (this.preparedStatementCache != null && (cached = this.preparedStatementCache.get(key)) != null) {
            return cached;
        }
        cached = this.descriptionCache.get(key);
        if (cached != null) {
            return cached;
        }
        try {
            cached = loader.load();
        }
        catch (IOException e) {
            throw ErrorUtils.makeSQLException(e);
        }
        this.descriptionCache.put(key, cached);
        return cached;
    }

    PreparedStatementDescription getCachedPreparedStatement(StatementCacheKey key, PreparedStatementDescriptionLoader loader) throws SQLException {
        if (this.preparedStatementCache == null) {
            try {
                return loader.load();
            }
            catch (IOException e) {
                throw ErrorUtils.makeSQLException(e);
            }
        }
        PreparedStatementDescription cached = this.preparedStatementCache.get(key);
        if (cached != null) {
            return cached;
        }
        if (this.preparedStatementHeat != null) {
            Integer heat = this.preparedStatementHeat.computeIfPresent(key, (k, h) -> h + 1);
            if (heat == null) {
                this.preparedStatementHeat.put(key, 1);
                return null;
            }
            if (heat < this.preparedStatementCacheThreshold) {
                return null;
            }
        }
        try {
            cached = loader.load();
        }
        catch (IOException e) {
            throw ErrorUtils.makeSQLException(e);
        }
        this.preparedStatementCache.put(key, cached);
        this.descriptionCache.putIfAbsent(new StatementCacheKey(key.getSql(), Empty.EMPTY_TYPES), cached);
        return cached;
    }

    @Override
    public void copyFrom(String sql, InputStream inputStream) throws SQLException {
        final AtomicReference<Object> errorRef = new AtomicReference<Object>(null);
        this.execute((long timeout) -> {
            final CountDownLatch latch = new CountDownLatch(1);
            this.getRequestExecutor().copyFrom(sql, inputStream, new RequestExecutor.CopyFromHandler(){

                @Override
                public void handleComplete() {
                }

                @Override
                public void handleError(Throwable cause, List<Notice> notices) {
                    PGDirectConnection.this.warningChain = ErrorUtils.chainWarnings(PGDirectConnection.this.warningChain, ErrorUtils.makeSQLWarningChain(notices));
                    errorRef.set(cause);
                    latch.countDown();
                }

                @Override
                public void handleReady(TransactionStatus transactionStatus) {
                    latch.countDown();
                }
            });
            Await.awaitUninterruptibly(timeout, TimeUnit.MILLISECONDS, latch::await);
        });
        Throwable error = errorRef.get();
        if (error != null) {
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            if (error instanceof Error) {
                throw (Error)error;
            }
            throw ErrorUtils.makeSQLException((Exception)error);
        }
    }

    @Override
    public void copyTo(String sql, OutputStream outputStream) throws SQLException {
        final AtomicReference<Object> errorRef = new AtomicReference<Object>(null);
        this.execute((long timeout) -> {
            final CountDownLatch latch = new CountDownLatch(1);
            this.getRequestExecutor().copyTo(sql, outputStream, new RequestExecutor.CopyToHandler(){

                @Override
                public void handleComplete() {
                }

                @Override
                public void handleError(Throwable cause, List<Notice> notices) {
                    PGDirectConnection.this.warningChain = ErrorUtils.chainWarnings(PGDirectConnection.this.warningChain, ErrorUtils.makeSQLWarningChain(notices));
                    errorRef.set(cause);
                    latch.countDown();
                }

                @Override
                public void handleReady(TransactionStatus transactionStatus) {
                    latch.countDown();
                }
            });
            Await.awaitUninterruptibly(timeout, TimeUnit.MILLISECONDS, latch::await);
        });
        Throwable error = errorRef.get();
        if (error != null) {
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            if (error instanceof Error) {
                throw (Error)error;
            }
            throw ErrorUtils.makeSQLException((Exception)error);
        }
    }

    static interface PreparedStatementDescriptionLoader {
        public PreparedStatementDescription load() throws IOException, SQLException;
    }

    static interface StatementDescriptionLoader {
        public StatementDescription load() throws IOException, SQLException;
    }

    static interface QueryResultFunction<T> {
        public T query(long var1) throws IOException;
    }

    static interface QueryFunction {
        public void query(long var1) throws IOException;
    }

    private static class Cleanup
    implements Housekeeper.CleanupRunnable {
        ServerConnection serverConnection;
        Collection<WeakReference<PGStatement>> statements;
        StackTraceElement[] allocationStackTrace;
        String connectionInfo;

        private Cleanup(ServerConnection serverConnection, Collection<WeakReference<PGStatement>> statements, String connectionInfo) {
            this.serverConnection = serverConnection;
            this.statements = statements;
            this.allocationStackTrace = new Exception().getStackTrace();
            this.connectionInfo = connectionInfo;
        }

        @Override
        public String getKind() {
            return "connection ( " + this.connectionInfo + " )";
        }

        @Override
        public StackTraceElement[] getAllocationStackTrace() {
            return this.allocationStackTrace;
        }

        @Override
        public void run() {
            this.serverConnection.shutdown();
            PGDirectConnection.closeStatements(this.statements);
        }
    }
}

