/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.ExecutionTimerTask;
import com.impossibl.postgres.protocol.ServerConnection;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.Socket;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class CancelRequestTask
extends ExecutionTimerTask {
    private static final Logger logger = Logger.getLogger(CancelRequestTask.class.getName());
    private SocketAddress serverAddress;
    private ServerConnection.KeyData keyData;

    CancelRequestTask(SocketAddress serverAddress, ServerConnection.KeyData keyData) {
        this.serverAddress = serverAddress;
        this.keyData = keyData;
    }

    @Override
    public void go() {
        this.sendCancelRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCancelRequest() {
        block29: {
            if (this.isCancelled()) {
                return;
            }
            if (this.keyData.getProcessId() == 0 && this.keyData.getSecretKey() == 0) {
                logger.warning("Cannot send CancelRequest because of missing BackendKeyData.");
                return;
            }
            try {
                if (this.serverAddress instanceof InetSocketAddress) {
                    InetSocketAddress target = (InetSocketAddress)this.serverAddress;
                    try (java.net.Socket abortSocket = new java.net.Socket(target.getAddress(), target.getPort());){
                        OutputStream abortSocketStream = abortSocket.getOutputStream();
                        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                            this.writeCancelRequest(new DataOutputStream(os));
                            byte[] request = os.toByteArray();
                            if (this.isCancelled()) {
                                return;
                            }
                            abortSocketStream.write(request);
                            break block29;
                        }
                    }
                }
                if (!(this.serverAddress instanceof DomainSocketAddress)) break block29;
                try (Socket unixSocket = Socket.newSocketDomain();){
                    unixSocket.connect(this.serverAddress);
                    try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                        this.writeCancelRequest(new DataOutputStream(os));
                        byte[] request = os.toByteArray();
                        ByteBuffer buffer = ByteBuffer.allocateDirect(request.length);
                        buffer.put(request, 0, request.length);
                        buffer.flip();
                        if (this.isCancelled()) {
                            return;
                        }
                        unixSocket.write(buffer, 0, buffer.limit());
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void writeCancelRequest(DataOutputStream os) throws IOException {
        os.writeInt(16);
        os.writeInt(80877102);
        os.writeInt(this.keyData.getProcessId());
        os.writeInt(this.keyData.getSecretKey());
    }
}

