/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pdf;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.pdf.PdfOperation;
import org.apache.camel.component.pdf.Standard14Fonts;
import org.apache.camel.component.pdf.TextProcessingFactory;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;

@UriParams
public class PdfConfiguration {
    private static final Map<String, PDRectangle> PAGE_MAP = new HashMap<String, PDRectangle>();
    @UriPath(description="Operation type")
    @Metadata(required=true)
    private PdfOperation operation;
    @UriParam(defaultValue="20")
    private int marginTop = 20;
    @UriParam(defaultValue="20")
    private int marginBottom = 20;
    @UriParam(defaultValue="20")
    private int marginLeft = 20;
    @UriParam(defaultValue="40")
    private int marginRight = 40;
    @UriParam(defaultValue="14")
    private float fontSize = 14.0f;
    @UriParam(defaultValue="A4", enums="LETTER,LEGAL,A0,A1,A2,A3,A4,A5,A6")
    private String pageSize = "PAGE_SIZE_A4";
    @UriParam(defaultValue="Helvetica", enums="Courier,Courier-Bold,Courier-Oblique,Courier-BoldOblique,Helvetica,Helvetica-Bold,Helvetica-Oblique,Helvetica-BoldOblique,Times-Roman,Times-Bold,Times-Italic,Times-BoldItalic,Symbol,ZapfDingbats")
    private String font = "Helvetica";
    @UriParam(defaultValue="lineTermination")
    private TextProcessingFactory textProcessingFactory = TextProcessingFactory.lineTermination;

    public PdfOperation getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = PdfOperation.valueOf(operation);
    }

    public void setOperation(PdfOperation operation) {
        this.operation = operation;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(int marginRight) {
        this.marginRight = marginRight;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public PDRectangle getPageSize() {
        return PAGE_MAP.get(this.pageSize);
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }

    public PDFont getFont() {
        return Standard14Fonts.getByName(this.font);
    }

    public void setFont(String font) {
        this.font = font;
    }

    public TextProcessingFactory getTextProcessingFactory() {
        return this.textProcessingFactory;
    }

    public void setTextProcessingFactory(TextProcessingFactory textProcessingFactory) {
        this.textProcessingFactory = textProcessingFactory;
    }

    public void setTextProcessingFactory(String textProcessingFactory) {
        this.textProcessingFactory = TextProcessingFactory.valueOf(textProcessingFactory);
    }

    static {
        PAGE_MAP.put("PAGE_SIZE_A0", PDRectangle.A0);
        PAGE_MAP.put("PAGE_SIZE_A1", PDRectangle.A1);
        PAGE_MAP.put("PAGE_SIZE_A2", PDRectangle.A2);
        PAGE_MAP.put("PAGE_SIZE_A3", PDRectangle.A3);
        PAGE_MAP.put("PAGE_SIZE_A4", PDRectangle.A4);
        PAGE_MAP.put("PAGE_SIZE_A5", PDRectangle.A5);
        PAGE_MAP.put("PAGE_SIZE_A6", PDRectangle.A6);
        PAGE_MAP.put("PAGE_SIZE_LETTER", PDRectangle.LETTER);
    }
}

