/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.uow;

import java.util.LinkedHashSet;
import java.util.Set;
import org.kie.kogito.event.EventManager;
import org.kie.kogito.services.event.impl.BaseEventManager;
import org.kie.kogito.services.uow.ManagedUnitOfWork;
import org.kie.kogito.services.uow.PassThroughUnitOfWork;
import org.kie.kogito.uow.UnitOfWork;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kie.kogito.uow.events.UnitOfWorkAbortEvent;
import org.kie.kogito.uow.events.UnitOfWorkEndEvent;
import org.kie.kogito.uow.events.UnitOfWorkEventListener;
import org.kie.kogito.uow.events.UnitOfWorkStartEvent;

public class DefaultUnitOfWorkManager
implements UnitOfWorkManager {
    private ThreadLocal<UnitOfWork> currentUnitOfWork = new ThreadLocal();
    private UnitOfWork fallbackUnitOfWork = new PassThroughUnitOfWork();
    private UnitOfWorkFactory factory;
    private EventManager eventManager = new BaseEventManager();
    private Set<UnitOfWorkEventListener> listeners = new LinkedHashSet<UnitOfWorkEventListener>();

    public DefaultUnitOfWorkManager(UnitOfWorkFactory factory) {
        this.factory = factory;
    }

    public DefaultUnitOfWorkManager(UnitOfWork fallbackUnitOfWork, UnitOfWorkFactory factory) {
        this.fallbackUnitOfWork = fallbackUnitOfWork;
        this.factory = factory;
    }

    public UnitOfWork currentUnitOfWork() {
        UnitOfWork unit = this.currentUnitOfWork.get();
        if (unit == null) {
            return this.fallbackUnitOfWork;
        }
        return unit;
    }

    public UnitOfWork newUnitOfWork() {
        return new ManagedUnitOfWork(this.factory.create(this.eventManager), this::onStart, this::onEnd, this::onAbort);
    }

    protected void onStart(UnitOfWork unit) {
        this.associate(unit);
        this.listeners.forEach(l -> l.onBeforeStartEvent(new UnitOfWorkStartEvent(unit)));
    }

    protected void onEnd(UnitOfWork unit) {
        this.dissociate(unit);
        this.listeners.forEach(l -> l.onAfterEndEvent(new UnitOfWorkEndEvent(unit)));
    }

    protected void onAbort(UnitOfWork unit) {
        this.dissociate(unit);
        this.listeners.forEach(l -> l.onAfterAbortEvent(new UnitOfWorkAbortEvent(unit)));
    }

    protected void associate(UnitOfWork unit) {
        this.currentUnitOfWork.set(unit);
    }

    protected void dissociate(UnitOfWork unit) {
        this.currentUnitOfWork.set(null);
    }

    public EventManager eventManager() {
        return this.eventManager;
    }

    public void register(UnitOfWorkEventListener listener) {
        this.listeners.add(listener);
    }
}

