/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardmediumsoftbigdecimal;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScoreHolder;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;

public final class HardMediumSoftBigDecimalScoreHolderImpl
extends AbstractScoreHolder<HardMediumSoftBigDecimalScore>
implements HardMediumSoftBigDecimalScoreHolder {
    protected final Map<Rule, AbstractScoreHolder.BigDecimalMatchExecutor> matchExecutorByNumberMap = new LinkedHashMap<Rule, AbstractScoreHolder.BigDecimalMatchExecutor>();
    protected final Map<Rule, AbstractScoreHolder.ScoreMatchExecutor<HardMediumSoftBigDecimalScore>> matchExecutorByScoreMap = new LinkedHashMap<Rule, AbstractScoreHolder.ScoreMatchExecutor<HardMediumSoftBigDecimalScore>>();
    protected BigDecimal hardScore = BigDecimal.ZERO;
    protected BigDecimal mediumScore = BigDecimal.ZERO;
    protected BigDecimal softScore = BigDecimal.ZERO;

    public HardMediumSoftBigDecimalScoreHolderImpl(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled, HardMediumSoftBigDecimalScore.ZERO);
    }

    public BigDecimal getHardScore() {
        return this.hardScore;
    }

    public BigDecimal getMediumScore() {
        return this.mediumScore;
    }

    public BigDecimal getSoftScore() {
        return this.softScore;
    }

    @Override
    public void configureConstraintWeight(Rule rule, HardMediumSoftBigDecimalScore constraintWeight) {
        super.configureConstraintWeight(rule, constraintWeight);
        AbstractScoreHolder.BigDecimalMatchExecutor matchExecutor = constraintWeight.equals(HardMediumSoftBigDecimalScore.ZERO) ? (kcontext, matchWeight, justifications) -> {} : (constraintWeight.getMediumScore().equals(BigDecimal.ZERO) && constraintWeight.getSoftScore().equals(BigDecimal.ZERO) ? (kcontext, matchWeight, justifications) -> this.addHardConstraintMatch(kcontext, constraintWeight.getHardScore().multiply(matchWeight), justifications) : (constraintWeight.getHardScore().equals(BigDecimal.ZERO) && constraintWeight.getSoftScore().equals(BigDecimal.ZERO) ? (kcontext, matchWeight, justifications) -> this.addMediumConstraintMatch(kcontext, constraintWeight.getMediumScore().multiply(matchWeight), justifications) : (constraintWeight.getHardScore().equals(BigDecimal.ZERO) && constraintWeight.getMediumScore().equals(BigDecimal.ZERO) ? (kcontext, matchWeight, justifications) -> this.addSoftConstraintMatch(kcontext, constraintWeight.getSoftScore().multiply(matchWeight), justifications) : (kcontext, matchWeight, justifications) -> this.addMultiConstraintMatch(kcontext, constraintWeight.getHardScore().multiply(matchWeight), constraintWeight.getMediumScore().multiply(matchWeight), constraintWeight.getSoftScore().multiply(matchWeight), justifications))));
        this.matchExecutorByNumberMap.put(rule, matchExecutor);
        this.matchExecutorByScoreMap.put(rule, (kcontext, weightMultiplier) -> this.addMultiConstraintMatch(kcontext, constraintWeight.getHardScore().multiply(weightMultiplier.getHardScore()), constraintWeight.getMediumScore().multiply(weightMultiplier.getMediumScore()), constraintWeight.getSoftScore().multiply(weightMultiplier.getSoftScore())));
    }

    @Override
    public void penalize(RuleContext kcontext) {
        this.impactScore(kcontext, BigDecimal.ONE.negate());
    }

    @Override
    public void penalize(RuleContext kcontext, BigDecimal weightMultiplier) {
        this.impactScore(kcontext, weightMultiplier.negate());
    }

    @Override
    public void penalize(RuleContext kcontext, BigDecimal hardWeightMultiplier, BigDecimal mediumWeightMultiplier, BigDecimal softWeightMultiplier) {
        this.impactScore(kcontext, hardWeightMultiplier.negate(), mediumWeightMultiplier.negate(), softWeightMultiplier.negate());
    }

    @Override
    public void reward(RuleContext kcontext) {
        this.impactScore(kcontext, BigDecimal.ONE);
    }

    @Override
    public void reward(RuleContext kcontext, BigDecimal weightMultiplier) {
        this.impactScore(kcontext, weightMultiplier);
    }

    @Override
    public void reward(RuleContext kcontext, BigDecimal hardWeightMultiplier, BigDecimal mediumWeightMultiplier, BigDecimal softWeightMultiplier) {
        this.impactScore(kcontext, hardWeightMultiplier, mediumWeightMultiplier, softWeightMultiplier);
    }

    @Override
    public void impactScore(RuleContext kcontext, Object ... justifications) {
        this.impactScore(kcontext, BigDecimal.ONE, justifications);
    }

    @Override
    public void impactScore(RuleContext kcontext, int weightMultiplier, Object ... justifications) {
        this.impactScore(kcontext, BigDecimal.valueOf(weightMultiplier), justifications);
    }

    @Override
    public void impactScore(RuleContext kcontext, long weightMultiplier, Object ... justifications) {
        this.impactScore(kcontext, BigDecimal.valueOf(weightMultiplier), justifications);
    }

    @Override
    public void impactScore(RuleContext kcontext, BigDecimal weightMultiplier, Object ... justifications) {
        Rule rule = kcontext.getRule();
        AbstractScoreHolder.BigDecimalMatchExecutor matchExecutor = this.matchExecutorByNumberMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, weightMultiplier, justifications);
    }

    private void impactScore(RuleContext kcontext, BigDecimal hardWeightMultiplier, BigDecimal mediumWeightMultiplier, BigDecimal softWeightMultiplier) {
        Rule rule = kcontext.getRule();
        AbstractScoreHolder.ScoreMatchExecutor<HardMediumSoftBigDecimalScore> matchExecutor = this.matchExecutorByScoreMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, HardMediumSoftBigDecimalScore.of(hardWeightMultiplier, mediumWeightMultiplier, softWeightMultiplier));
    }

    @Override
    public void addHardConstraintMatch(RuleContext kcontext, BigDecimal hardWeight) {
        this.addHardConstraintMatch(kcontext, hardWeight, EMPTY_OBJECT_ARRAY);
    }

    private void addHardConstraintMatch(RuleContext kcontext, BigDecimal hardWeight, Object ... justifications) {
        this.hardScore = this.hardScore.add(hardWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScore = this.hardScore.subtract(hardWeight);
        }, () -> HardMediumSoftBigDecimalScore.ofHard(hardWeight), justifications);
    }

    @Override
    public void addMediumConstraintMatch(RuleContext kcontext, BigDecimal mediumWeight) {
        this.addMediumConstraintMatch(kcontext, mediumWeight, EMPTY_OBJECT_ARRAY);
    }

    private void addMediumConstraintMatch(RuleContext kcontext, BigDecimal mediumWeight, Object ... justifications) {
        this.mediumScore = this.mediumScore.add(mediumWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.mediumScore = this.mediumScore.subtract(mediumWeight);
        }, () -> HardMediumSoftBigDecimalScore.ofMedium(mediumWeight), justifications);
    }

    @Override
    public void addSoftConstraintMatch(RuleContext kcontext, BigDecimal softWeight) {
        this.addSoftConstraintMatch(kcontext, softWeight, EMPTY_OBJECT_ARRAY);
    }

    private void addSoftConstraintMatch(RuleContext kcontext, BigDecimal softWeight, Object ... justifications) {
        this.softScore = this.softScore.add(softWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.softScore = this.softScore.subtract(softWeight);
        }, () -> HardMediumSoftBigDecimalScore.ofSoft(softWeight), justifications);
    }

    @Override
    public void addMultiConstraintMatch(RuleContext kcontext, BigDecimal hardWeight, BigDecimal mediumWeight, BigDecimal softWeight) {
        this.addMultiConstraintMatch(kcontext, hardWeight, mediumWeight, softWeight, EMPTY_OBJECT_ARRAY);
    }

    private void addMultiConstraintMatch(RuleContext kcontext, BigDecimal hardWeight, BigDecimal mediumWeight, BigDecimal softWeight, Object ... justifications) {
        this.hardScore = this.hardScore.add(hardWeight);
        this.mediumScore = this.mediumScore.add(mediumWeight);
        this.softScore = this.softScore.add(softWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScore = this.hardScore.subtract(hardWeight);
            this.mediumScore = this.mediumScore.subtract(mediumWeight);
            this.softScore = this.softScore.subtract(softWeight);
        }, () -> HardMediumSoftBigDecimalScore.of(hardWeight, mediumWeight, softWeight), justifications);
    }

    @Override
    public HardMediumSoftBigDecimalScore extractScore(int initScore) {
        return HardMediumSoftBigDecimalScore.ofUninitialized(initScore, this.hardScore, this.mediumScore, this.softScore);
    }
}

