/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.nearby;

import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import org.optaplanner.core.config.heuristic.selector.common.nearby.NearbySelectionDistributionType;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.BetaDistributionNearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.BlockDistributionNearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.LinearDistributionNearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.ParabolicDistributionNearbyRandom;

public class NearbyRandomFactory {
    private final NearbySelectionConfig nearbySelectionConfig;

    public static NearbyRandomFactory create(NearbySelectionConfig nearbySelectionConfig) {
        return new NearbyRandomFactory(nearbySelectionConfig);
    }

    public NearbyRandomFactory(NearbySelectionConfig nearbySelectionConfig) {
        this.nearbySelectionConfig = nearbySelectionConfig;
    }

    public NearbyRandom buildNearbyRandom(boolean randomSelection) {
        boolean betaDistributionEnabled;
        boolean blockDistributionEnabled = this.nearbySelectionConfig.getNearbySelectionDistributionType() == NearbySelectionDistributionType.BLOCK_DISTRIBUTION || this.nearbySelectionConfig.getBlockDistributionSizeMinimum() != null || this.nearbySelectionConfig.getBlockDistributionSizeMaximum() != null || this.nearbySelectionConfig.getBlockDistributionSizeRatio() != null || this.nearbySelectionConfig.getBlockDistributionUniformDistributionProbability() != null;
        boolean linearDistributionEnabled = this.nearbySelectionConfig.getNearbySelectionDistributionType() == NearbySelectionDistributionType.LINEAR_DISTRIBUTION || this.nearbySelectionConfig.getLinearDistributionSizeMaximum() != null;
        boolean parabolicDistributionEnabled = this.nearbySelectionConfig.getNearbySelectionDistributionType() == NearbySelectionDistributionType.PARABOLIC_DISTRIBUTION || this.nearbySelectionConfig.getParabolicDistributionSizeMaximum() != null;
        boolean bl = betaDistributionEnabled = this.nearbySelectionConfig.getNearbySelectionDistributionType() == NearbySelectionDistributionType.BETA_DISTRIBUTION || this.nearbySelectionConfig.getBetaDistributionAlpha() != null || this.nearbySelectionConfig.getBetaDistributionBeta() != null;
        if (!randomSelection) {
            if (blockDistributionEnabled || linearDistributionEnabled || parabolicDistributionEnabled || betaDistributionEnabled) {
                throw new IllegalArgumentException("The nearbySelectorConfig (" + this.nearbySelectionConfig + ") with randomSelection (" + randomSelection + ") has distribution parameters.");
            }
            return null;
        }
        if (blockDistributionEnabled && linearDistributionEnabled) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this.nearbySelectionConfig + ") has both blockDistribution and linearDistribution parameters.");
        }
        if (blockDistributionEnabled && parabolicDistributionEnabled) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this.nearbySelectionConfig + ") has both blockDistribution and parabolicDistribution parameters.");
        }
        if (blockDistributionEnabled && betaDistributionEnabled) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this.nearbySelectionConfig + ") has both blockDistribution and betaDistribution parameters.");
        }
        if (linearDistributionEnabled && parabolicDistributionEnabled) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this.nearbySelectionConfig + ") has both linearDistribution and parabolicDistribution parameters.");
        }
        if (linearDistributionEnabled && betaDistributionEnabled) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this.nearbySelectionConfig + ") has both linearDistribution and betaDistribution parameters.");
        }
        if (parabolicDistributionEnabled && betaDistributionEnabled) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this.nearbySelectionConfig + ") has both parabolicDistribution and betaDistribution parameters.");
        }
        if (blockDistributionEnabled) {
            int sizeMinimum = (Integer)ObjectUtils.defaultIfNull((Object)this.nearbySelectionConfig.getBlockDistributionSizeMinimum(), (Object)1);
            int sizeMaximum = (Integer)ObjectUtils.defaultIfNull((Object)this.nearbySelectionConfig.getBlockDistributionSizeMaximum(), (Object)Integer.MAX_VALUE);
            double sizeRatio = (Double)ObjectUtils.defaultIfNull((Object)this.nearbySelectionConfig.getBlockDistributionSizeRatio(), (Object)1.0);
            double uniformDistributionProbability = (Double)ObjectUtils.defaultIfNull((Object)this.nearbySelectionConfig.getBlockDistributionUniformDistributionProbability(), (Object)0.0);
            return new BlockDistributionNearbyRandom(sizeMinimum, sizeMaximum, sizeRatio, uniformDistributionProbability);
        }
        if (linearDistributionEnabled) {
            int sizeMaximum = (Integer)ObjectUtils.defaultIfNull((Object)this.nearbySelectionConfig.getLinearDistributionSizeMaximum(), (Object)Integer.MAX_VALUE);
            return new LinearDistributionNearbyRandom(sizeMaximum);
        }
        if (parabolicDistributionEnabled) {
            int sizeMaximum = (Integer)ObjectUtils.defaultIfNull((Object)this.nearbySelectionConfig.getParabolicDistributionSizeMaximum(), (Object)Integer.MAX_VALUE);
            return new ParabolicDistributionNearbyRandom(sizeMaximum);
        }
        if (betaDistributionEnabled) {
            double alpha = (Double)ObjectUtils.defaultIfNull((Object)this.nearbySelectionConfig.getBetaDistributionAlpha(), (Object)1.0);
            double beta = (Double)ObjectUtils.defaultIfNull((Object)this.nearbySelectionConfig.getBetaDistributionBeta(), (Object)5.0);
            return new BetaDistributionNearbyRandom(alpha, beta);
        }
        return new LinearDistributionNearbyRandom(Integer.MAX_VALUE);
    }
}

