/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.quad;

import java.util.ArrayList;
import java.util.function.Function;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.stream.quad.QuadJoiner;
import org.optaplanner.core.impl.score.stream.common.AbstractJoiner;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.quad.CompositeQuadJoiner;
import org.optaplanner.core.impl.score.stream.quad.NoneQuadJoiner;
import org.optaplanner.core.impl.score.stream.quad.SingleQuadJoiner;

public abstract class AbstractQuadJoiner<A, B, C, D>
extends AbstractJoiner
implements QuadJoiner<A, B, C, D> {
    private final QuadPredicate<A, B, C, D> filter;

    protected AbstractQuadJoiner() {
        this.filter = null;
    }

    protected AbstractQuadJoiner(QuadPredicate<A, B, C, D> filter) {
        this.filter = filter;
    }

    @SafeVarargs
    public static <A, B, C, D> AbstractQuadJoiner<A, B, C, D> merge(QuadJoiner<A, B, C, D> ... joiners) {
        ArrayList joinerList = new ArrayList();
        for (QuadJoiner<A, B, C, D> joiner : joiners) {
            if (joiner instanceof NoneQuadJoiner) continue;
            if (joiner instanceof SingleQuadJoiner) {
                joinerList.add((SingleQuadJoiner)joiner);
                continue;
            }
            if (joiner instanceof CompositeQuadJoiner) {
                joinerList.addAll(((CompositeQuadJoiner)joiner).getJoinerList());
                continue;
            }
            throw new IllegalArgumentException("The joiner class (" + joiner.getClass() + ") is not supported.");
        }
        if (joinerList.isEmpty()) {
            return new NoneQuadJoiner();
        }
        if (joinerList.size() == 1) {
            return (AbstractQuadJoiner)joinerList.get(0);
        }
        return new CompositeQuadJoiner(joinerList);
    }

    public boolean matches(A a, B b, C c, D d) {
        JoinerType[] joinerTypes = this.getJoinerTypes();
        for (int i = 0; i < joinerTypes.length; ++i) {
            Object rightMapping;
            JoinerType joinerType = joinerTypes[i];
            Object leftMapping = this.getLeftMapping(i).apply(a, b, c);
            if (joinerType.matches(leftMapping, rightMapping = this.getRightMapping(i).apply(d))) continue;
            return false;
        }
        return true;
    }

    public abstract TriFunction<A, B, C, Object> getLeftMapping(int var1);

    public abstract TriFunction<A, B, C, Object[]> getLeftCombinedMapping();

    public abstract Function<D, Object> getRightMapping(int var1);

    public abstract Function<D, Object[]> getRightCombinedMapping();

    public QuadPredicate<A, B, C, D> getFilter() {
        return this.filter;
    }
}

