/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.optaplanner;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.optaplanner.OptaPlannerConfiguration;
import org.apache.camel.component.optaplanner.OptaPlannerEndpoint;
import org.apache.camel.component.optaplanner.OptaplannerSolutionEvent;
import org.apache.camel.component.optaplanner.OptaplannerSolutionEventListener;
import org.apache.camel.support.DefaultConsumer;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptaPlannerConsumer
extends DefaultConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(OptaPlannerConsumer.class);
    private final OptaPlannerEndpoint endpoint;
    private final OptaPlannerConfiguration configuration;
    private SolverEventListener<Object> solverListener;
    private OptaplannerSolutionEventListener solverJobListener;

    public OptaPlannerConsumer(OptaPlannerEndpoint endpoint, Processor processor, OptaPlannerConfiguration configuration) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.configuration = configuration;
        if (!configuration.isUseSolverManager()) {
            this.solverListener = new SolverEventListener<Object>(){

                public void bestSolutionChanged(BestSolutionChangedEvent<Object> event) {
                    if (event.isEveryProblemFactChangeProcessed() && event.getNewBestScore().isSolutionInitialized()) {
                        OptaPlannerConsumer.this.processEvent(event);
                    }
                }
            };
        } else {
            this.solverJobListener = new OptaplannerSolutionEventListener(){

                @Override
                public void bestSolutionChanged(OptaplannerSolutionEvent event) {
                    OptaPlannerConsumer.this.processSolverJobEvent(event);
                }
            };
        }
    }

    public void processEvent(BestSolutionChangedEvent<Object> event) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getMessage().setHeader("CamelOptaPlannerBestSolution", event.getNewBestSolution());
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            LOG.error("Error processing event ", (Throwable)e);
        }
    }

    public void processSolverJobEvent(OptaplannerSolutionEvent event) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getMessage().setHeader("CamelOptaPlannerBestSolution", event.getBestSolution());
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            LOG.error("Error processing event ", (Throwable)e);
        }
    }

    protected void doStart() throws Exception {
        if (!this.configuration.isUseSolverManager()) {
            Solver<Object> solver = this.endpoint.getOrCreateSolver(this.configuration.getSolverId());
            solver.addEventListener(this.solverListener);
        } else {
            Long problemId = this.configuration.getProblemId();
            this.endpoint.addSolutionEventListener(problemId, this.solverJobListener);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (!this.configuration.isUseSolverManager()) {
            Solver<Object> solver = this.endpoint.getOrCreateSolver(this.configuration.getSolverId());
            solver.removeEventListener(this.solverListener);
        } else {
            Long problemId = this.configuration.getProblemId();
            this.endpoint.removeSolutionEventListener(problemId, this.solverJobListener);
        }
        super.doStop();
    }
}

