/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity.nearby;

import java.util.Iterator;
import java.util.ListIterator;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrix;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.entity.AbstractEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;

public class NearEntityNearbyEntitySelector
extends AbstractEntitySelector {
    protected final EntitySelector childEntitySelector;
    protected final EntitySelector originEntitySelector;
    protected final NearbyDistanceMeter nearbyDistanceMeter;
    protected final NearbyRandom nearbyRandom;
    protected final boolean randomSelection;
    protected final boolean discardNearbyIndexZero = true;
    protected NearbyDistanceMatrix nearbyDistanceMatrix = null;

    public NearEntityNearbyEntitySelector(EntitySelector childEntitySelector, EntitySelector originEntitySelector, NearbyDistanceMeter nearbyDistanceMeter, NearbyRandom nearbyRandom, boolean randomSelection) {
        this.childEntitySelector = childEntitySelector;
        this.originEntitySelector = originEntitySelector;
        this.nearbyDistanceMeter = nearbyDistanceMeter;
        this.nearbyRandom = nearbyRandom;
        this.randomSelection = randomSelection;
        if (randomSelection && nearbyRandom == null) {
            throw new IllegalArgumentException("The entitySelector (" + this + ") with randomSelection (" + randomSelection + ") has no nearbyRandom (" + nearbyRandom + ").");
        }
        if (!childEntitySelector.getEntityDescriptor().getEntityClass().isAssignableFrom(originEntitySelector.getEntityDescriptor().getEntityClass())) {
            throw new IllegalArgumentException("The entitySelector (" + this + ") has an entityClass (" + childEntitySelector.getEntityDescriptor().getEntityClass() + ") which is not a superclass of the originEntitySelector's entityClass (" + originEntitySelector.getEntityDescriptor().getEntityClass() + ").");
        }
        this.phaseLifecycleSupport.addEventListener(childEntitySelector);
        this.phaseLifecycleSupport.addEventListener(originEntitySelector);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        long originSize = this.originEntitySelector.getSize();
        if (originSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The originEntitySelector (" + this.originEntitySelector + ") has an entitySize (" + originSize + ") which is higher than Integer.MAX_VALUE.");
        }
        long childSize = this.childEntitySelector.getSize();
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The childEntitySelector (" + this.childEntitySelector + ") has an entitySize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
        }
        int destinationSize = (int)childSize;
        if (this.randomSelection) {
            int overallSizeMaximum = this.nearbyRandom.getOverallSizeMaximum();
            if (overallSizeMaximum != Integer.MAX_VALUE) {
                ++overallSizeMaximum;
            }
            if (destinationSize > overallSizeMaximum) {
                destinationSize = overallSizeMaximum;
            }
        }
        this.nearbyDistanceMatrix = new NearbyDistanceMatrix(this.nearbyDistanceMeter, (int)originSize);
        Iterator<Object> originIt = this.originEntitySelector.endingIterator();
        while (originIt.hasNext()) {
            Object origin = originIt.next();
            this.nearbyDistanceMatrix.addAllDestinations(origin, this.childEntitySelector.endingIterator(), destinationSize);
        }
    }

    @Override
    public void phaseEnded(AbstractPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.nearbyDistanceMatrix = null;
    }

    @Override
    public EntityDescriptor getEntityDescriptor() {
        return this.childEntitySelector.getEntityDescriptor();
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        return this.childEntitySelector.getSize() - 1L;
    }

    @Override
    public Iterator<Object> iterator() {
        if (!this.randomSelection) {
            return new OriginalNearbyEntityIterator(this.originEntitySelector.iterator(), this.childEntitySelector.getSize());
        }
        return new RandomNearbyEntityIterator(this.originEntitySelector.iterator(), this.childEntitySelector.getSize());
    }

    @Override
    public ListIterator<Object> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Object> endingIterator() {
        return this.childEntitySelector.endingIterator();
    }

    private class RandomNearbyEntityIterator
    extends SelectionIterator<Object> {
        private final Iterator<Object> originEntityIterator;
        private final int nearbySize;

        public RandomNearbyEntityIterator(Iterator<Object> originEntityIterator, long childSize) {
            this.originEntityIterator = originEntityIterator;
            if (childSize > Integer.MAX_VALUE) {
                throw new IllegalStateException("The valueSelector (" + this + ") has an entitySize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
            }
            this.nearbySize = (int)childSize - 1;
        }

        @Override
        public boolean hasNext() {
            return this.originEntityIterator.hasNext() && this.nearbySize > 0;
        }

        @Override
        public Object next() {
            Object origin = this.originEntityIterator.next();
            int nearbyIndex = NearEntityNearbyEntitySelector.this.nearbyRandom.nextInt(NearEntityNearbyEntitySelector.this.workingRandom, this.nearbySize);
            return NearEntityNearbyEntitySelector.this.nearbyDistanceMatrix.getDestination(origin, ++nearbyIndex);
        }
    }

    private class OriginalNearbyEntityIterator
    extends SelectionIterator<Object> {
        private final Iterator<Object> originEntityIterator;
        private final long childSize;
        private int nextNearbyIndex;

        public OriginalNearbyEntityIterator(Iterator<Object> originEntityIterator, long childSize) {
            this.originEntityIterator = originEntityIterator;
            this.childSize = childSize;
            this.nextNearbyIndex = 1;
        }

        @Override
        public boolean hasNext() {
            return this.originEntityIterator.hasNext() && (long)this.nextNearbyIndex < this.childSize;
        }

        @Override
        public Object next() {
            Object origin = this.originEntityIterator.next();
            Object next = NearEntityNearbyEntitySelector.this.nearbyDistanceMatrix.getDestination(origin, this.nextNearbyIndex);
            ++this.nextNearbyIndex;
            return next;
        }
    }
}

