/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.parser.printer;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.printer.PrettyPrintVisitor;
import com.github.javaparser.printer.PrettyPrinterConfiguration;
import com.github.javaparser.utils.Utils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.drools.mvel.parser.ast.expr.BigDecimalLiteralExpr;
import org.drools.mvel.parser.ast.expr.BigIntegerLiteralExpr;
import org.drools.mvel.parser.ast.expr.DrlNameExpr;
import org.drools.mvel.parser.ast.expr.DrlxExpression;
import org.drools.mvel.parser.ast.expr.HalfBinaryExpr;
import org.drools.mvel.parser.ast.expr.HalfPointFreeExpr;
import org.drools.mvel.parser.ast.expr.InlineCastExpr;
import org.drools.mvel.parser.ast.expr.MapCreationLiteralExpression;
import org.drools.mvel.parser.ast.expr.MapCreationLiteralExpressionKeyValuePair;
import org.drools.mvel.parser.ast.expr.ModifyStatement;
import org.drools.mvel.parser.ast.expr.NullSafeFieldAccessExpr;
import org.drools.mvel.parser.ast.expr.NullSafeMethodCallExpr;
import org.drools.mvel.parser.ast.expr.OOPathChunk;
import org.drools.mvel.parser.ast.expr.OOPathExpr;
import org.drools.mvel.parser.ast.expr.PointFreeExpr;
import org.drools.mvel.parser.ast.expr.RuleBody;
import org.drools.mvel.parser.ast.expr.RuleDeclaration;
import org.drools.mvel.parser.ast.expr.TemporalChunkExpr;
import org.drools.mvel.parser.ast.expr.TemporalLiteralChunkExpr;
import org.drools.mvel.parser.ast.expr.TemporalLiteralExpr;
import org.drools.mvel.parser.ast.expr.TemporalLiteralInfiniteChunkExpr;
import org.drools.mvel.parser.ast.expr.WithStatement;
import org.drools.mvel.parser.ast.visitor.DrlVoidVisitor;
import org.drools.mvel.parser.printer.PrintUtil;

public class ConstraintPrintVisitor
extends PrettyPrintVisitor
implements DrlVoidVisitor<Void> {
    public ConstraintPrintVisitor(PrettyPrinterConfiguration prettyPrinterConfiguration) {
        super(prettyPrinterConfiguration);
    }

    @Override
    public void visit(RuleDeclaration n, Void arg) {
        this.printComment(n.getComment(), arg);
        for (AnnotationExpr ae : n.getAnnotations()) {
            ae.accept((VoidVisitor)this, (Object)arg);
            this.printer.print(" ");
        }
        this.printer.print("rule ");
        n.getName().accept((VoidVisitor)this, (Object)arg);
        this.printer.println(" {");
        n.getRuleBody().accept(this, arg);
        this.printer.println("}");
    }

    @Override
    public void visit(RuleBody ruleBody, Void arg) {
    }

    @Override
    public void visit(InlineCastExpr inlineCastExpr, Void arg) {
        this.printComment(inlineCastExpr.getComment(), arg);
        inlineCastExpr.getExpression().accept((VoidVisitor)this, (Object)arg);
        this.printer.print("#");
        inlineCastExpr.getType().accept((VoidVisitor)this, (Object)arg);
    }

    @Override
    public void visit(NullSafeFieldAccessExpr nullSafeFieldAccessExpr, Void arg) {
        this.printComment(nullSafeFieldAccessExpr.getComment(), arg);
        nullSafeFieldAccessExpr.getScope().accept((VoidVisitor)this, (Object)arg);
        this.printer.print("!.");
        nullSafeFieldAccessExpr.getName().accept((VoidVisitor)this, (Object)arg);
    }

    @Override
    public void visit(NullSafeMethodCallExpr nullSafeMethodCallExpr, Void arg) {
        this.printComment(nullSafeMethodCallExpr.getComment(), arg);
        Optional<Expression> scopeExpression = nullSafeMethodCallExpr.getScope();
        if (scopeExpression.isPresent()) {
            scopeExpression.get().accept((VoidVisitor)this, (Object)arg);
            this.printer.print("!.");
        }
        this.printTypeArgs(nullSafeMethodCallExpr, arg);
        nullSafeMethodCallExpr.getName().accept((VoidVisitor)this, (Object)arg);
        this.printArguments(nullSafeMethodCallExpr.getArguments(), arg);
    }

    @Override
    public void visit(PointFreeExpr pointFreeExpr, Void arg) {
        this.printComment(pointFreeExpr.getComment(), arg);
        pointFreeExpr.getLeft().accept((VoidVisitor)this, (Object)arg);
        if (pointFreeExpr.isNegated()) {
            this.printer.print(" not");
        }
        this.printer.print(" ");
        pointFreeExpr.getOperator().accept((VoidVisitor)this, (Object)arg);
        if (pointFreeExpr.getArg1() != null) {
            this.printer.print("[");
            pointFreeExpr.getArg1().accept((VoidVisitor)this, (Object)arg);
            if (pointFreeExpr.getArg2() != null) {
                this.printer.print(",");
                pointFreeExpr.getArg2().accept((VoidVisitor)this, (Object)arg);
            }
            if (pointFreeExpr.getArg3() != null) {
                this.printer.print(",");
                pointFreeExpr.getArg3().accept((VoidVisitor)this, (Object)arg);
            }
            if (pointFreeExpr.getArg4() != null) {
                this.printer.print(",");
                pointFreeExpr.getArg4().accept((VoidVisitor)this, (Object)arg);
            }
            this.printer.print("]");
        }
        this.printer.print(" ");
        NodeList<Expression> rightExprs = pointFreeExpr.getRight();
        if (rightExprs.size() == 1) {
            ((Expression)rightExprs.get(0)).accept((VoidVisitor)this, (Object)arg);
        } else {
            this.printer.print("(");
            if (rightExprs.isNonEmpty()) {
                ((Expression)rightExprs.get(0)).accept((VoidVisitor)this, (Object)arg);
            }
            for (int i = 1; i < rightExprs.size(); ++i) {
                this.printer.print(", ");
                ((Expression)rightExprs.get(i)).accept((VoidVisitor)this, (Object)arg);
            }
            this.printer.print(")");
        }
    }

    @Override
    public void visit(TemporalLiteralExpr temporalLiteralExpr, Void arg) {
        this.printComment(temporalLiteralExpr.getComment(), arg);
        NodeList<TemporalChunkExpr> chunks = temporalLiteralExpr.getChunks();
        for (TemporalChunkExpr c : chunks) {
            c.accept(this, arg);
        }
    }

    @Override
    public void visit(TemporalLiteralChunkExpr temporalLiteralExpr, Void arg) {
        this.printComment(temporalLiteralExpr.getComment(), arg);
        this.printer.print("" + temporalLiteralExpr.getValue());
        switch (temporalLiteralExpr.getTimeUnit()) {
            case MILLISECONDS: {
                this.printer.print("ms");
                break;
            }
            case SECONDS: {
                this.printer.print("s");
                break;
            }
            case MINUTES: {
                this.printer.print("m");
                break;
            }
            case HOURS: {
                this.printer.print("h");
                break;
            }
            case DAYS: {
                this.printer.print("d");
            }
        }
    }

    @Override
    public void visit(TemporalLiteralInfiniteChunkExpr temporalLiteralInfiniteChunkExpr, Void arg) {
        this.printer.print("*");
    }

    @Override
    public void visit(DrlxExpression expr, Void arg) {
        if (expr.getBind() != null) {
            expr.getBind().accept((VoidVisitor)this, (Object)arg);
            this.printer.print(" : ");
        }
        expr.getExpr().accept((VoidVisitor)this, (Object)arg);
    }

    @Override
    public void visit(OOPathExpr oopathExpr, Void arg) {
        this.printComment(oopathExpr.getComment(), arg);
        this.printer.print("/");
        NodeList<OOPathChunk> chunks = oopathExpr.getChunks();
        for (int i = 0; i < chunks.size(); ++i) {
            OOPathChunk chunk = (OOPathChunk)chunks.get(i);
            chunk.accept(this, arg);
            this.printer.print(chunk.getField().toString());
            List<DrlxExpression> condition = chunk.getConditions();
            Iterator<DrlxExpression> iterator = condition.iterator();
            if (!condition.isEmpty()) {
                this.printer.print("[");
                DrlxExpression first = iterator.next();
                first.accept(this, arg);
                while (iterator.hasNext()) {
                    this.printer.print(",");
                    iterator.next().accept(this, arg);
                }
                this.printer.print("]");
            }
            if (i == chunks.size() - 1) continue;
            this.printer.print("/");
        }
    }

    @Override
    public void visit(HalfBinaryExpr n, Void arg) {
        this.printComment(n.getComment(), arg);
        this.printer.print(n.getOperator().asString());
        this.printer.print(" ");
        n.getRight().accept((VoidVisitor)this, (Object)arg);
    }

    @Override
    public void visit(HalfPointFreeExpr pointFreeExpr, Void arg) {
        this.printComment(pointFreeExpr.getComment(), arg);
        if (pointFreeExpr.isNegated()) {
            this.printer.print("not ");
        }
        pointFreeExpr.getOperator().accept((VoidVisitor)this, (Object)arg);
        if (pointFreeExpr.getArg1() != null) {
            this.printer.print("[");
            pointFreeExpr.getArg1().accept((VoidVisitor)this, (Object)arg);
            if (pointFreeExpr.getArg2() != null) {
                this.printer.print(",");
                pointFreeExpr.getArg2().accept((VoidVisitor)this, (Object)arg);
            }
            if (pointFreeExpr.getArg3() != null) {
                this.printer.print(",");
                pointFreeExpr.getArg3().accept((VoidVisitor)this, (Object)arg);
            }
            if (pointFreeExpr.getArg4() != null) {
                this.printer.print(",");
                pointFreeExpr.getArg4().accept((VoidVisitor)this, (Object)arg);
            }
            this.printer.print("]");
        }
        this.printer.print(" ");
        NodeList<Expression> rightExprs = pointFreeExpr.getRight();
        if (rightExprs.size() == 1) {
            ((Expression)rightExprs.get(0)).accept((VoidVisitor)this, (Object)arg);
        } else {
            this.printer.print("(");
            ((Expression)rightExprs.get(0)).accept((VoidVisitor)this, (Object)arg);
            for (int i = 1; i < rightExprs.size(); ++i) {
                this.printer.print(", ");
                ((Expression)rightExprs.get(i)).accept((VoidVisitor)this, (Object)arg);
            }
            this.printer.print(")");
        }
    }

    @Override
    public void visit(BigDecimalLiteralExpr bigDecimalLiteralExpr, Void arg) {
        this.printer.print(bigDecimalLiteralExpr.asBigDecimal().toString());
        this.printer.print("B");
    }

    @Override
    public void visit(BigIntegerLiteralExpr bigIntegerLiteralExpr, Void arg) {
        this.printer.print(bigIntegerLiteralExpr.asBigInteger().toString());
        this.printer.print("I");
    }

    @Override
    public void visit(ModifyStatement modifyExpression, Void arg) {
        this.printer.print("modify (");
        modifyExpression.getModifyObject().accept((VoidVisitor)this, (Object)arg);
        this.printer.print(") { ");
        String expressionWithComma = modifyExpression.getExpressions().stream().filter(Objects::nonNull).filter(Statement::isExpressionStmt).map(n -> PrintUtil.printConstraint((Node)n.asExpressionStmt().getExpression())).collect(Collectors.joining(", "));
        this.printer.print(expressionWithComma);
        this.printer.print(" }");
        this.printer.print(";");
    }

    @Override
    public void visit(WithStatement withExpression, Void arg) {
        this.printer.print("with (");
        withExpression.getWithObject().accept((VoidVisitor)this, (Object)arg);
        this.printer.print(") { ");
        String expressionWithComma = withExpression.getExpressions().stream().filter(Objects::nonNull).filter(Statement::isExpressionStmt).map(n -> PrintUtil.printConstraint((Node)n.asExpressionStmt().getExpression())).collect(Collectors.joining(", "));
        this.printer.print(expressionWithComma);
        this.printer.print(" }");
        this.printer.print(";");
    }

    public void printComment(Optional<Comment> comment, Void arg) {
        comment.ifPresent(c -> c.accept((VoidVisitor)this, (Object)arg));
    }

    public void printTypeArgs(NodeWithTypeArguments<?> nodeWithTypeArguments, Void arg) {
        NodeList typeArguments = nodeWithTypeArguments.getTypeArguments().orElse(null);
        if (!Utils.isNullOrEmpty((Collection)typeArguments)) {
            this.printer.print("<");
            Iterator i = typeArguments.iterator();
            while (i.hasNext()) {
                Type t = (Type)i.next();
                t.accept((VoidVisitor)this, (Object)arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(">");
        }
    }

    public void printArguments(NodeList<Expression> args, Void arg) {
        this.printer.print("(");
        if (!Utils.isNullOrEmpty(args)) {
            boolean columnAlignParameters;
            boolean bl = columnAlignParameters = args.size() > 1 && this.configuration.isColumnAlignParameters();
            if (columnAlignParameters) {
                this.printer.indentWithAlignTo(this.printer.getCursor().column);
            }
            Iterator i = args.iterator();
            while (i.hasNext()) {
                Expression e = (Expression)i.next();
                e.accept((VoidVisitor)this, (Object)arg);
                if (!i.hasNext()) continue;
                this.printer.print(",");
                if (columnAlignParameters) {
                    this.printer.println();
                    continue;
                }
                this.printer.print(" ");
            }
            if (columnAlignParameters) {
                this.printer.unindent();
            }
        }
        this.printer.print(")");
    }

    @Override
    public void visit(DrlNameExpr n, Void arg) {
        this.printComment(n.getComment(), arg);
        IntStream.range(0, n.getBackReferencesCount()).forEach(s -> this.printer.print("../"));
        n.getName().accept((VoidVisitor)this, (Object)arg);
    }

    @Override
    public void visit(MapCreationLiteralExpression n, Void arg) {
        this.printer.print("[");
        Iterator expressions = n.getExpressions().iterator();
        while (expressions.hasNext()) {
            ((Expression)expressions.next()).accept((VoidVisitor)this, (Object)arg);
            if (!expressions.hasNext()) continue;
            this.printer.print(", ");
        }
        this.printer.print("]");
    }

    @Override
    public void visit(MapCreationLiteralExpressionKeyValuePair n, Void arg) {
        n.getKey().accept((VoidVisitor)this, (Object)arg);
        this.printer.print(" : ");
        n.getValue().accept((VoidVisitor)this, (Object)arg);
    }
}

