/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.AbstractTermination;
import org.optaplanner.core.impl.solver.thread.ChildThreadType;

public class ScoreCalculationCountTermination
extends AbstractTermination {
    private final long scoreCalculationCountLimit;

    public ScoreCalculationCountTermination(long scoreCalculationCountLimit) {
        this.scoreCalculationCountLimit = scoreCalculationCountLimit;
        if (scoreCalculationCountLimit < 0L) {
            throw new IllegalArgumentException("The scoreCalculationCountLimit (" + scoreCalculationCountLimit + ") cannot be negative.");
        }
    }

    @Override
    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        return this.isTerminated(solverScope.getScoreDirector());
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope phaseScope) {
        return this.isTerminated(phaseScope.getScoreDirector());
    }

    protected boolean isTerminated(InnerScoreDirector scoreDirector) {
        long scoreCalculationCount = scoreDirector.getCalculationCount();
        return scoreCalculationCount >= this.scoreCalculationCountLimit;
    }

    @Override
    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        return this.calculateTimeGradient(solverScope.getScoreDirector());
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope phaseScope) {
        return this.calculateTimeGradient(phaseScope.getScoreDirector());
    }

    protected double calculateTimeGradient(InnerScoreDirector scoreDirector) {
        long scoreCalculationCount = scoreDirector.getCalculationCount();
        double timeGradient = (double)scoreCalculationCount / (double)this.scoreCalculationCountLimit;
        return Math.min(timeGradient, 1.0);
    }

    @Override
    public ScoreCalculationCountTermination createChildThreadTermination(DefaultSolverScope solverScope, ChildThreadType childThreadType) {
        if (childThreadType == ChildThreadType.PART_THREAD) {
            return new ScoreCalculationCountTermination(this.scoreCalculationCountLimit);
        }
        throw new IllegalStateException("The childThreadType (" + (Object)((Object)childThreadType) + ") is not implemented.");
    }

    public String toString() {
        return "ScoreCalculationCount(" + this.scoreCalculationCountLimit + ")";
    }
}

