/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.shade.org.eclipse.jdt.internal.compiler.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.drools.compiler.shade.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.drools.compiler.shade.org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.drools.compiler.shade.org.eclipse.jdt.internal.compiler.env.IModule;
import org.drools.compiler.shade.org.eclipse.jdt.internal.compiler.util.JrtFileSystem;

public class JRTUtil {
    public static final String JAVA_BASE = "java.base";
    public static final char[] JAVA_BASE_CHAR = "java.base".toCharArray();
    static final String MODULES_SUBDIR = "/modules";
    static final String[] DEFAULT_MODULE = new String[]{"java.base"};
    static final String[] NO_MODULE = new String[0];
    static final String MULTIPLE = "MU";
    static final String DEFAULT_PACKAGE = "";
    static String MODULE_TO_LOAD = null;
    public static final String JRT_FS_JAR = "jrt-fs.jar";
    static URI JRT_URI = URI.create("jrt:/");
    public static int NOTIFY_FILES = 1;
    public static int NOTIFY_PACKAGES = 2;
    public static int NOTIFY_MODULES = 4;
    public static int NOTIFY_ALL = NOTIFY_FILES | NOTIFY_PACKAGES | NOTIFY_MODULES;
    private static Map<String, JrtFileSystem> images = null;
    private static final Object lock = new Object();

    public static JrtFileSystem getJrtSystem(File image) {
        return JRTUtil.getJrtSystem(image, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JrtFileSystem getJrtSystem(File image, String release) {
        Map<String, JrtFileSystem> i = images;
        if (images == null) {
            Object object = lock;
            synchronized (object) {
                i = images;
                if (i == null) {
                    images = i = new HashMap<String, JrtFileSystem>();
                }
            }
        }
        JrtFileSystem system = null;
        String key = image.toString();
        if (release != null) {
            key = String.valueOf(key) + "|" + release;
        }
        Map<String, JrtFileSystem> map = i;
        synchronized (map) {
            system = images.get(key);
            if (system == null) {
                try {
                    system = JrtFileSystem.getNewJrtFileSystem(image, release);
                    images.put(key, system);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return system;
    }

    public static void reset() {
        images = null;
        MODULE_TO_LOAD = System.getProperty("modules.to.load");
    }

    public static void walkModuleImage(File image, JrtFileVisitor<Path> visitor, int notify) throws IOException {
        JRTUtil.getJrtSystem(image, null).walkModuleImage(visitor, notify);
    }

    public static void walkModuleImage(File image, String release, JrtFileVisitor<Path> visitor, int notify) throws IOException {
        JRTUtil.getJrtSystem(image, release).walkModuleImage(visitor, notify);
    }

    public static InputStream getContentFromJrt(File jrt, String fileName, String module) throws IOException {
        return JRTUtil.getJrtSystem(jrt).getContentFromJrt(fileName, module);
    }

    public static byte[] getClassfileContent(File jrt, String fileName, String module) throws IOException, ClassFormatException {
        return JRTUtil.getJrtSystem(jrt).getClassfileContent(fileName, module);
    }

    public static ClassFileReader getClassfile(File jrt, String fileName, IModule module) throws IOException, ClassFormatException {
        return JRTUtil.getJrtSystem(jrt).getClassfile(fileName, module);
    }

    public static ClassFileReader getClassfile(File jrt, String fileName, String module, Predicate<String> moduleNameFilter) throws IOException, ClassFormatException {
        return JRTUtil.getJrtSystem(jrt).getClassfile(fileName, module, moduleNameFilter);
    }

    public static List<String> getModulesDeclaringPackage(File jrt, String qName, String moduleName) {
        return JRTUtil.getJrtSystem(jrt).getModulesDeclaringPackage(qName, moduleName);
    }

    public static boolean hasCompilationUnit(File jrt, String qualifiedPackageName, String moduleName) {
        return JRTUtil.getJrtSystem(jrt).hasClassFile(qualifiedPackageName, moduleName);
    }

    public static String sanitizedFileName(Path path) {
        String p = path.getFileName().toString();
        if (p.length() > 1 && p.charAt(p.length() - 1) == '/') {
            return p.substring(0, p.length() - 1);
        }
        return p;
    }

    public static byte[] safeReadBytes(Path path) throws IOException {
        try {
            return Files.readAllBytes(path);
        }
        catch (ClosedByInterruptException | NoSuchFileException iOException) {
            return null;
        }
    }

    static abstract class AbstractFileVisitor<T>
    implements FileVisitor<T> {
        AbstractFileVisitor() {
        }

        @Override
        public FileVisitResult preVisitDirectory(T dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(T file, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(T file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(T dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }

    public static interface JrtFileVisitor<T> {
        public FileVisitResult visitPackage(T var1, T var2, BasicFileAttributes var3) throws IOException;

        public FileVisitResult visitFile(T var1, T var2, BasicFileAttributes var3) throws IOException;

        public FileVisitResult visitModule(T var1, String var2) throws IOException;
    }
}

