/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.quad;

import org.optaplanner.core.api.score.stream.quad.QuadJoiner;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsAbstractQuadConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsQuadCondition;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsAbstractTriConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsAbstractUniConstraintStream;
import org.optaplanner.core.impl.score.stream.quad.AbstractQuadJoiner;

public final class DroolsJoinQuadConstraintStream<Solution_, A, B, C, D>
extends DroolsAbstractQuadConstraintStream<Solution_, A, B, C, D> {
    private final DroolsAbstractTriConstraintStream<Solution_, A, B, C> leftParentStream;
    private final DroolsAbstractUniConstraintStream<Solution_, D> rightParentStream;
    private final DroolsQuadCondition<A, B, C, D, ?> condition;

    public DroolsJoinQuadConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractTriConstraintStream<Solution_, A, B, C> parent, DroolsAbstractUniConstraintStream<Solution_, D> otherStream, QuadJoiner<A, B, C, D> joiner) {
        super(constraintFactory, null);
        this.leftParentStream = parent;
        this.rightParentStream = otherStream;
        this.condition = parent.getCondition().andJoin(otherStream.getCondition(), (AbstractQuadJoiner)joiner);
    }

    @Override
    public DroolsQuadCondition<A, B, C, D, ?> getCondition() {
        return this.condition;
    }

    public DroolsAbstractTriConstraintStream<Solution_, A, B, C> getLeftParentStream() {
        return this.leftParentStream;
    }

    public DroolsAbstractUniConstraintStream<Solution_, D> getRightParentStream() {
        return this.rightParentStream;
    }

    public String toString() {
        return "QuadJoin() with " + this.getChildStreams().size() + " children";
    }
}

