/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.kafkaconnector.CamelSinkConnector;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.camel.kafkaconnector.utils.CamelKafkaConnectDataformat;
import org.apache.camel.kafkaconnector.utils.CamelMainSupport;
import org.apache.camel.kafkaconnector.utils.TaskHelper;
import org.apache.camel.support.DefaultExchange;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelSinkTask
extends SinkTask {
    public static final String KAFKA_RECORD_KEY_HEADER = "camel.kafka.connector.record.key";
    public static final String HEADER_CAMEL_PREFIX = "CamelHeader.";
    public static final String PROPERTY_CAMEL_PREFIX = "CamelProperty.";
    private static final String CAMEL_SINK_ENDPOINT_PROPERTIES_PREFIX = "camel.sink.endpoint.";
    private static final String CAMEL_SINK_PATH_PROPERTIES_PREFIX = "camel.sink.path.";
    private static final Logger LOG = LoggerFactory.getLogger(CamelSinkTask.class);
    private static final String LOCAL_URL = "direct:start";
    private CamelMainSupport cms;
    private ProducerTemplate producer;
    private CamelSinkConnectorConfig config;

    public String version() {
        return new CamelSinkConnector().version();
    }

    public void start(Map<String, String> props) {
        try {
            LOG.info("Starting CamelSinkTask connector task");
            Map<String, String> actualProps = TaskHelper.mergeProperties(this.getDefaultConfig(), props);
            this.config = this.getCamelSinkConnectorConfig(actualProps);
            String remoteUrl = this.config.getString("camel.sink.url");
            String marshaller = this.config.getString("camel.sink.marshal");
            String unmarshaller = this.config.getString("camel.sink.unmarshal");
            LinkedList<CamelKafkaConnectDataformat> dataformats = new LinkedList<CamelKafkaConnectDataformat>();
            if (unmarshaller != null) {
                dataformats.add(new CamelKafkaConnectDataformat(unmarshaller, CamelKafkaConnectDataformat.CamelKafkaConnectDataformatKind.UNMARSHALL));
            }
            if (marshaller != null) {
                dataformats.add(new CamelKafkaConnectDataformat(marshaller, CamelKafkaConnectDataformat.CamelKafkaConnectDataformatKind.MARSHALL));
            }
            int size = this.config.getInt("camel.beans.aggregation.size");
            long timeout = this.config.getLong("camel.beans.aggregation.timeout");
            DefaultCamelContext camelContext = new DefaultCamelContext();
            if (remoteUrl == null) {
                remoteUrl = TaskHelper.buildUrl(((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getRuntimeCamelCatalog(), actualProps, this.config.getString("camel.sink.component"), CAMEL_SINK_ENDPOINT_PROPERTIES_PREFIX, CAMEL_SINK_PATH_PROPERTIES_PREFIX);
            }
            this.cms = new CamelMainSupport(actualProps, LOCAL_URL, remoteUrl, dataformats, size, timeout, (CamelContext)camelContext);
            this.producer = this.cms.createProducerTemplate();
            this.cms.start();
            LOG.info("CamelSinkTask connector task started");
        }
        catch (Exception e) {
            throw new ConnectException("Failed to create and start Camel context", (Throwable)e);
        }
    }

    protected CamelSinkConnectorConfig getCamelSinkConnectorConfig(Map<String, String> props) {
        return new CamelSinkConnectorConfig(props);
    }

    protected Map<String, String> getDefaultConfig() {
        return Collections.EMPTY_MAP;
    }

    protected static String getCamelSinkEndpointConfigPrefix() {
        return CAMEL_SINK_ENDPOINT_PROPERTIES_PREFIX;
    }

    protected static String getCamelSinkPathConfigPrefix() {
        return CAMEL_SINK_PATH_PROPERTIES_PREFIX;
    }

    public void put(Collection<SinkRecord> sinkRecords) {
        for (SinkRecord record : sinkRecords) {
            TaskHelper.logRecordContent(LOG, record, this.config);
            HashMap<String, Object> headers = new HashMap<String, Object>();
            DefaultExchange exchange = new DefaultExchange(this.producer.getCamelContext());
            headers.put(KAFKA_RECORD_KEY_HEADER, record.key());
            for (Header header : record.headers()) {
                if (header.key().startsWith(HEADER_CAMEL_PREFIX)) {
                    this.addHeader(headers, header);
                    continue;
                }
                if (!header.key().startsWith(PROPERTY_CAMEL_PREFIX)) continue;
                this.addProperty((Exchange)exchange, header);
            }
            exchange.getMessage().setHeaders(headers);
            exchange.getMessage().setBody(record.value());
            LOG.debug("Sending exchange {} to {}", (Object)exchange.getExchangeId(), (Object)LOCAL_URL);
            this.producer.send(LOCAL_URL, (Exchange)exchange);
            if (!exchange.isFailed()) continue;
            throw new ConnectException("Exchange delivery has failed!", (Throwable)exchange.getException());
        }
    }

    public void stop() {
        LOG.info("Stopping CamelSinkTask connector task");
        try {
            this.cms.stop();
        }
        catch (Exception e) {
            throw new ConnectException("Failed to stop Camel context", (Throwable)e);
        }
        finally {
            LOG.info("CamelSinkTask connector task stopped");
        }
    }

    private void addHeader(Map<String, Object> map, Header singleHeader) {
        String camelHeaderKey = StringUtils.removeStart((String)singleHeader.key(), (String)HEADER_CAMEL_PREFIX);
        Schema schema = singleHeader.schema();
        if (schema.type().getName().equals(Schema.STRING_SCHEMA.type().getName())) {
            map.put(camelHeaderKey, (String)singleHeader.value());
        } else if (schema.type().getName().equalsIgnoreCase(Schema.BOOLEAN_SCHEMA.type().getName())) {
            map.put(camelHeaderKey, (Boolean)singleHeader.value());
        } else if (schema.type().getName().equalsIgnoreCase(Schema.INT32_SCHEMA.type().getName())) {
            map.put(camelHeaderKey, singleHeader.value());
        } else if (schema.type().getName().equalsIgnoreCase(Schema.BYTES_SCHEMA.type().getName())) {
            if (Decimal.class.getCanonicalName().equals(schema.name())) {
                map.put(camelHeaderKey, Decimal.toLogical((Schema)schema, (byte[])((byte[])singleHeader.value())));
            } else {
                map.put(camelHeaderKey, (byte[])singleHeader.value());
            }
        } else if (schema.type().getName().equalsIgnoreCase(Schema.FLOAT32_SCHEMA.type().getName())) {
            map.put(camelHeaderKey, Float.valueOf(((Float)singleHeader.value()).floatValue()));
        } else if (schema.type().getName().equalsIgnoreCase(Schema.FLOAT64_SCHEMA.type().getName())) {
            map.put(camelHeaderKey, (double)((Double)singleHeader.value()));
        } else if (schema.type().getName().equalsIgnoreCase(Schema.INT16_SCHEMA.type().getName())) {
            map.put(camelHeaderKey, (short)((Short)singleHeader.value()));
        } else if (schema.type().getName().equalsIgnoreCase(Schema.INT64_SCHEMA.type().getName())) {
            map.put(camelHeaderKey, (long)((Long)singleHeader.value()));
        } else if (schema.type().getName().equalsIgnoreCase(Schema.INT8_SCHEMA.type().getName())) {
            map.put(camelHeaderKey, (byte)((Byte)singleHeader.value()));
        } else if (schema.type().getName().equalsIgnoreCase(SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.STRING_SCHEMA).type().getName())) {
            map.put(camelHeaderKey, (Map)singleHeader.value());
        } else if (schema.type().getName().equalsIgnoreCase(SchemaBuilder.array((Schema)Schema.STRING_SCHEMA).type().getName())) {
            map.put(camelHeaderKey, (List)singleHeader.value());
        }
    }

    private void addProperty(Exchange exchange, Header singleHeader) {
        String camelPropertyKey = StringUtils.removeStart((String)singleHeader.key(), (String)PROPERTY_CAMEL_PREFIX);
        Schema schema = singleHeader.schema();
        if (schema.type().getName().equals(Schema.STRING_SCHEMA.type().getName())) {
            exchange.getProperties().put(camelPropertyKey, (String)singleHeader.value());
        } else if (schema.type().getName().equalsIgnoreCase(Schema.BOOLEAN_SCHEMA.type().getName())) {
            exchange.getProperties().put(camelPropertyKey, (Boolean)singleHeader.value());
        } else if (schema.type().getName().equalsIgnoreCase(Schema.INT32_SCHEMA.type().getName())) {
            exchange.getProperties().put(camelPropertyKey, singleHeader.value());
        } else if (schema.type().getName().equalsIgnoreCase(Schema.BYTES_SCHEMA.type().getName())) {
            exchange.getProperties().put(camelPropertyKey, (byte[])singleHeader.value());
        } else if (schema.type().getName().equalsIgnoreCase(Schema.FLOAT32_SCHEMA.type().getName())) {
            exchange.getProperties().put(camelPropertyKey, Float.valueOf(((Float)singleHeader.value()).floatValue()));
        } else if (schema.type().getName().equalsIgnoreCase(Schema.FLOAT64_SCHEMA.type().getName())) {
            exchange.getProperties().put(camelPropertyKey, Double.valueOf((Double)singleHeader.value()));
        } else if (schema.type().getName().equalsIgnoreCase(Schema.INT16_SCHEMA.type().getName())) {
            exchange.getProperties().put(camelPropertyKey, Short.valueOf((Short)singleHeader.value()));
        } else if (schema.type().getName().equalsIgnoreCase(Schema.INT64_SCHEMA.type().getName())) {
            exchange.getProperties().put(camelPropertyKey, Long.valueOf((Long)singleHeader.value()));
        } else if (schema.type().getName().equalsIgnoreCase(Schema.INT8_SCHEMA.type().getName())) {
            exchange.getProperties().put(camelPropertyKey, Byte.valueOf((Byte)singleHeader.value()));
        } else if (schema.type().getName().equalsIgnoreCase(SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.STRING_SCHEMA).type().getName())) {
            exchange.getProperties().put(camelPropertyKey, (Map)singleHeader.value());
        } else if (schema.type().getName().equalsIgnoreCase(SchemaBuilder.array((Schema)Schema.STRING_SCHEMA).type().getName())) {
            exchange.getProperties().put(camelPropertyKey, (List)singleHeader.value());
        }
    }

    public CamelMainSupport getCms() {
        return this.cms;
    }
}

