/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.exhaustivesearch.decider;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.exhaustivesearch.event.ExhaustiveSearchPhaseLifecycleListener;
import org.optaplanner.core.impl.exhaustivesearch.node.ExhaustiveSearchLayer;
import org.optaplanner.core.impl.exhaustivesearch.node.ExhaustiveSearchNode;
import org.optaplanner.core.impl.exhaustivesearch.node.bounder.ScoreBounder;
import org.optaplanner.core.impl.exhaustivesearch.scope.ExhaustiveSearchPhaseScope;
import org.optaplanner.core.impl.exhaustivesearch.scope.ExhaustiveSearchStepScope;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.ManualEntityMimicRecorder;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.Termination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExhaustiveSearchDecider<Solution_>
implements ExhaustiveSearchPhaseLifecycleListener<Solution_> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String logIndentation;
    protected final BestSolutionRecaller<Solution_> bestSolutionRecaller;
    protected final Termination termination;
    protected final ManualEntityMimicRecorder manualEntityMimicRecorder;
    protected final MoveSelector moveSelector;
    protected final boolean scoreBounderEnabled;
    protected final ScoreBounder scoreBounder;
    protected boolean assertMoveScoreFromScratch = false;
    protected boolean assertExpectedUndoMoveScore = false;

    public ExhaustiveSearchDecider(String logIndentation, BestSolutionRecaller<Solution_> bestSolutionRecaller, Termination termination, ManualEntityMimicRecorder manualEntityMimicRecorder, MoveSelector moveSelector, boolean scoreBounderEnabled, ScoreBounder scoreBounder) {
        this.logIndentation = logIndentation;
        this.bestSolutionRecaller = bestSolutionRecaller;
        this.termination = termination;
        this.manualEntityMimicRecorder = manualEntityMimicRecorder;
        this.moveSelector = moveSelector;
        this.scoreBounderEnabled = scoreBounderEnabled;
        this.scoreBounder = scoreBounder;
    }

    public ManualEntityMimicRecorder getManualEntityMimicRecorder() {
        return this.manualEntityMimicRecorder;
    }

    public MoveSelector getMoveSelector() {
        return this.moveSelector;
    }

    public boolean isScoreBounderEnabled() {
        return this.scoreBounderEnabled;
    }

    public ScoreBounder getScoreBounder() {
        return this.scoreBounder;
    }

    public void setAssertMoveScoreFromScratch(boolean assertMoveScoreFromScratch) {
        this.assertMoveScoreFromScratch = assertMoveScoreFromScratch;
    }

    public void setAssertExpectedUndoMoveScore(boolean assertExpectedUndoMoveScore) {
        this.assertExpectedUndoMoveScore = assertExpectedUndoMoveScore;
    }

    @Override
    public void solvingStarted(DefaultSolverScope<Solution_> solverScope) {
        this.moveSelector.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(ExhaustiveSearchPhaseScope<Solution_> phaseScope) {
        this.moveSelector.phaseStarted(phaseScope);
    }

    @Override
    public void stepStarted(ExhaustiveSearchStepScope<Solution_> stepScope) {
        this.moveSelector.stepStarted(stepScope);
    }

    @Override
    public void stepEnded(ExhaustiveSearchStepScope<Solution_> stepScope) {
        this.moveSelector.stepEnded(stepScope);
    }

    @Override
    public void phaseEnded(ExhaustiveSearchPhaseScope<Solution_> phaseScope) {
        this.moveSelector.phaseEnded(phaseScope);
    }

    @Override
    public void solvingEnded(DefaultSolverScope<Solution_> solverScope) {
        this.moveSelector.solvingEnded(solverScope);
    }

    public void expandNode(ExhaustiveSearchStepScope<Solution_> stepScope) {
        ExhaustiveSearchNode expandingNode = stepScope.getExpandingNode();
        this.manualEntityMimicRecorder.setRecordedEntity(expandingNode.getEntity());
        stepScope.setBestScoreImproved(false);
        int moveIndex = 0;
        ExhaustiveSearchLayer moveLayer = ((ExhaustiveSearchPhaseScope)stepScope.getPhaseScope()).getLayerList().get(expandingNode.getDepth() + 1);
        for (Move move : this.moveSelector) {
            ExhaustiveSearchNode moveNode = new ExhaustiveSearchNode(moveLayer, expandingNode);
            ++moveIndex;
            moveNode.setMove(move);
            this.doMove(stepScope, moveNode);
            stepScope.getPhaseScope().getSolverScope().checkYielding();
            if (!this.termination.isPhaseTerminated(stepScope.getPhaseScope())) continue;
            break;
        }
        stepScope.setSelectedMoveCount(Long.valueOf(moveIndex));
    }

    private void doMove(ExhaustiveSearchStepScope<Solution_> stepScope, ExhaustiveSearchNode moveNode) {
        InnerScoreDirector scoreDirector = stepScope.getScoreDirector();
        Move move = moveNode.getMove();
        Move undoMove = move.doMove(scoreDirector);
        moveNode.setUndoMove(undoMove);
        this.processMove(stepScope, moveNode);
        undoMove.doMove(scoreDirector);
        if (this.assertExpectedUndoMoveScore && stepScope.getStartingStepScore() != null) {
            scoreDirector.assertExpectedUndoMoveScore(move, stepScope.getStartingStepScore());
        }
        this.logger.trace("{}        Move treeId ({}), score ({}), expandable ({}), move ({}).", new Object[]{this.logIndentation, moveNode.getTreeId(), moveNode.getScore(), moveNode.isExpandable(), moveNode.getMove()});
    }

    private void processMove(ExhaustiveSearchStepScope<Solution_> stepScope, ExhaustiveSearchNode moveNode) {
        AbstractPhaseScope phaseScope = stepScope.getPhaseScope();
        boolean lastLayer = moveNode.isLastLayer();
        if (!this.scoreBounderEnabled) {
            if (lastLayer) {
                Score score = phaseScope.calculateScore();
                moveNode.setScore(score);
                if (this.assertMoveScoreFromScratch) {
                    phaseScope.assertWorkingScoreFromScratch(score, moveNode.getMove());
                }
                this.bestSolutionRecaller.processWorkingSolutionDuringMove(score, stepScope);
            } else {
                ((ExhaustiveSearchPhaseScope)phaseScope).addExpandableNode(moveNode);
            }
        } else {
            Score score = phaseScope.calculateScore();
            moveNode.setScore(score);
            if (this.assertMoveScoreFromScratch) {
                phaseScope.assertWorkingScoreFromScratch(score, moveNode.getMove());
            }
            if (lastLayer) {
                ((ExhaustiveSearchPhaseScope)phaseScope).registerPessimisticBound(score);
                this.bestSolutionRecaller.processWorkingSolutionDuringMove(score, stepScope);
            } else {
                InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
                Score optimisticBound = this.scoreBounder.calculateOptimisticBound(scoreDirector, score);
                moveNode.setOptimisticBound(optimisticBound);
                if (optimisticBound.compareTo(((ExhaustiveSearchPhaseScope)phaseScope).getBestPessimisticBound()) > 0) {
                    ((ExhaustiveSearchPhaseScope)phaseScope).addExpandableNode(moveNode);
                    Score pessimisticBound = this.scoreBounder.calculatePessimisticBound(scoreDirector, score);
                    ((ExhaustiveSearchPhaseScope)phaseScope).registerPessimisticBound(pessimisticBound);
                }
            }
        }
    }
}

