/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.drools.model.BetaIndex3;
import org.drools.model.DSL;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Function3;
import org.drools.model.functions.Predicate4;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.view.ExprViewItem;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.api.function.ToIntTriFunction;
import org.optaplanner.core.api.function.ToLongTriFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.api.score.stream.quad.QuadJoiner;
import org.optaplanner.core.api.score.stream.tri.TriConstraintCollector;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.drools.DroolsVariableFactory;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.BiLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DetachedPatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.DirectPatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.IndirectPatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.PatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.QuadLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.QuadTuple;
import org.optaplanner.core.impl.score.stream.drools.common.RuleBuilder;
import org.optaplanner.core.impl.score.stream.drools.common.TriAccumulator;
import org.optaplanner.core.impl.score.stream.drools.common.TriRuleContext;
import org.optaplanner.core.impl.score.stream.drools.common.TriTuple;
import org.optaplanner.core.impl.score.stream.drools.common.UniLeftHandSide;
import org.optaplanner.core.impl.score.stream.quad.AbstractQuadJoiner;
import org.optaplanner.core.impl.score.stream.quad.FilteringQuadJoiner;
import org.optaplanner.core.impl.score.stream.quad.NoneQuadJoiner;
import org.optaplanner.core.impl.score.stream.tri.NoneTriJoiner;

public final class TriLeftHandSide<A, B, C>
extends AbstractLeftHandSide {
    private final PatternVariable<A, ?, ?> patternVariableA;
    private final PatternVariable<B, ?, ?> patternVariableB;
    private final PatternVariable<C, ?, ?> patternVariableC;
    private final TriRuleContext<A, B, C> ruleContext;

    protected TriLeftHandSide(Variable<A> variableA, Variable<B> variableB, PatternVariable<C, ?, ?> patternVariableC, DroolsVariableFactory variableFactory) {
        this(new DetachedPatternVariable(variableA), new DetachedPatternVariable(variableB), patternVariableC, variableFactory);
    }

    protected TriLeftHandSide(PatternVariable<A, ?, ?> patternVariableA, PatternVariable<B, ?, ?> patternVariableB, PatternVariable<C, ?, ?> patternVariableC, DroolsVariableFactory variableFactory) {
        super(variableFactory);
        this.patternVariableA = Objects.requireNonNull(patternVariableA);
        this.patternVariableB = Objects.requireNonNull(patternVariableB);
        this.patternVariableC = Objects.requireNonNull(patternVariableC);
        this.ruleContext = this.buildRuleContext();
    }

    private TriRuleContext<A, B, C> buildRuleContext() {
        ViewItem[] viewItems = (ViewItem[])Stream.of(this.patternVariableA, this.patternVariableB, this.patternVariableC).flatMap(variable -> variable.build().stream()).toArray(ViewItem[]::new);
        return new TriRuleContext<A, B, C>(this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), viewItems);
    }

    public TriLeftHandSide<A, B, C> andFilter(TriPredicate<A, B, C> predicate) {
        return new TriLeftHandSide<A, B, C>(this.patternVariableA, this.patternVariableB, this.patternVariableC.filter(predicate, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable()), this.variableFactory);
    }

    private <D> TriLeftHandSide<A, B, C> applyJoiners(Class<D> otherFactType, AbstractQuadJoiner<A, B, C, D> joiner, QuadPredicate<A, B, C, D> predicate, boolean shouldExist) {
        Variable toExist = this.variableFactory.createVariable(otherFactType, "toExist");
        PatternDSL.PatternDef existencePattern = PatternDSL.pattern(toExist);
        if (joiner == null) {
            return this.applyFilters(existencePattern, predicate, shouldExist);
        }
        JoinerType[] joinerTypes = joiner.getJoinerTypes();
        for (int mappingIndex = 0; mappingIndex < joinerTypes.length; ++mappingIndex) {
            JoinerType joinerType = joinerTypes[mappingIndex];
            TriFunction leftMapping = joiner.getLeftMapping(mappingIndex);
            Function rightMapping = joiner.getRightMapping(mappingIndex);
            Predicate4 & Serializable joinPredicate = (Predicate4 & Serializable)(d, a, b, c) -> joinerType.matches(leftMapping.apply(a, b, c), rightMapping.apply(d));
            BetaIndex3 index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)TriLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, rightMapping::apply, leftMapping::apply, Object.class);
            existencePattern = existencePattern.expr("Join using joiner #" + mappingIndex + " in " + joiner, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), (Predicate4)joinPredicate, index);
        }
        return this.applyFilters(existencePattern, predicate, shouldExist);
    }

    private <D> TriLeftHandSide<A, B, C> applyFilters(PatternDSL.PatternDef<D> existencePattern, QuadPredicate<A, B, C, D> predicate, boolean shouldExist) {
        PatternDSL.PatternDef possiblyFilteredExistencePattern = predicate == null ? existencePattern : existencePattern.expr("Filter using " + predicate, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), (Predicate4 & Serializable)(d, a, b, c) -> predicate.test(a, b, c, d));
        ExprViewItem existenceExpression = DSL.exists(possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        if (!shouldExist) {
            existenceExpression = DSL.not(possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        }
        return new TriLeftHandSide<A, B, C>(this.patternVariableA, this.patternVariableB, this.patternVariableC.addDependentExpression((ViewItem<?>)existenceExpression), this.variableFactory);
    }

    private <D> TriLeftHandSide<A, B, C> existsOrNot(Class<D> dClass, QuadJoiner<A, B, C, D>[] joiners, boolean shouldExist) {
        int indexOfFirstFilter = -1;
        AbstractQuadJoiner finalJoiner = null;
        QuadPredicate finalFilter = null;
        for (int i = 0; i < joiners.length; ++i) {
            boolean hasAFilter;
            AbstractQuadJoiner joiner = (AbstractQuadJoiner)joiners[i];
            boolean bl = hasAFilter = indexOfFirstFilter >= 0;
            if (joiner instanceof NoneQuadJoiner && joiners.length > 1) {
                throw new IllegalStateException("If present, " + NoneTriJoiner.class + " must be the only joiner, got " + Arrays.toString(joiners) + " instead.");
            }
            if (!(joiner instanceof FilteringQuadJoiner)) {
                if (hasAFilter) {
                    throw new IllegalStateException("Indexing joiner (" + joiner + ") must not follow a filtering joiner (" + joiners[indexOfFirstFilter] + ").");
                }
                finalJoiner = finalJoiner == null ? joiner : AbstractQuadJoiner.merge(finalJoiner, joiner);
                continue;
            }
            if (!hasAFilter) {
                indexOfFirstFilter = i;
            }
            finalFilter = finalFilter == null ? joiner.getFilter() : finalFilter.and(joiner.getFilter());
        }
        return this.applyJoiners(dClass, finalJoiner, finalFilter, shouldExist);
    }

    public <D> TriLeftHandSide<A, B, C> andExists(Class<D> dClass, QuadJoiner<A, B, C, D>[] joiners) {
        return this.existsOrNot(dClass, joiners, true);
    }

    public <D> TriLeftHandSide<A, B, C> andNotExists(Class<D> dClass, QuadJoiner<A, B, C, D>[] joiners) {
        return this.existsOrNot(dClass, joiners, false);
    }

    public <D> QuadLeftHandSide<A, B, C, D> andJoin(UniLeftHandSide<D> right, QuadJoiner<A, B, C, D> joiner) {
        AbstractQuadJoiner castJoiner = (AbstractQuadJoiner)joiner;
        JoinerType[] joinerTypes = castJoiner.getJoinerTypes();
        PatternVariable<D, ?, ?> newRight = right.getPatternVariableA();
        for (int mappingIndex = 0; mappingIndex < joinerTypes.length; ++mappingIndex) {
            JoinerType joinerType = joinerTypes[mappingIndex];
            newRight = newRight.filterForJoin(this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), castJoiner, joinerType, mappingIndex);
        }
        return new QuadLeftHandSide<A, B, C, D>(this.patternVariableA, this.patternVariableB, this.patternVariableC, newRight, this.variableFactory);
    }

    public <NewA> UniLeftHandSide<NewA> andGroupBy(TriConstraintCollector<A, B, C, ?, NewA> collector) {
        Variable accumulateOutput = this.variableFactory.createVariable("collected");
        ViewItem<?> innerAccumulatePattern = TriLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, this.patternVariableC);
        ViewItem<?> outerAccumulatePattern = TriLeftHandSide.buildAccumulate(innerAccumulatePattern, this.createAccumulateFunction(collector, accumulateOutput));
        return new UniLeftHandSide(accumulateOutput, Collections.singletonList(outerAccumulatePattern), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(TriConstraintCollector<A, B, C, ?, NewA> collectorA, TriConstraintCollector<A, B, C, ?, NewB> collectorB) {
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        ViewItem<?> innerAccumulatePattern = TriLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, this.patternVariableC);
        ViewItem<?> outerAccumulatePattern = TriLeftHandSide.buildAccumulate(innerAccumulatePattern, this.createAccumulateFunction(collectorA, accumulateOutputA), this.createAccumulateFunction(collectorB, accumulateOutputB));
        return new BiLeftHandSide(accumulateOutputA, new DirectPatternVariable(accumulateOutputB, outerAccumulatePattern), this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(TriConstraintCollector<A, B, C, ?, NewA> collectorA, TriConstraintCollector<A, B, C, ?, NewB> collectorB, TriConstraintCollector<A, B, C, ?, NewC> collectorC) {
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        Variable accumulateOutputC = this.variableFactory.createVariable("collectedC");
        ViewItem<?> innerAccumulatePattern = TriLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, this.patternVariableC);
        ViewItem<?> outerAccumulatePattern = TriLeftHandSide.buildAccumulate(innerAccumulatePattern, this.createAccumulateFunction(collectorA, accumulateOutputA), this.createAccumulateFunction(collectorB, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateOutputC));
        return new TriLeftHandSide(accumulateOutputA, accumulateOutputB, new DirectPatternVariable(accumulateOutputC, outerAccumulatePattern), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(TriConstraintCollector<A, B, C, ?, NewA> collectorA, TriConstraintCollector<A, B, C, ?, NewB> collectorB, TriConstraintCollector<A, B, C, ?, NewC> collectorC, TriConstraintCollector<A, B, C, ?, NewD> collectorD) {
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        Variable accumulateOutputC = this.variableFactory.createVariable("collectedC");
        Variable accumulateOutputD = this.variableFactory.createVariable("collectedD");
        ViewItem<?> innerAccumulatePattern = TriLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, this.patternVariableC);
        ViewItem<?> outerAccumulatePattern = TriLeftHandSide.buildAccumulate(innerAccumulatePattern, this.createAccumulateFunction(collectorA, accumulateOutputA), this.createAccumulateFunction(collectorB, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateOutputD));
        return new QuadLeftHandSide(accumulateOutputA, accumulateOutputB, accumulateOutputC, new DirectPatternVariable(accumulateOutputD, outerAccumulatePattern), this.variableFactory);
    }

    private <Out> AccumulateFunction createAccumulateFunction(TriConstraintCollector<A, B, C, ?, Out> collector, Variable<Out> out) {
        Variable variableA = this.patternVariableA.getPrimaryVariable();
        Variable variableB = this.patternVariableB.getPrimaryVariable();
        Variable variableC = this.patternVariableC.getPrimaryVariable();
        return new AccumulateFunction(null, () -> new TriAccumulator(variableA, variableB, variableC, collector)).with(new Variable[]{variableA, variableB, variableC}).as(out);
    }

    public <NewA> UniLeftHandSide<NewA> andGroupBy(TriFunction<A, B, C, NewA> keyMapping) {
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, keyMapping::apply, new AccumulateFunction[0]);
        return new UniLeftHandSide(groupKey, Collections.singletonList(groupByPattern), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(TriFunction<A, B, C, NewA> keyMappingA, TriConstraintCollector<A, B, C, ?, NewB> collectorB) {
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutput = this.variableFactory.createVariable("output");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, keyMappingA::apply, this.createAccumulateFunction(collectorB, accumulateOutput));
        return new BiLeftHandSide(groupKey, new DirectPatternVariable(accumulateOutput, groupByPattern), this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(TriFunction<A, B, C, NewA> keyMappingA, TriConstraintCollector<A, B, C, ?, NewB> collectorB, TriConstraintCollector<A, B, C, ?, NewC> collectorC) {
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutputB = this.variableFactory.createVariable("outputB");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, keyMappingA::apply, this.createAccumulateFunction(collectorB, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateOutputC));
        return new TriLeftHandSide(groupKey, accumulateOutputB, new DirectPatternVariable(accumulateOutputC, groupByPattern), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(TriFunction<A, B, C, NewA> keyMappingA, TriConstraintCollector<A, B, C, ?, NewB> collectorB, TriConstraintCollector<A, B, C, ?, NewC> collectorC, TriConstraintCollector<A, B, C, ?, NewD> collectorD) {
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutputB = this.variableFactory.createVariable("outputB");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, keyMappingA::apply, this.createAccumulateFunction(collectorB, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateOutputD));
        return new QuadLeftHandSide(groupKey, accumulateOutputB, accumulateOutputC, new DirectPatternVariable(accumulateOutputD, groupByPattern), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(TriFunction<A, B, C, NewA> keyMappingA, TriFunction<A, B, C, NewB> keyMappingB) {
        Variable groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, this.createCompositeBiGroupKey(keyMappingA, keyMappingB), new AccumulateFunction[0]);
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        DirectPatternVariable tuplePatternVar = TriLeftHandSide.decompose(groupKey, groupByPattern, newA, newB);
        IndirectPatternVariable<Object, BiTuple> bPatternVar = new IndirectPatternVariable<Object, BiTuple>(tuplePatternVar, newB, tuple -> tuple.b);
        return new BiLeftHandSide(newA, bPatternVar, this.variableFactory);
    }

    private <NewA, NewB> Function3<A, B, C, BiTuple<NewA, NewB>> createCompositeBiGroupKey(TriFunction<A, B, C, NewA> keyMappingA, TriFunction<A, B, C, NewB> keyMappingB) {
        return (Function3 & Serializable)(a, b, c) -> new BiTuple(keyMappingA.apply(a, b, c), keyMappingB.apply(a, b, c));
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(TriFunction<A, B, C, NewA> keyMappingA, TriFunction<A, B, C, NewB> keyMappingB, TriConstraintCollector<A, B, C, ?, NewC> collectorC) {
        Variable groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        Variable accumulateOutput = this.variableFactory.createVariable("output");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, this.createCompositeBiGroupKey(keyMappingA, keyMappingB), this.createAccumulateFunction(collectorC, accumulateOutput));
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        DirectPatternVariable tuplePatternVar = TriLeftHandSide.decompose(groupKey, groupByPattern, newA, newB);
        return new TriLeftHandSide(newA, newB, new DirectPatternVariable(accumulateOutput, tuplePatternVar.build()), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(TriFunction<A, B, C, NewA> keyMappingA, TriFunction<A, B, C, NewB> keyMappingB, TriConstraintCollector<A, B, C, ?, NewC> collectorC, TriConstraintCollector<A, B, C, ?, NewD> collectorD) {
        Variable groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, this.createCompositeBiGroupKey(keyMappingA, keyMappingB), this.createAccumulateFunction(collectorC, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateOutputD));
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        DirectPatternVariable tuplePatternVar = TriLeftHandSide.decompose(groupKey, groupByPattern, newA, newB);
        return new QuadLeftHandSide(newA, newB, accumulateOutputC, new DirectPatternVariable(accumulateOutputD, tuplePatternVar.build()), this.variableFactory);
    }

    private <NewA, NewB, NewC> Function3<A, B, C, TriTuple<NewA, NewB, NewC>> createCompositeTriGroupKey(TriFunction<A, B, C, NewA> keyMappingA, TriFunction<A, B, C, NewB> keyMappingB, TriFunction<A, B, C, NewC> keyMappingC) {
        return (Function3 & Serializable)(a, b, c) -> new TriTuple(keyMappingA.apply(a, b, c), keyMappingB.apply(a, b, c), keyMappingC.apply(a, b, c));
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(TriFunction<A, B, C, NewA> keyMappingA, TriFunction<A, B, C, NewB> keyMappingB, TriFunction<A, B, C, NewC> keyMappingC) {
        Variable groupKey = this.variableFactory.createVariable(TriTuple.class, "groupKey");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, this.createCompositeTriGroupKey(keyMappingA, keyMappingB, keyMappingC), new AccumulateFunction[0]);
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        Variable newC = this.variableFactory.createVariable("newC");
        DirectPatternVariable tuplePatternVar = TriLeftHandSide.decompose(groupKey, groupByPattern, newA, newB, newC);
        IndirectPatternVariable<Object, TriTuple> cPatternVar = new IndirectPatternVariable<Object, TriTuple>(tuplePatternVar, newC, tuple -> tuple.c);
        return new TriLeftHandSide(newA, newB, cPatternVar, this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(TriFunction<A, B, C, NewA> keyMappingA, TriFunction<A, B, C, NewB> keyMappingB, TriFunction<A, B, C, NewC> keyMappingC, TriConstraintCollector<A, B, C, ?, NewD> collectorD) {
        Variable groupKey = this.variableFactory.createVariable(TriTuple.class, "groupKey");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, this.createCompositeTriGroupKey(keyMappingA, keyMappingB, keyMappingC), this.createAccumulateFunction(collectorD, accumulateOutputD));
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        Variable newC = this.variableFactory.createVariable("newC");
        DirectPatternVariable tuplePatternVar = TriLeftHandSide.decompose(groupKey, groupByPattern, newA, newB, newC);
        return new QuadLeftHandSide(newA, newB, newC, new DirectPatternVariable(accumulateOutputD, tuplePatternVar.build()), this.variableFactory);
    }

    private <NewA, NewB, NewC, NewD> Function3<A, B, C, QuadTuple<NewA, NewB, NewC, NewD>> createCompositeQuadGroupKey(TriFunction<A, B, C, NewA> keyMappingA, TriFunction<A, B, C, NewB> keyMappingB, TriFunction<A, B, C, NewC> keyMappingC, TriFunction<A, B, C, NewD> keyMappingD) {
        return (Function3 & Serializable)(a, b, c) -> new QuadTuple(keyMappingA.apply(a, b, c), keyMappingB.apply(a, b, c), keyMappingC.apply(a, b, c), keyMappingD.apply(a, b, c));
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(TriFunction<A, B, C, NewA> keyMappingA, TriFunction<A, B, C, NewB> keyMappingB, TriFunction<A, B, C, NewC> keyMappingC, TriFunction<A, B, C, NewD> keyMappingD) {
        Variable groupKey = this.variableFactory.createVariable(QuadTuple.class, "groupKey");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, this.createCompositeQuadGroupKey(keyMappingA, keyMappingB, keyMappingC, keyMappingD), new AccumulateFunction[0]);
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        Variable newC = this.variableFactory.createVariable("newC");
        Variable newD = this.variableFactory.createVariable("newD");
        DirectPatternVariable tuplePatternVar = TriLeftHandSide.decompose(groupKey, groupByPattern, newA, newB, newC, newD);
        IndirectPatternVariable<Object, QuadTuple> dPatternVar = new IndirectPatternVariable<Object, QuadTuple>(tuplePatternVar, newD, tuple -> tuple.d);
        return new QuadLeftHandSide(newA, newB, newC, dPatternVar, this.variableFactory);
    }

    public <NewA> UniLeftHandSide<NewA> andMap(TriFunction<A, B, C, NewA> mapping) {
        Variable<NewA> newA = this.variableFactory.createVariable("mapped", this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), mapping);
        List<ViewItem<?>> allPrerequisites = TriLeftHandSide.mergeViewItems(this.patternVariableA, this.patternVariableB, this.patternVariableC);
        DirectPatternVariable<NewA> newPatternVariableA = new DirectPatternVariable<NewA>(newA, allPrerequisites);
        return new UniLeftHandSide(newPatternVariableA, this.variableFactory);
    }

    public <NewC> TriLeftHandSide<A, B, NewC> andFlattenLast(Function<C, Iterable<NewC>> mapping) {
        Variable<C> source = this.patternVariableC.getPrimaryVariable();
        Variable<NewC> newC = this.variableFactory.createFlattenedVariable("flattened", source, mapping);
        List<ViewItem<?>> allPrerequisites = TriLeftHandSide.mergeViewItems(this.patternVariableA, this.patternVariableB, this.patternVariableC);
        DirectPatternVariable<NewC> newPatternVariableC = new DirectPatternVariable<NewC>(newC, allPrerequisites);
        return new TriLeftHandSide<A, B, C>(this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), newPatternVariableC, this.variableFactory);
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate() {
        return this.ruleContext.newRuleBuilder();
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate(ToIntTriFunction<A, B, C> matchWeighter) {
        return this.ruleContext.newRuleBuilder(matchWeighter);
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate(ToLongTriFunction<A, B, C> matchWeighter) {
        return this.ruleContext.newRuleBuilder(matchWeighter);
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate(TriFunction<A, B, C, BigDecimal> matchWeighter) {
        return this.ruleContext.newRuleBuilder(matchWeighter);
    }

    private <GroupKey_> ViewItem<?> buildGroupBy(Variable<GroupKey_> groupKey, Function3<A, B, C, GroupKey_> groupKeyExtractor, AccumulateFunction ... accFunctions) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<C> inputC = this.patternVariableC.getPrimaryVariable();
        ViewItem<?> innerGroupByPattern = TriLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, this.patternVariableC);
        return DSL.groupBy(innerGroupByPattern, inputA, inputB, inputC, groupKey, groupKeyExtractor, (AccumulateFunction[])accFunctions);
    }
}

