/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.common;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.support.DefaultEndpoint;
import org.openstack4j.api.OSClient;
import org.openstack4j.api.client.IOSClientBuilder;
import org.openstack4j.core.transport.Config;
import org.openstack4j.model.common.Identifier;
import org.openstack4j.openstack.OSFactory;

public abstract class AbstractOpenstackEndpoint
extends DefaultEndpoint {
    public static final String V2 = "V2";
    public static final String V3 = "V3";

    public AbstractOpenstackEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    protected abstract String getHost();

    protected abstract String getUsername();

    protected abstract String getDomain();

    protected abstract String getPassword();

    protected abstract String getProject();

    protected abstract String getOperation();

    protected abstract Config getConfig();

    protected abstract String getApiVersion();

    protected OSClient createClient() {
        if (V2.equals(this.getApiVersion())) {
            return this.createV2Client();
        }
        return this.createV3Client();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new IllegalStateException("There is no consumer available for OpenStack");
    }

    private OSClient.OSClientV3 createV3Client() {
        IOSClientBuilder.V3 builder = (IOSClientBuilder.V3)OSFactory.builderV3().endpoint(this.getHost());
        builder.credentials(this.getUsername(), this.getPassword(), Identifier.byName((String)this.getDomain()));
        if (this.getProject() != null) {
            builder.scopeToProject(Identifier.byId((String)this.getProject()));
        }
        if (this.getConfig() != null) {
            builder.withConfig(this.getConfig());
        }
        return (OSClient.OSClientV3)builder.authenticate();
    }

    private OSClient.OSClientV2 createV2Client() {
        IOSClientBuilder.V2 builder = (IOSClientBuilder.V2)OSFactory.builderV2().endpoint(this.getHost());
        builder.credentials(this.getUsername(), this.getPassword());
        builder.tenantId(this.getProject());
        if (this.getConfig() != null) {
            builder.withConfig(this.getConfig());
        }
        return (OSClient.OSClientV2)builder.authenticate();
    }
}

