/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.connectors.okhttp;

import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.logging.HttpLoggingInterceptor;
import org.openstack4j.core.transport.Config;
import org.openstack4j.core.transport.HttpMethod;
import org.openstack4j.core.transport.HttpRequest;
import org.openstack4j.core.transport.ObjectMapperSingleton;
import org.openstack4j.core.transport.UntrustedSSL;
import org.openstack4j.core.transport.internal.HttpLoggingFilter;

public final class HttpCommand<R> {
    private final HttpRequest<R> request;
    private OkHttpClient client;
    private Request.Builder clientReq;
    private int retries;

    private HttpCommand(HttpRequest<R> request) {
        this.request = request;
    }

    public static <R> HttpCommand<R> create(HttpRequest<R> request) {
        HttpCommand<R> command = new HttpCommand<R>(request);
        super.initialize();
        return command;
    }

    private void initialize() {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        Config config = this.request.getConfig();
        if (config.getProxy() != null) {
            okHttpClientBuilder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(config.getProxy().getRawHost(), config.getProxy().getPort())));
        }
        if (config.getConnectTimeout() > 0) {
            okHttpClientBuilder.connectTimeout((long)config.getConnectTimeout(), TimeUnit.MILLISECONDS);
        }
        if (config.getReadTimeout() > 0) {
            okHttpClientBuilder.readTimeout((long)config.getReadTimeout(), TimeUnit.MILLISECONDS);
        }
        if (config.isIgnoreSSLVerification()) {
            okHttpClientBuilder.hostnameVerifier(UntrustedSSL.getHostnameVerifier());
            okHttpClientBuilder.sslSocketFactory(UntrustedSSL.getSSLContext().getSocketFactory(), UntrustedSSL.getTrustManager());
        }
        if (config.getSslContext() != null) {
            okHttpClientBuilder.sslSocketFactory(config.getSslContext().getSocketFactory());
        }
        if (config.getHostNameVerifier() != null) {
            okHttpClientBuilder.hostnameVerifier(config.getHostNameVerifier());
        }
        if (HttpLoggingFilter.isLoggingEnabled()) {
            okHttpClientBuilder.addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY));
        }
        okHttpClientBuilder.connectionPool(this.getConnectionPool());
        this.client = okHttpClientBuilder.build();
        this.clientReq = new Request.Builder();
        this.populateHeaders(this.request);
        this.populateQueryParams(this.request);
    }

    private ConnectionPool getConnectionPool() {
        int maxIdleConnections = 0;
        int keepAliveDuration = 500;
        return new ConnectionPool(maxIdleConnections, (long)keepAliveDuration, TimeUnit.MILLISECONDS);
    }

    public Response execute() throws Exception {
        RequestBody body = null;
        if (this.request.getEntity() != null) {
            Object content;
            if (InputStream.class.isAssignableFrom(this.request.getEntity().getClass())) {
                content = ByteStreams.toByteArray((InputStream)((InputStream)this.request.getEntity()));
                body = RequestBody.create((MediaType)MediaType.parse((String)this.request.getContentType()), (byte[])content);
            } else {
                content = ObjectMapperSingleton.getContext(this.request.getEntity().getClass()).writer().writeValueAsString(this.request.getEntity());
                body = RequestBody.create((MediaType)MediaType.parse((String)this.request.getContentType()), (String)content);
            }
        } else if (this.request.hasJson()) {
            body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)this.request.getJson());
        }
        if ((this.request.getMethod() == HttpMethod.POST || this.request.getMethod() == HttpMethod.PUT) && body == null) {
            body = RequestBody.create(null, (byte[])Util.EMPTY_BYTE_ARRAY);
        }
        this.clientReq.method(this.request.getMethod().name(), body);
        Call call = this.client.newCall(this.clientReq.build());
        return call.execute();
    }

    public boolean hasEntity() {
        return this.request.getEntity() != null;
    }

    public int getRetries() {
        return this.retries;
    }

    public HttpCommand<R> incrementRetriesAndReturn() {
        this.initialize();
        ++this.retries;
        return this;
    }

    public HttpRequest<R> getRequest() {
        return this.request;
    }

    private void populateQueryParams(HttpRequest<R> request) {
        this.clientReq.url(request.getUrl());
    }

    private void populateHeaders(HttpRequest<R> request) {
        if (!request.hasHeaders()) {
            return;
        }
        for (Map.Entry h : request.getHeaders().entrySet()) {
            this.clientReq.addHeader((String)h.getKey(), String.valueOf(h.getValue()));
        }
    }
}

