/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.senlin.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.senlin.SenlinNodeService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.senlin.ActionID;
import org.openstack4j.model.senlin.Node;
import org.openstack4j.model.senlin.NodeActionCreate;
import org.openstack4j.model.senlin.NodeCreate;
import org.openstack4j.openstack.senlin.domain.SenlinActionID;
import org.openstack4j.openstack.senlin.domain.SenlinNode;
import org.openstack4j.openstack.senlin.internal.BaseSenlinServices;

public class SenlinNodeServiceImpl
extends BaseSenlinServices
implements SenlinNodeService {
    @Override
    public List<? extends Node> list() {
        return this.get(SenlinNode.Node.class, this.uri("/nodes", new Object[0])).execute().getList();
    }

    @Override
    public Node create(NodeCreate newNode) {
        Preconditions.checkNotNull((Object)newNode);
        return this.post(SenlinNode.class, this.uri("/nodes", new Object[0])).entity(newNode).execute();
    }

    @Override
    public Node get(String nodeID) {
        return this.get(nodeID, false);
    }

    @Override
    public Node get(String nodeID, boolean showDetails) {
        Preconditions.checkNotNull((Object)nodeID);
        return this.get(SenlinNode.class, this.uri("/nodes/%s", nodeID)).param("show_details", showDetails).execute();
    }

    @Override
    public ActionResponse delete(String nodeID) {
        Preconditions.checkNotNull((Object)nodeID);
        return this.deleteWithResponse(this.uri("/nodes/%s", nodeID)).execute();
    }

    @Override
    public Node update(String nodeID, NodeCreate newNode) {
        Preconditions.checkNotNull((Object)nodeID);
        Preconditions.checkNotNull((Object)newNode);
        return this.patch(SenlinNode.class, this.uri("/nodes/%s", nodeID)).entity(newNode).execute();
    }

    @Override
    public ActionID action(String nodeID, NodeActionCreate newNodeAction) {
        Preconditions.checkNotNull((Object)nodeID);
        Preconditions.checkNotNull((Object)newNodeAction);
        return this.post(SenlinActionID.class, this.uri("/nodes/%s/actions", nodeID)).entity(newNodeAction).execute();
    }
}

