/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.common.functions;

import com.google.common.base.Function;
import org.openstack4j.openstack.common.functions.RemoveVersionFromURL;

public class EnforceVersionToURL
implements Function<String, String> {
    private static final String VALIDATE = "-VALID-";
    private final String version;
    private boolean onlyIfAbsent;

    private EnforceVersionToURL(String version) {
        this(version, false);
    }

    private EnforceVersionToURL(String version, boolean onlyIfAbsent) {
        this.version = version;
        this.onlyIfAbsent = onlyIfAbsent;
    }

    public static EnforceVersionToURL instance(String version) {
        return new EnforceVersionToURL(version);
    }

    public static EnforceVersionToURL instance(String version, boolean onlyIfAbsent) {
        return new EnforceVersionToURL(version, onlyIfAbsent);
    }

    public String apply(String input) {
        if (this.onlyIfAbsent && input.replaceFirst("/v[0-9]+(\\.[0-9])*", VALIDATE).contains(VALIDATE)) {
            return input;
        }
        return RemoveVersionFromURL.INSTANCE.apply(input).concat(this.version);
    }
}

