/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.api.exceptions;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.openstack4j.api.exceptions.AuthenticationException;
import org.openstack4j.api.exceptions.ClientResponseException;
import org.openstack4j.api.exceptions.OS4JException;
import org.openstack4j.api.exceptions.ServerResponseException;
import org.openstack4j.core.transport.HttpRequest;
import org.openstack4j.core.transport.HttpResponse;

public class ResponseException
extends OS4JException {
    private static final long serialVersionUID = 7294957362769575271L;
    protected int status;
    @Nullable
    protected String requestInfo;
    @Nullable
    protected String requestId;

    public ResponseException(String message, int status) {
        super(message);
        this.status = status;
    }

    public ResponseException(String message, int status, Throwable cause) {
        super(message, cause);
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void setRequestInfo(HttpRequest<?> request) {
        this.requestInfo = (Object)((Object)request.getMethod()) + " " + request.getUrl();
    }

    public void setRequestId(String id) {
        this.requestId = id;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("message", (Object)this.getMessage()).add("status", this.getStatus()).add("X-Openstack-Request-Id", (Object)this.requestId).add("request", (Object)this.requestInfo).toString();
    }

    @Deprecated
    public static ResponseException mapException(String message, int status) {
        return ResponseException.mapException(message, status, null);
    }

    public static ResponseException mapException(String message, int status, Throwable cause) {
        if (status == 401) {
            return new AuthenticationException(message, status, cause);
        }
        if (status >= 400 && status < 499) {
            return new ClientResponseException(message, status, cause);
        }
        if (status >= 500 && status < 600) {
            return new ServerResponseException(message, status, cause);
        }
        return new ResponseException(message, status, cause);
    }

    public static ResponseException mapException(HttpResponse response) {
        return ResponseException.mapException(response, response.getStatusMessage());
    }

    public static ResponseException mapException(HttpResponse response, String message) {
        ResponseException re = ResponseException.mapException(message, response.getStatus(), null);
        re.setRequestId(response.header("X-Openstack-Request-Id"));
        return re;
    }
}

