/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal.ext;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.networking.ext.PortChainService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.ext.PortChain;
import org.openstack4j.openstack.networking.domain.ext.NeutronPortChain;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class PortChainServiceImpl
extends BaseNetworkingServices
implements PortChainService {
    @Override
    public List<? extends PortChain> list() {
        return this.get(NeutronPortChain.PortChains.class, this.uri("/sfc/port_chains", new Object[0])).execute().getList();
    }

    @Override
    public PortChain create(PortChain portChain) {
        Preconditions.checkNotNull((Object)portChain);
        return this.post(NeutronPortChain.class, this.uri("/sfc/port_chains", new Object[0])).entity(portChain).execute();
    }

    @Override
    public ActionResponse delete(String portChainId) {
        Preconditions.checkNotNull((Object)portChainId);
        return this.deleteWithResponse(this.uri("/sfc/port_chains/%s", portChainId)).execute();
    }

    @Override
    public PortChain get(String portChainId) {
        Preconditions.checkNotNull((Object)portChainId);
        return this.get(NeutronPortChain.class, this.uri("/sfc/port_chains/%s", portChainId)).execute();
    }

    @Override
    public PortChain update(String portChainId, PortChain portChain) {
        Preconditions.checkNotNull((Object)portChainId);
        return this.put(NeutronPortChain.class, this.uri("/sfc/port_chains/%s", portChainId)).entity(portChain).execute();
    }
}

