/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.List;
import java.util.Set;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.network.Port;
import org.openstack4j.openstack.networking.domain.NeutronIP;

@JsonRootName(value="port")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronPortCreate
implements ModelEntity {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private String name;
    @JsonProperty(value="admin_state_up")
    private boolean adminStateUp;
    @JsonProperty(value="fixed_ips")
    private Set<NeutronIP> fixedIps;
    @JsonProperty(value="mac_address")
    private String macAddress;
    @JsonProperty(value="network_id")
    private String networkId;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="security_groups")
    private List<String> securityGroups;

    public static NeutronPortCreate fromPort(Port port) {
        NeutronPortCreate c = new NeutronPortCreate();
        c.name = port.getName();
        c.networkId = port.getNetworkId();
        c.adminStateUp = port.isAdminStateUp();
        c.macAddress = port.getMacAddress();
        c.tenantId = port.getTenantId();
        c.securityGroups = port.getSecurityGroups();
        c.fixedIps = port.getFixedIps();
        return c;
    }
}

