/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.common;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.common.AbstractOpenstackEndpoint;
import org.apache.camel.component.openstack.common.OpenstackOperationException;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.common.Payload;
import org.openstack4j.model.common.Payloads;

public abstract class AbstractOpenstackProducer
extends DefaultProducer {
    protected OSClient os;
    private AbstractOpenstackEndpoint endpoint;

    public AbstractOpenstackProducer(AbstractOpenstackEndpoint endpoint, OSClient client) {
        super((Endpoint)endpoint);
        this.os = client;
        this.endpoint = endpoint;
    }

    protected Payload createPayload(Message msg) {
        Payload payload = (Payload)msg.getBody(Payload.class);
        if (ObjectHelper.isNotEmpty((Object)payload)) {
            return payload;
        }
        Object messageBody = msg.getBody();
        if (messageBody instanceof URL) {
            payload = Payloads.create((URL)((URL)messageBody));
        }
        if (messageBody instanceof File) {
            payload = Payloads.create((File)((File)messageBody));
        }
        if (messageBody instanceof InputStream) {
            payload = Payloads.create((InputStream)((InputStream)messageBody));
        }
        if (payload == null) {
            throw new IllegalArgumentException("You have to set payload. It can be InputStream, File or URL class");
        }
        return payload;
    }

    protected String getOperation(Exchange exchange) {
        String operation = (String)exchange.getIn().getHeader("operation", (Object)this.endpoint.getOperation(), String.class);
        StringHelper.notEmpty((String)operation, (String)"Operation");
        return operation;
    }

    protected void checkFailure(ActionResponse response, Exchange exchange, String operation) {
        if (!response.isSuccess()) {
            exchange.setException((Throwable)new OpenstackOperationException(operation, response.getFault(), response.getCode()));
        }
    }
}

