/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Objects;
import java.util.List;
import org.openstack4j.model.network.IPVersionType;
import org.openstack4j.model.network.ext.FirewallRule;
import org.openstack4j.model.network.ext.builder.FirewallRuleBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="firewall_rule")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronFirewallRule
implements FirewallRule {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private String description;
    private Boolean enabled;
    private Boolean shared;
    @JsonProperty(value="firewall_policy_id")
    private String policyId;
    private FirewallRuleAction action;
    @JsonProperty(value="source_ip_address")
    private String sourceIpAddress;
    @JsonProperty(value="destination_ip_address")
    private String destinationIpAddress;
    private Integer position;
    private IPProtocol protocol;
    @JsonProperty(value="ip_version")
    private IPVersionType ipVersion;
    @JsonProperty(value="source_port")
    private String sourcePort;
    @JsonProperty(value="destination_port")
    private String destinationPort;

    @Override
    public FirewallRuleBuilder toBuilder() {
        return new FirewallRuleConcreteBuilder(this);
    }

    public static FirewallRuleBuilder builder() {
        return new FirewallRuleConcreteBuilder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Boolean isShared() {
        return this.shared != null && this.shared != false;
    }

    @Override
    public String getPolicy() {
        return this.policyId;
    }

    @Override
    public IPProtocol getProtocol() {
        return this.protocol;
    }

    @Override
    public IPVersionType getIpVersion() {
        return this.ipVersion;
    }

    @Override
    public String getSourceIpAddress() {
        return this.sourceIpAddress;
    }

    @Override
    public String getDestinationIpAddress() {
        return this.destinationIpAddress;
    }

    @Override
    public String getSourcePort() {
        return this.sourcePort;
    }

    @Override
    public String getDestinationPort() {
        return this.destinationPort;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public FirewallRuleAction getAction() {
        return this.action;
    }

    @Override
    public Boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("position", (Object)this.position).add("action", (Object)this.action).add("ipVersion", (Object)this.ipVersion).add("policyId", (Object)this.policyId).add("enabled", (Object)this.enabled).add("shared", (Object)this.shared).add("tenantId", (Object)this.tenantId).add("sourceIpAddress", (Object)this.sourceIpAddress).add("destinationIpAddress", (Object)this.destinationIpAddress).add("sourcePort", (Object)this.sourcePort).add("destinationPort", (Object)this.destinationPort).add("description", (Object)this.description).add("protocol", (Object)this.protocol).toString();
    }

    public static class FirewallRuleConcreteBuilder
    implements FirewallRuleBuilder {
        NeutronFirewallRule f;

        @Override
        public FirewallRule build() {
            return this.f;
        }

        public FirewallRuleConcreteBuilder() {
            this(new NeutronFirewallRule());
        }

        public FirewallRuleConcreteBuilder(NeutronFirewallRule f) {
            this.f = f;
        }

        @Override
        public FirewallRuleBuilder from(FirewallRule in) {
            this.f = (NeutronFirewallRule)in;
            return this;
        }

        @Override
        public FirewallRuleBuilder tenantId(String tenantId) {
            this.f.tenantId = tenantId;
            return this;
        }

        @Override
        public FirewallRuleBuilder name(String name) {
            this.f.name = name;
            return this;
        }

        @Override
        public FirewallRuleBuilder description(String description) {
            this.f.description = description;
            return this;
        }

        @Override
        public FirewallRuleBuilder shared(Boolean shared) {
            this.f.shared = shared;
            return this;
        }

        @Override
        public FirewallRuleBuilder protocol(IPProtocol protocol) {
            this.f.protocol = protocol;
            return this;
        }

        @Override
        public FirewallRuleBuilder ipVersion(IPVersionType ipVersion) {
            this.f.ipVersion = ipVersion;
            return this;
        }

        @Override
        public FirewallRuleBuilder sourceIpAddress(String sourceIpAddress) {
            this.f.sourceIpAddress = sourceIpAddress;
            return this;
        }

        @Override
        public FirewallRuleBuilder destinationIpAddress(String destinationIpAddress) {
            this.f.destinationIpAddress = destinationIpAddress;
            return this;
        }

        @Override
        public FirewallRuleBuilder sourcePort(String sourcePort) {
            this.f.sourcePort = sourcePort;
            return this;
        }

        @Override
        public FirewallRuleBuilder destinationPort(String destinationPort) {
            this.f.destinationPort = destinationPort;
            return this;
        }

        @Override
        public FirewallRuleBuilder action(FirewallRuleAction action) {
            this.f.action = action;
            return this;
        }

        @Override
        public FirewallRuleBuilder enabled(Boolean enabled) {
            this.f.enabled = enabled;
            return this;
        }
    }

    public static class FirewallRules
    extends ListResult<NeutronFirewallRule> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="firewall_rules")
        List<NeutronFirewallRule> firewallRules;

        @Override
        public List<NeutronFirewallRule> value() {
            return this.firewallRules;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).omitNullValues().add("firewall_rules", this.firewallRules).toString();
        }
    }

    public static enum IPProtocol {
        TCP,
        UDP,
        ICMP,
        UNRECOGNIZED;


        @JsonCreator
        public static IPProtocol value(String v) {
            if (v == null) {
                return UNRECOGNIZED;
            }
            try {
                return IPProtocol.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }
    }

    public static enum FirewallRuleAction {
        ALLOW,
        DENY,
        UNRECOGNIZED;


        @JsonCreator
        public static FirewallRuleAction value(String v) {
            if (v == null) {
                return UNRECOGNIZED;
            }
            try {
                return FirewallRuleAction.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }
    }
}

