/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.domain;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.identity.v3.Domain;
import org.openstack4j.model.identity.v3.Project;
import org.openstack4j.model.identity.v3.builder.ProjectBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.identity.v3.domain.KeystoneDomain;

@JsonRootName(value="project")
@JsonIgnoreProperties(value={"extra"}, ignoreUnknown=true)
public class KeystoneProject
implements Project {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty
    private KeystoneDomain domain;
    @JsonProperty(value="domain_id")
    private String domainId;
    private String description;
    @JsonIgnore
    private Map<String, String> links;
    @JsonProperty(value="parent_id")
    private String parentId;
    private String subtree;
    private String parents;
    private Boolean enabled = true;
    private Map<String, String> extra = new HashMap<String, String>();

    public static ProjectBuilder builder() {
        return new ProjectConcreteBuilder();
    }

    @Override
    public ProjectBuilder toBuilder() {
        return new ProjectConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Domain getDomain() {
        return this.domain;
    }

    @Override
    public String getDomainId() {
        if (this.domainId == null && this.domain != null && this.domain.getId() != null) {
            this.domainId = this.domain.getId();
        }
        return this.domainId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public Map<String, String> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    public void setLinks(Map<String, String> links) {
        this.links = links;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public String getSubtree() {
        return this.subtree;
    }

    @Override
    public String getParents() {
        return this.parents;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    @Override
    public String getExtra(String key) {
        return this.extra.get(key);
    }

    @JsonAnyGetter
    public Map<String, String> getExtra() {
        return this.extra;
    }

    @JsonAnySetter
    public void setExtra(String key, String value) {
        if (Objects.equal((Object)key, (Object)"is_domain")) {
            return;
        }
        this.extra.put(key, value);
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        String domainId = null;
        if (this.domain != null) {
            domainId = this.domain.getId();
        }
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("domainId", (Object)domainId).add("description", (Object)this.description).add("name", (Object)this.name).add("links", this.links).add("parentId", (Object)this.parentId).add("subtree", (Object)this.subtree).add("parents", (Object)this.parents).add("enabled", (Object)this.enabled).omitNullValues().toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.domain.getId(), this.description, this.name, this.links, this.parentId, this.subtree, this.parents});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KeystoneProject that = (KeystoneProject)KeystoneProject.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.domain, (Object)that.domain) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.links, that.links) && Objects.equal((Object)this.parentId, (Object)that.parentId) && Objects.equal((Object)this.subtree, (Object)that.subtree) && Objects.equal((Object)this.parents, (Object)that.parents) && Objects.equal((Object)this.enabled, (Object)that.enabled);
    }

    public static class Projects
    extends ListResult<KeystoneProject> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="projects")
        protected List<KeystoneProject> list;

        @Override
        public List<KeystoneProject> value() {
            return this.list;
        }
    }

    public static class ProjectConcreteBuilder
    implements ProjectBuilder {
        KeystoneProject model;

        ProjectConcreteBuilder() {
            this(new KeystoneProject());
        }

        ProjectConcreteBuilder(KeystoneProject model) {
            this.model = model;
        }

        @Override
        public ProjectBuilder id(String id) {
            this.model.id = id;
            return this;
        }

        @Override
        public ProjectBuilder domain(Domain domain) {
            if (domain != null && domain.getId() != null) {
                this.model.domainId = domain.getId();
            }
            return this;
        }

        @Override
        public ProjectBuilder description(String description) {
            this.model.description = description;
            return this;
        }

        @Override
        public ProjectBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public ProjectBuilder links(Map<String, String> links) {
            this.model.links = links;
            return this;
        }

        @Override
        public ProjectBuilder parentId(String parentId) {
            this.model.parentId = parentId;
            return this;
        }

        @Override
        public ProjectBuilder subtree(String subtree) {
            this.model.subtree = subtree;
            return this;
        }

        @Override
        public ProjectBuilder parents(String parents) {
            this.model.parents = parents;
            return this;
        }

        @Override
        public ProjectBuilder setExtra(String key, String value) {
            this.model.extra.put(key, value);
            return this;
        }

        @Override
        public ProjectBuilder enabled(boolean enabled) {
            this.model.enabled = enabled;
            return this;
        }

        @Override
        public Project build() {
            return this.model;
        }

        @Override
        public ProjectBuilder from(Project in) {
            if (in != null) {
                this.model = (KeystoneProject)in;
            }
            return this;
        }

        @Override
        public ProjectBuilder domainId(String domainId) {
            this.model.domainId = domainId;
            return this;
        }
    }
}

