/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Objects;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.types.Facing;
import org.openstack4j.model.identity.v3.Endpoint;
import org.openstack4j.model.identity.v3.builder.EndpointBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="endpoint")
@JsonIgnoreProperties(ignoreUnknown=true)
public class KeystoneEndpoint
implements Endpoint {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private String id;
    private String type;
    private String description;
    @JsonProperty(value="interface")
    private Facing iface;
    @JsonProperty(value="service_id")
    private String serviceId;
    private String name;
    @JsonProperty
    private String region;
    @JsonProperty(value="region_id")
    private String regionId;
    @JsonProperty
    private URL url;
    private Map<String, String> links;
    private Boolean enabled = true;

    public static EndpointBuilder builder() {
        return new EndpointConcreteBuilder();
    }

    @Override
    public EndpointBuilder toBuilder() {
        return new EndpointConcreteBuilder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Facing getIface() {
        return this.iface;
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public String getRegionId() {
        return this.regionId;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("type", (Object)this.type).add("name", (Object)this.name).add("description", (Object)this.description).add("interface", (Object)this.iface).add("serviceId", (Object)this.serviceId).add("regionId", (Object)this.regionId).add("url", (Object)this.url).add("links", this.links).add("enabled", (Object)this.enabled).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.type, this.name, this.description, this.iface, this.serviceId, this.regionId, this.url, this.links, this.enabled});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KeystoneEndpoint that = (KeystoneEndpoint)KeystoneEndpoint.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)((Object)this.iface), (Object)((Object)that.iface)) && Objects.equal((Object)this.serviceId, (Object)that.serviceId) && Objects.equal((Object)this.regionId, (Object)that.regionId) && Objects.equal((Object)this.url, (Object)that.url) && Objects.equal(this.links, that.links) && Objects.equal((Object)this.enabled, (Object)that.enabled);
    }

    public static class EndpointConcreteBuilder
    implements EndpointBuilder {
        KeystoneEndpoint model;

        EndpointConcreteBuilder() {
            this(new KeystoneEndpoint());
        }

        EndpointConcreteBuilder(KeystoneEndpoint model) {
            this.model = model;
        }

        @Override
        public EndpointBuilder id(String id) {
            this.model.id = id;
            return this;
        }

        @Override
        public EndpointBuilder type(String type) {
            this.model.type = type;
            return this;
        }

        @Override
        public EndpointBuilder description(String description) {
            this.model.description = description;
            return this;
        }

        @Override
        public EndpointBuilder iface(Facing iface) {
            this.model.iface = iface;
            return this;
        }

        @Override
        public EndpointBuilder serviceId(String serviceId) {
            this.model.serviceId = serviceId;
            return this;
        }

        @Override
        public EndpointBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public EndpointBuilder regionId(String regionId) {
            this.model.regionId = regionId;
            return this;
        }

        @Override
        public EndpointBuilder region(String region) {
            this.model.region = region;
            return this;
        }

        @Override
        public EndpointBuilder url(URL url) {
            this.model.url = url;
            return this;
        }

        @Override
        public EndpointBuilder links(Map<String, String> links) {
            this.model.links = links;
            return this;
        }

        @Override
        public EndpointBuilder enabled(boolean enabled) {
            this.model.enabled = enabled;
            return this;
        }

        @Override
        public Endpoint build() {
            return this.model;
        }

        @Override
        public EndpointBuilder from(Endpoint in) {
            this.model = (KeystoneEndpoint)in;
            return this;
        }
    }

    public static class Endpoints
    extends ListResult<KeystoneEndpoint> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="endpoints")
        private List<KeystoneEndpoint> list;

        @Override
        protected List<KeystoneEndpoint> value() {
            return this.list;
        }
    }
}

