/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.compute.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.compute.ComputeFloatingIPService;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.propagation.PropagateOnStatus;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.compute.FloatingIP;
import org.openstack4j.model.compute.Server;
import org.openstack4j.openstack.common.MapEntity;
import org.openstack4j.openstack.compute.domain.NovaFloatingIP;
import org.openstack4j.openstack.compute.domain.NovaFloatingIPPools;
import org.openstack4j.openstack.compute.domain.actions.FloatingIpActions;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.compute.internal.BaseComputeServices;

public class ComputeFloatingIPServiceImpl
extends BaseComputeServices
implements ComputeFloatingIPService {
    @Override
    public List<? extends FloatingIP> list() {
        return this.get(NovaFloatingIP.NovaFloatingIPs.class, this.uri("/os-floating-ips", new Object[0])).execute().getList();
    }

    @Override
    public List<String> getPoolNames() {
        return this.get(NovaFloatingIPPools.class, this.uri("/os-floating-ip-pools", new Object[0])).execute().getList();
    }

    @Override
    public FloatingIP allocateIP(String pool) {
        return this.post(NovaFloatingIP.class, this.uri("/os-floating-ips", new Object[0])).entity(MapEntity.create("pool", pool)).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    @Override
    public ActionResponse deallocateIP(String id) {
        Preconditions.checkNotNull((Object)id);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/os-floating-ips/%s", id)).executeWithResponse());
    }

    @Override
    public ActionResponse addFloatingIP(Server server, String fixedIpAddress, String ipAddress) {
        Preconditions.checkNotNull((Object)server);
        Preconditions.checkNotNull((Object)ipAddress);
        return this.invokeAction(server.getId(), FloatingIpActions.Add.create(ipAddress, fixedIpAddress));
    }

    @Override
    public ActionResponse addFloatingIP(Server server, String ipAddress) {
        return this.addFloatingIP(server, null, ipAddress);
    }

    @Override
    public ActionResponse removeFloatingIP(Server server, String ipAddress) {
        Preconditions.checkNotNull((Object)server);
        Preconditions.checkNotNull((Object)ipAddress);
        return this.invokeAction(server.getId(), FloatingIpActions.Remove.create(ipAddress));
    }
}

