/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.connectors.okhttp;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.Response;
import org.openstack4j.api.exceptions.ClientResponseException;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.HttpEntityHandler;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.core.transport.ObjectMapperSingleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseImpl
implements HttpResponse {
    private static final Logger LOG = LoggerFactory.getLogger(HttpResponseImpl.class);
    private final Response response;

    private HttpResponseImpl(Response response) {
        this.response = response;
    }

    public static HttpResponseImpl wrap(Response response) {
        return new HttpResponseImpl(response);
    }

    public Response unwrap() {
        return this.response;
    }

    public <T> T getEntity(Class<T> returnType) {
        return this.getEntity(returnType, null);
    }

    public <T> T getEntity(Class<T> returnType, ExecutionOptions<T> options) {
        return (T)HttpEntityHandler.handle((HttpResponse)this, returnType, options, (boolean)Boolean.TRUE);
    }

    public int getStatus() {
        return this.response.code();
    }

    public String getStatusMessage() {
        return this.response.message();
    }

    public InputStream getInputStream() {
        return this.response.body().byteStream();
    }

    public String header(String name) {
        return this.response.header(name);
    }

    public Map<String, String> headers() {
        HashMap<String, String> retHeaders = new HashMap<String, String>();
        Headers headers = this.response.headers();
        for (String name : headers.names()) {
            retHeaders.put(name, headers.get(name));
        }
        return retHeaders;
    }

    public <T> T readEntity(Class<T> typeToReadAs) {
        try {
            return (T)ObjectMapperSingleton.getContext(typeToReadAs).reader(typeToReadAs).readValue(this.response.body().string());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new ClientResponseException(e.getMessage(), 0, (Throwable)e);
        }
    }

    public void close() throws IOException {
    }

    public String getContentType() {
        return this.header("Content-Type");
    }
}

