/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.PollEnrichDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.processor.PollEnricher;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.support.DefaultExchange;

public class PollEnrichReifier
extends ProcessorReifier<PollEnrichDefinition> {
    public PollEnrichReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (PollEnrichDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Integer num;
        PollEnricher enricher;
        Expression exp;
        long time = this.parseDuration(((PollEnrichDefinition)this.definition).getTimeout(), -1L);
        boolean isIgnoreInvalidEndpoint = this.parseBoolean(((PollEnrichDefinition)this.definition).getIgnoreInvalidEndpoint(), false);
        if (((PollEnrichDefinition)this.definition).getExpression() instanceof ConstantExpression) {
            exp = this.createExpression(((PollEnrichDefinition)this.definition).getExpression());
            DefaultExchange ex = new DefaultExchange(this.camelContext);
            String dest = (String)exp.evaluate((Exchange)ex, String.class);
            enricher = new PollEnricher(dest, time);
        } else {
            exp = this.createExpression(((PollEnrichDefinition)this.definition).getExpression());
            enricher = new PollEnricher(exp, time);
        }
        AggregationStrategy strategy = this.createAggregationStrategy();
        if (strategy == null) {
            enricher.setDefaultAggregationStrategy();
        } else {
            enricher.setAggregationStrategy(strategy);
        }
        if (((PollEnrichDefinition)this.definition).getAggregateOnException() != null) {
            enricher.setAggregateOnException(this.parseBoolean(((PollEnrichDefinition)this.definition).getAggregateOnException(), false));
        }
        if ((num = this.parseInt(((PollEnrichDefinition)this.definition).getCacheSize())) != null) {
            enricher.setCacheSize(num.intValue());
        }
        enricher.setIgnoreInvalidEndpoint(isIgnoreInvalidEndpoint);
        return enricher;
    }

    private AggregationStrategy createAggregationStrategy() {
        AggregationStrategy strategy = ((PollEnrichDefinition)this.definition).getAggregationStrategy();
        String ref = this.parseString(((PollEnrichDefinition)this.definition).getAggregationStrategyRef());
        if (strategy == null && ref != null) {
            Object aggStrategy = this.lookup(ref, Object.class);
            if (aggStrategy instanceof AggregationStrategy) {
                strategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy != null) {
                AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(aggStrategy, this.parseString(((PollEnrichDefinition)this.definition).getAggregationStrategyMethodName()));
                if (((PollEnrichDefinition)this.definition).getAggregationStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(this.parseBoolean(((PollEnrichDefinition)this.definition).getAggregationStrategyMethodAllowNull(), false));
                    adapter.setAllowNullOldExchange(this.parseBoolean(((PollEnrichDefinition)this.definition).getAggregationStrategyMethodAllowNull(), false));
                }
                strategy = adapter;
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + ((PollEnrichDefinition)this.definition).getAggregationStrategyRef());
            }
        }
        if (strategy instanceof CamelContextAware) {
            ((CamelContextAware)strategy).setCamelContext(this.camelContext);
        }
        return strategy;
    }
}

