/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.storage.block;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openstack4j.common.Buildable;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.storage.block.VolumeAttachment;
import org.openstack4j.model.storage.block.builder.VolumeBuilder;
import org.slf4j.LoggerFactory;

public interface Volume
extends ModelEntity,
Buildable<VolumeBuilder> {
    public String getId();

    public String getName();

    @Deprecated
    public String getDisplayName();

    public String getDescription();

    @Deprecated
    public String getDisplayDescription();

    public Status getStatus();

    public int getSize();

    public String getZone();

    public Date getCreated();

    public String getVolumeType();

    public String getSnapshotId();

    public String getImageRef();

    public Boolean multiattach();

    public String getSourceVolid();

    public Map<String, String> getMetaData();

    public List<? extends VolumeAttachment> getAttachments();

    public MigrationStatus getMigrateStatus();

    public String getTenantId();

    public boolean bootable();

    public boolean encrypted();

    public String host();

    public static enum MigrationStatus {
        NONE,
        MIGRATING;


        @JsonValue
        public String value() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
        }

        public String toString() {
            return this.value();
        }

        @JsonCreator
        public static MigrationStatus fromValue(String migrationStatus) {
            if (migrationStatus != null) {
                try {
                    return MigrationStatus.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)migrationStatus, (Object)"migrationStatus")));
                }
                catch (IllegalArgumentException e) {
                    LoggerFactory.getLogger(MigrationStatus.class).error(e.getMessage(), (Throwable)e);
                }
            }
            return NONE;
        }
    }

    public static enum Status {
        AVAILABLE,
        ATTACHING,
        BACKING_UP,
        CREATING,
        DELETING,
        DOWNLOADING,
        UPLOADING,
        ERROR,
        ERROR_DELETING,
        ERROR_RESTORING,
        IN_USE,
        RESTORING_BACKUP,
        DETACHING,
        UNRECOGNIZED;


        @JsonValue
        public String value() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
        }

        public String toString() {
            return this.value();
        }

        @JsonCreator
        public static Status fromValue(String status) {
            try {
                return Status.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)status, (Object)"status")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

