/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.sahara.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.sahara.JobService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.sahara.Job;
import org.openstack4j.model.sahara.JobConfigHint;
import org.openstack4j.openstack.sahara.domain.SaharaJob;
import org.openstack4j.openstack.sahara.domain.SaharaJobConfigHint;
import org.openstack4j.openstack.sahara.domain.SaharaJobUnwrapped;
import org.openstack4j.openstack.sahara.internal.BaseSaharaServices;

public class JobServiceImpl
extends BaseSaharaServices
implements JobService {
    @Override
    public List<? extends Job> list() {
        return this.get(SaharaJob.Jobs.class, this.uri("/jobs", new Object[0])).execute().getList();
    }

    @Override
    public Job get(String JobId) {
        Preconditions.checkNotNull((Object)JobId);
        return this.get(SaharaJob.class, this.uri("/jobs/%s", JobId)).execute();
    }

    @Override
    public Job create(Job job) {
        Preconditions.checkNotNull((Object)job);
        SaharaJobUnwrapped unwrapped = new SaharaJobUnwrapped(job);
        return this.post(SaharaJob.class, this.uri("/jobs", new Object[0])).entity(unwrapped).execute();
    }

    @Override
    public ActionResponse delete(String JobId) {
        Preconditions.checkNotNull((Object)JobId);
        return this.deleteWithResponse(this.uri("/jobs/%s", JobId)).execute();
    }

    @Override
    public JobConfigHint getConfigHint(String type) {
        Preconditions.checkNotNull((Object)type);
        return this.get(SaharaJobConfigHint.class, this.uri("/jobs/config-hints/%s", type)).execute();
    }
}

