/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.math.BigInteger;
import org.openstack4j.model.network.IPVersionType;
import org.openstack4j.model.network.ext.SubnetIPAvailability;
import org.openstack4j.model.network.ext.builder.SubnetIPAvailabilityBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronSubnetIPAvailability
implements SubnetIPAvailability {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="used_ips")
    private BigInteger usedIps;
    @JsonProperty(value="total_ips")
    private BigInteger totalIps;
    @JsonProperty(value="subnet_id")
    private String subnetId;
    @JsonProperty(value="subnet_name")
    private String subnetName;
    @JsonProperty(value="ip_version")
    private IPVersionType ipVersion;
    @JsonProperty(value="cidr")
    private String cidr;

    public NeutronSubnetIPAvailability() {
    }

    public NeutronSubnetIPAvailability(BigInteger usedIps, BigInteger totalIps, String subnetId, String subnetName, IPVersionType ipVersion, String cidr) {
        this.usedIps = usedIps;
        this.totalIps = totalIps;
        this.subnetId = subnetId;
        this.subnetName = subnetName;
        this.ipVersion = ipVersion;
        this.cidr = cidr;
    }

    public static SubnetIPAvailabilityBuilder builder() {
        return new SubnetIPAvailabilityConcreteBuilder();
    }

    @Override
    public SubnetIPAvailabilityBuilder toBuilder() {
        return new SubnetIPAvailabilityConcreteBuilder(this);
    }

    @Override
    public BigInteger getUsedIps() {
        return this.usedIps;
    }

    @Override
    public BigInteger getTotalIps() {
        return this.totalIps;
    }

    @Override
    public String getSubnetId() {
        return this.subnetId;
    }

    @Override
    public String getSubnetName() {
        return this.subnetName;
    }

    @Override
    public IPVersionType getIpVersion() {
        return this.ipVersion;
    }

    @Override
    public String getCidr() {
        return this.cidr;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("usedIps", (Object)this.usedIps).add("totalIps", (Object)this.totalIps).add("subnetId", (Object)this.subnetId).add("subnetName", (Object)this.subnetName).add("ipVersion", (Object)this.ipVersion).add("cidr", (Object)this.cidr).toString();
    }

    public static class SubnetIPAvailabilityConcreteBuilder
    implements SubnetIPAvailabilityBuilder {
        NeutronSubnetIPAvailability model;

        public SubnetIPAvailabilityConcreteBuilder() {
            this.model = new NeutronSubnetIPAvailability();
        }

        public SubnetIPAvailabilityConcreteBuilder(NeutronSubnetIPAvailability model) {
            this.model = model;
        }

        @Override
        public SubnetIPAvailability build() {
            return this.model;
        }

        @Override
        public SubnetIPAvailabilityBuilder from(SubnetIPAvailability in) {
            return new SubnetIPAvailabilityConcreteBuilder((NeutronSubnetIPAvailability)in);
        }

        @Override
        public SubnetIPAvailabilityBuilder subnetName(String subnetName) {
            this.model.subnetName = subnetName;
            return this;
        }

        @Override
        public SubnetIPAvailabilityBuilder subnetId(String subnetId) {
            this.model.subnetId = subnetId;
            return this;
        }

        @Override
        public SubnetIPAvailabilityBuilder tenantId(IPVersionType ipVersion) {
            this.model.ipVersion = ipVersion;
            return this;
        }

        @Override
        public SubnetIPAvailabilityBuilder cidr(String cidr) {
            this.model.cidr = cidr;
            return this;
        }

        @Override
        public SubnetIPAvailabilityBuilder totalIps(BigInteger totalIps) {
            this.model.totalIps = totalIps;
            return this;
        }

        @Override
        public SubnetIPAvailabilityBuilder usedIps(BigInteger usedIps) {
            this.model.usedIps = usedIps;
            return this;
        }
    }
}

