/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.network.ext.PortPair;
import org.openstack4j.model.network.ext.builder.PortPairBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="port_pair")
public class NeutronPortPair
implements PortPair {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty(value="project_id")
    private String projectId;
    @JsonProperty
    private String description;
    @JsonProperty(value="egress")
    private String egressId;
    @JsonProperty(value="ingress")
    private String ingressId;
    @JsonProperty(value="service_function_parameters")
    Map<String, String> serviceFunctionParameters;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @JsonIgnore
    public String getTenantId() {
        return this.projectId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.projectId = tenantId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getEgressId() {
        return this.egressId;
    }

    public void setEgressId(String egressId) {
        this.egressId = egressId;
    }

    @Override
    public String getIngressId() {
        return this.ingressId;
    }

    public void setIngressId(String ingressId) {
        this.ingressId = ingressId;
    }

    @Override
    public Map<String, String> getServiceFunctionParameters() {
        return this.serviceFunctionParameters;
    }

    public void setServiceFunctionParameters(Map<String, String> serviceFunctionParameters) {
        this.serviceFunctionParameters = serviceFunctionParameters;
    }

    @Override
    public PortPairBuilder toBuilder() {
        return new PortPairConcreteBuilder(this);
    }

    public static PortPairBuilder builder() {
        return new PortPairConcreteBuilder();
    }

    public static class PortPairConcreteBuilder
    implements PortPairBuilder {
        private NeutronPortPair neutronPortPair;

        public PortPairConcreteBuilder() {
            this.neutronPortPair = new NeutronPortPair();
        }

        public PortPairConcreteBuilder(NeutronPortPair neutronPortPair) {
            this.neutronPortPair = neutronPortPair;
        }

        @Override
        public PortPair build() {
            return this.neutronPortPair;
        }

        @Override
        public PortPairBuilder from(PortPair in) {
            this.neutronPortPair = (NeutronPortPair)in;
            return this;
        }

        @Override
        public PortPairBuilder id(String id) {
            this.neutronPortPair.id = id;
            return this;
        }

        @Override
        public PortPairBuilder name(String name) {
            this.neutronPortPair.name = name;
            return this;
        }

        @Override
        public PortPairBuilder projectId(String projectId) {
            this.neutronPortPair.projectId = projectId;
            return this;
        }

        @Override
        public PortPairBuilder description(String description) {
            this.neutronPortPair.description = description;
            return this;
        }

        @Override
        public PortPairBuilder egressId(String egressId) {
            this.neutronPortPair.egressId = egressId;
            return this;
        }

        @Override
        public PortPairBuilder ingressId(String ingressId) {
            this.neutronPortPair.ingressId = ingressId;
            return this;
        }

        @Override
        public PortPairBuilder serviceFunctionParameters(Map<String, String> serviceFunctionParameters) {
            this.neutronPortPair.serviceFunctionParameters = serviceFunctionParameters;
            return this;
        }
    }

    public static class PortPairs
    extends ListResult<NeutronPortPair> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="port_pairs")
        private List<NeutronPortPair> portPairs;

        @Override
        public List<NeutronPortPair> value() {
            return this.portPairs;
        }
    }
}

