/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.image.v2.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonpatch.diff.JsonDiff;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.openstack4j.api.Apis;
import org.openstack4j.api.exceptions.ResponseException;
import org.openstack4j.api.image.v2.ImageService;
import org.openstack4j.api.image.v2.TaskService;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.core.transport.propagation.PropagateOnStatus;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.common.Payload;
import org.openstack4j.model.image.v2.CachedImage;
import org.openstack4j.model.image.v2.Image;
import org.openstack4j.model.image.v2.ImageUpdate;
import org.openstack4j.model.image.v2.Member;
import org.openstack4j.openstack.image.v2.domain.CachedGlanceImage;
import org.openstack4j.openstack.image.v2.domain.GlanceImage;
import org.openstack4j.openstack.image.v2.domain.GlanceImageUpdate;
import org.openstack4j.openstack.image.v2.domain.GlanceMember;
import org.openstack4j.openstack.image.v2.internal.BaseImageServices;
import org.openstack4j.openstack.internal.BaseOpenStackService;

public class ImageServiceImpl
extends BaseImageServices
implements ImageService {
    @Override
    public List<? extends Image> list() {
        return this.get(GlanceImage.Images.class, this.uri("/images", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Image> list(Map<String, String> filteringParams) {
        return this.get(GlanceImage.Images.class, this.uri("/images", new Object[0])).params(filteringParams).execute().getList();
    }

    @Override
    public List<? extends CachedImage> listCachedImages() {
        try {
            return this.get(CachedGlanceImage.CachedImages.class, this.uri("/cached_images", new Object[0])).execute(ExecutionOptions.create(PropagateOnStatus.on(404))).getList();
        }
        catch (ResponseException e) {
            return null;
        }
    }

    @Override
    public Image get(String imageId) {
        Preconditions.checkNotNull((Object)imageId);
        return this.get(GlanceImage.class, this.uri("/images/%s", imageId)).execute();
    }

    @Override
    public Image create(Image image) {
        Preconditions.checkNotNull((Object)image);
        return this.post(GlanceImage.class, this.uri("/images", new Object[0])).entity(image).execute();
    }

    @Override
    public Image update(Image image) {
        Preconditions.checkNotNull((Object)image);
        ObjectMapper objectMapper = new ObjectMapper();
        Image origImage = this.get(image.getId());
        try {
            String oImg = objectMapper.writeValueAsString((Object)origImage);
            ObjectNode origJson = (ObjectNode)objectMapper.readTree(oImg);
            String img = objectMapper.writeValueAsString((Object)image);
            ObjectNode newJson = (ObjectNode)objectMapper.readTree(img);
            JsonNode jsonDiff = JsonDiff.asJson((JsonNode)origJson, (JsonNode)newJson);
            GlanceImageUpdate giu = new GlanceImageUpdate(jsonDiff);
            return this.update(image.getId(), giu);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Image update(String imageId, ImageUpdate imageUpdate) {
        Preconditions.checkNotNull((Object)imageId);
        Preconditions.checkNotNull((Object)imageUpdate);
        return this.patch(GlanceImage.class, this.uri("/images/%s", imageId)).header("Content-Type", "application/openstack-images-v2.1-json-patch").entity(imageUpdate).execute();
    }

    @Override
    public ActionResponse delete(String imageId) {
        Preconditions.checkNotNull((Object)imageId);
        return this.deleteWithResponse(this.uri("/images/%s", imageId)).param("format", "json").execute();
    }

    @Override
    public ActionResponse deactivate(String imageId) {
        Preconditions.checkNotNull((Object)imageId);
        return this.post(ActionResponse.class, this.uri("/images/%s/actions/deactivate", imageId)).execute();
    }

    @Override
    public ActionResponse reactivate(String imageId) {
        Preconditions.checkNotNull((Object)imageId);
        return this.post(ActionResponse.class, this.uri("/images/%s/actions/reactivate", imageId)).execute();
    }

    @Override
    public ActionResponse upload(String imageId, Payload<?> payload, @Nullable Image image) {
        Preconditions.checkNotNull((Object)imageId);
        Preconditions.checkNotNull(payload);
        return this.put(ActionResponse.class, this.uri("/images/%s/file", imageId)).header("Content-Type", "application/octet-stream").entity(payload).execute();
    }

    @Override
    public ActionResponse download(String imageId, File filename) {
        Preconditions.checkNotNull((Object)imageId);
        Preconditions.checkNotNull((Object)filename);
        HttpResponse response = this.get(Void.class, this.uri("/images/%s/file", imageId)).header("Accept", "application/octet-stream").executeWithResponse();
        if (response.getStatus() < 400) {
            InputStream inputStream = response.getInputStream();
            try {
                int bytesRead;
                FileOutputStream outputStream = new FileOutputStream(filename);
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                }
                inputStream.close();
                outputStream.flush();
                ((OutputStream)outputStream).close();
                return ActionResponse.actionSuccess();
            }
            catch (Exception e) {
                e.printStackTrace();
                return ActionResponse.actionFailed("Failed to write to file " + e.getMessage(), 400);
            }
        }
        return null;
    }

    @Override
    public ActionResponse updateTag(String imageId, String tag) {
        Preconditions.checkNotNull((Object)imageId);
        Preconditions.checkNotNull((Object)tag);
        return this.put(ActionResponse.class, this.uri("/images/%s/tags/%s", imageId, tag)).execute();
    }

    @Override
    public ActionResponse deleteTag(String imageId, String tag) {
        Preconditions.checkNotNull((Object)imageId);
        Preconditions.checkNotNull((Object)tag);
        return this.deleteWithResponse(this.uri("/images/%s/tags/%s", imageId, tag)).execute();
    }

    @Override
    public List<? extends Member> listMembers(String imageId) {
        Preconditions.checkNotNull((Object)imageId);
        return this.get(GlanceMember.Members.class, this.uri("/images/%s/members", imageId)).execute().getList();
    }

    @Override
    public List<? extends Member> listMembers(String imageId, Map<String, String> filteringParams) {
        Preconditions.checkNotNull((Object)imageId);
        BaseOpenStackService.Invocation<GlanceMember.Members> req = this.get(GlanceMember.Members.class, this.uri("/images/%s/members", imageId));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public Member getMember(String imageId, String memberId) {
        Preconditions.checkNotNull((Object)imageId);
        Preconditions.checkNotNull((Object)memberId);
        return this.get(Member.class, this.uri("/images/%s/members/%s", imageId, memberId)).execute();
    }

    @Override
    public Member createMember(String imageId, String memberId) {
        Preconditions.checkNotNull((Object)imageId);
        Preconditions.checkNotNull((Object)memberId);
        return this.post(Member.class, this.uri("/images/%s/members", imageId)).entity(new GlanceMember(memberId)).execute();
    }

    @Override
    public Member updateMember(String imageId, String memberId, Member.MemberStatus memberStatus) {
        Preconditions.checkNotNull((Object)imageId);
        Preconditions.checkNotNull((Object)memberId);
        return this.put(Member.class, this.uri("/images/%s/members/%s", imageId, memberId)).entity(new GlanceMember(memberStatus)).execute();
    }

    @Override
    public ActionResponse deleteMember(String imageId, String memberId) {
        Preconditions.checkNotNull((Object)imageId);
        Preconditions.checkNotNull((Object)memberId);
        return this.deleteWithResponse(this.uri("/images/%s/members/%s", imageId, memberId)).execute();
    }

    @Override
    public TaskService tasks() {
        return Apis.get(TaskService.class);
    }
}

