/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.telemetry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import java.util.Map;
import org.openstack4j.common.Buildable;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.common.BasicResource;
import org.openstack4j.model.telemetry.builder.AlarmBuilder;
import org.openstack4j.openstack.telemetry.domain.CeilometerAlarm;

public interface Alarm
extends ModelEntity,
BasicResource,
Buildable<AlarmBuilder> {
    public List<String> getAlarmActions();

    public String getAlarmId();

    public String getDescription();

    public boolean isEnabled();

    public void isEnabled(boolean var1);

    public List<String> getInsufficientDataActions();

    @Override
    public String getName();

    public List<String> getOkActions();

    public String getProjectId();

    public boolean getRepeatActions();

    public String getState();

    public String getStateTimestamp();

    public ThresholdRule getThresholdRule();

    public CombinationRule getCombinationRule();

    public Map<String, Object> getCompositeRule();

    public GnocchiResourcesThresholdRule getGnocchiResourcesThresholdRule();

    public GnocchiAggregationByMetricsThresholdRule getGnocchiAggregationByMetricsThresholdRule();

    public GnocchiAggregationByResourcesThresholdRule getGnocchiAggregationByResourcesThresholdRule();

    public String getTimestamp();

    public Type getType();

    public String getUserId();

    @Override
    public void setName(String var1);

    public void setType(Type var1);

    public void setUserId(String var1);

    public void setAlarmActions(List<String> var1);

    public void setDescription(String var1);

    public void setInsufficientDataActions(List<String> var1);

    public void setOkActions(List<String> var1);

    public void setRepeateActions(Boolean var1);

    public void setThresholdRule(CeilometerAlarm.CeilometerThresholdRule var1);

    public void setGnocchiResourcesThresholdRule(CeilometerAlarm.CeilometerGnocchiResourcesThresholdRule var1);

    public void setGnocchiAggregationByMetricsThresholdRule(CeilometerAlarm.CeilometerGnocchiAggregationByMetricsThresholdRule var1);

    public void setGnocchiAggregationByResourcesThresholdRule(CeilometerAlarm.CeilometerGnocchiAggregationByResourcesThresholdRule var1);

    public static interface AlarmChange {
        public String getAlarmId();

        public String getDetail();

        public String getEventId();

        public String getOnBehalfOf();

        public String getProjectId();

        public String getTimestamp();

        public ChangeType getChangeType();

        public String getUserId();

        public void setAlarmId(String var1);

        public void setDetail(String var1);

        public void setEventId(String var1);

        public void setOnBehalfOf(String var1);

        public void setProjectId(String var1);

        public void setTimestamp(String var1);

        public void setChangeType(ChangeType var1);

        public void setUserId(String var1);

        public static enum ChangeType {
            CREATION,
            RULE_CHANGE,
            STATE_TRANSITION,
            DELETION,
            UNRECOGNIZED;


            @JsonValue
            public String value() {
                return this.name().toLowerCase();
            }

            public String toString() {
                return this.value();
            }

            @JsonCreator
            public static ChangeType fromValue(String type) {
                try {
                    return ChangeType.valueOf(type.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    return UNRECOGNIZED;
                }
            }
        }
    }

    public static interface AlarmTimeConstraint {
        public String getDescription();

        public int getDuration();

        public String getName();

        public String getStart();

        public String getTimezone();

        public void setDescription(String var1);

        public void setDuration(int var1);

        public void setName(String var1);

        public void setStart(String var1);

        public void setTimezone(String var1);
    }

    public static interface AggregationMetricsByIdLookupRule {
        public String getMetric();

        public void setMetric(String var1);
    }

    public static interface AggregationMetricByResourcesLookupRule {
        public String getMetric();

        public String getResourceType();

        public void setMetric(String var1);

        public void setResourceType(String var1);
    }

    public static interface MetricOfResourceRule {
        public String getMetric();

        public String getResourceId();

        public String getResourceType();

        public void setMetric(String var1);

        public void setResourceId(String var1);

        public void setResourceType(String var1);
    }

    public static interface GnocchiEvent {
    }

    public static interface GnocchiAggregationByResourcesThresholdRule {
        public String getMetric();

        public String getResourceType();

        public ComparisonOperator getComparisonOperator();

        public AggregationMethod getAggregationMethod();

        public int getEvaluationPeriods();

        public float getThreshold();

        public long getGranularity();

        public Query getQuery();

        public void setMetric(String var1);

        public void setResourceType(String var1);

        public void setComparisonOperator(ComparisonOperator var1);

        public void setAggregationMethod(AggregationMethod var1);

        public void setEvaluationPeriods(int var1);

        public void setThreshold(float var1);

        public void setGranularity(long var1);

        public void setQuery(CeilometerAlarm.CeilometerQuery var1);
    }

    public static interface GnocchiAggregationByMetricsThresholdRule {
        public List<String> getMetrics();

        public ComparisonOperator getComparisonOperator();

        public AggregationMethod getAggregationMethod();

        public float getThreshold();

        public int getEvaluationPeriods();

        public long getGranularity();

        public void setMetrics(List<String> var1);

        public void setComparisonOperator(ComparisonOperator var1);

        public void setAggregationMethod(AggregationMethod var1);

        public void setThreshold(float var1);

        public void setEvaluationPeriods(int var1);

        public void setGranularity(long var1);
    }

    public static interface GnocchiResourcesThresholdRule {
        public String getMetric();

        public String getResourceId();

        public String getResourceType();

        public ComparisonOperator getComparisonOperator();

        public AggregationMethod getAggregationMethod();

        public int getEvaluationPeriods();

        public float getThreshold();

        public long getGranularity();

        public void setMetric(String var1);

        public void setResourceId(String var1);

        public void setResourceType(String var1);

        public void setComparisonOperator(ComparisonOperator var1);

        public void setAggregationMethod(AggregationMethod var1);

        public void setEvaluationPeriods(int var1);

        public void setThreshold(float var1);

        public void setGranularity(long var1);
    }

    public static interface Query {
        public String getField();

        public String getValue();

        public ComparisonOperator getOp();

        public void setField(String var1);

        public void setValue(String var1);

        public void setOp(ComparisonOperator var1);
    }

    public static interface ThresholdRule {
        public String getMeterName();

        public int getEvaluationPeriods();

        public Statistic getStatistic();

        public int getPeriod();

        public float getThreshold();

        public List<? extends Query> getQuery();

        public ComparisonOperator getComparisonOperator();

        public boolean getExcludeOutliers();

        public void setMeterName(String var1);

        public void setEvaluationPeriods(int var1);

        public void setStatistic(Statistic var1);

        public void setPeriod(int var1);

        public void setThreshold(float var1);

        public void setQuery(List<CeilometerAlarm.CeilometerQuery> var1);

        public void setComparisonOperator(ComparisonOperator var1);

        public void setExcludeOutliers(boolean var1);
    }

    public static interface CombinationRule {
        public List<String> getAlarmIds();

        public Operator getOperator();

        public void setAlarmIds(List<String> var1);

        public void setOperator(Operator var1);
    }

    public static enum AggregationMethod {
        COUNT,
        MAX,
        SUM,
        MIN,
        MEAN,
        UNRECOGNIZED;


        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.value();
        }

        @JsonCreator
        public static AggregationMethod fromValue(String method) {
            try {
                return AggregationMethod.valueOf(method.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum Operator {
        AND,
        OR,
        UNRECOGNIZED;


        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.value();
        }

        @JsonCreator
        public static Operator fromValue(String operator) {
            try {
                return Operator.valueOf(operator.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum ComparisonOperator {
        LT,
        LE,
        EQ,
        NE,
        GE,
        GT,
        UNRECOGNIZED;


        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.value();
        }

        @JsonCreator
        public static ComparisonOperator fromValue(String operator) {
            try {
                return ComparisonOperator.valueOf(operator.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum Statistic {
        MAX,
        MIN,
        AVG,
        SUM,
        COUNT,
        UNRECOGNIZED;


        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.value();
        }

        @JsonCreator
        public static Statistic fromValue(String statistic) {
            try {
                return Statistic.valueOf(statistic.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum Type {
        GNOCCHI_AGGREGATION_BY_METRICS_THRESHOLD,
        COMPOSITE,
        GNOCCHI_RESOURCES_THRESHOLD,
        GNOCCHI_AGGREGATION_BY_RESOURCES_THRESHOLD,
        THRESHOLD,
        EVENT,
        COMBINATION,
        UNRECOGNIZED;


        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.value();
        }

        @JsonCreator
        public static Type fromValue(String type) {
            try {
                return Type.valueOf(type.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

