/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.core.transport;

import java.io.IOException;
import org.openstack4j.api.exceptions.ResponseException;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.Handle;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.core.transport.ListType;
import org.openstack4j.core.transport.functions.ResponseToActionResponse;
import org.openstack4j.model.common.ActionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpEntityHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpEntityHandler.class);

    public static <T> T handle(HttpResponse response, Class<T> returnType, ExecutionOptions<T> options) {
        return HttpEntityHandler.handle(response, returnType, options, Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T handle(HttpResponse response, Class<T> returnType, ExecutionOptions<T> options, boolean requiresVoidBodyHandling) {
        try {
            Handle<T> handle = Handle.create(response, returnType, options, requiresVoidBodyHandling);
            if (response.getStatus() >= 400) {
                if (requiresVoidBodyHandling && ActionResponse.class == returnType) {
                    ActionResponse actionResponse = ResponseToActionResponse.INSTANCE.apply(response);
                    return (T)actionResponse;
                }
                if (options != null) {
                    options.propagate(response);
                }
                if (HttpEntityHandler.handle404(handle).isComplete()) {
                    T t = handle.getReturnObject();
                    return t;
                }
                if (HttpEntityHandler.handleLessThan500(handle).isComplete()) {
                    T t = handle.getReturnObject();
                    return t;
                }
                throw ResponseException.mapException(response);
            }
            if (options != null && options.hasParser()) {
                Object object = options.getParser().apply((Object)response);
                return (T)object;
            }
            if (returnType == Void.class) {
                T t = null;
                return t;
            }
            if (returnType == ActionResponse.class) {
                ActionResponse actionResponse = ActionResponse.actionSuccess(response.getStatus());
                return (T)actionResponse;
            }
            T t = response.readEntity(returnType);
            return t;
        }
        finally {
            HttpEntityHandler.closeQuietly(response);
        }
    }

    private static <T> Handle<T> handle404(Handle<T> handle) {
        if (handle.getResponse().getStatus() == 404) {
            if (ListType.class.isAssignableFrom(handle.getReturnType())) {
                try {
                    return handle.complete(handle.getReturnType().newInstance());
                }
                catch (InstantiationException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            if (handle.getReturnType() != ActionResponse.class) {
                return handle.complete(null);
            }
        }
        return handle.continueHandling();
    }

    private static <T> Handle<T> handleLessThan500(Handle<T> handle) {
        if (handle.getResponse().getStatus() < 500) {
            try {
                ActionResponse ar = ResponseToActionResponse.INSTANCE.apply(handle.getResponse());
                if (handle.getReturnType() == ActionResponse.class) {
                    return handle.complete(ar);
                }
                throw ResponseException.mapException(handle.getResponse(), ar.getFault());
            }
            catch (ResponseException re) {
                throw re;
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return handle.continueHandling();
    }

    public static void closeQuietly(HttpResponse response) {
        try {
            response.close();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public static int statusAndClose(HttpResponse response) {
        int status = response.getStatus();
        HttpEntityHandler.closeQuietly(response);
        return status;
    }
}

