/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.serde;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.common.proto.Serde;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.utils.serde.AbstractKafkaSerializer;
import io.apicurio.registry.utils.serde.strategy.ArtifactIdStrategy;
import io.apicurio.registry.utils.serde.strategy.GlobalIdStrategy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.kafka.common.header.Headers;

public class ProtobufKafkaSerializer<U extends Message>
extends AbstractKafkaSerializer<byte[], U, ProtobufKafkaSerializer<U>> {
    public ProtobufKafkaSerializer() {
    }

    public ProtobufKafkaSerializer(RegistryService client) {
        super(client);
    }

    public ProtobufKafkaSerializer(RegistryService client, ArtifactIdStrategy<byte[]> artifactIdStrategy, GlobalIdStrategy<byte[]> idStrategy) {
        super(client, artifactIdStrategy, idStrategy);
    }

    @Override
    protected byte[] toSchema(U data) {
        Serde.Schema schema = this.toSchemaProto(data.getDescriptorForType().getFile());
        return schema.toByteArray();
    }

    private Serde.Schema toSchemaProto(Descriptors.FileDescriptor file) {
        Serde.Schema.Builder b = Serde.Schema.newBuilder();
        b.setFile(file.toProto());
        for (Descriptors.FileDescriptor d : file.getDependencies()) {
            b.addImport(this.toSchemaProto(d));
        }
        return b.build();
    }

    @Override
    protected ArtifactType artifactType() {
        return ArtifactType.PROTOBUF_FD;
    }

    @Override
    protected void serializeData(byte[] schema, U data, OutputStream out) throws IOException {
        Serde.Ref ref = Serde.Ref.newBuilder().setName(data.getDescriptorForType().getName()).build();
        ref.writeDelimitedTo(out);
        data.writeTo(out);
    }

    @Override
    protected void serializeData(Headers headers, byte[] schema, U data, ByteArrayOutputStream out) throws IOException {
        this.serializeData(schema, data, (OutputStream)out);
    }
}

